/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.ttzero.excel.annotation.DisplayName;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.IgnoreExport;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ListSheet<T>
extends Sheet {
    protected List<T> data;
    private Field[] fields;
    protected int start;
    protected int end;
    protected boolean eof;
    private int size;
    private static final String[] exclude = new String[]{"serialVersionUID", "this$0"};

    public ListSheet() {
    }

    public ListSheet(String name) {
        super(name);
    }

    public ListSheet(String name, Sheet.Column ... columns) {
        super(name, columns);
    }

    public ListSheet(String name, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListSheet(List<T> data) {
        this(null, data);
    }

    public ListSheet(String name, List<T> data) {
        super(name);
        this.setData(data);
    }

    public ListSheet(List<T> data, Sheet.Column ... columns) {
        this(null, data, columns);
    }

    public ListSheet(String name, List<T> data, Sheet.Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListSheet(List<T> data, WaterMark waterMark, Sheet.Column ... columns) {
        this(null, data, waterMark, columns);
    }

    public ListSheet(String name, List<T> data, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    public ListSheet<T> setData(List<T> data) {
        this.data = data;
        if (!this.headerReady && this.workbook != null) {
            this.getHeaderColumns();
        }
        if (data != null && this.sheetWriter != null) {
            this.paging();
        }
        return this;
    }

    protected T getFirst() {
        if (this.data == null) {
            return null;
        }
        T first = this.data.get(this.start);
        if (first != null) {
            return first;
        }
        int i = this.start + 1;
        while ((first = this.data.get(i++)) == null) {
        }
        return first;
    }

    @Override
    public void close() throws IOException {
        List<T> list;
        if (!this.eof && this.rows >= this.sheetWriter.getRowLimit() - 1 && (list = this.more()) != null && !list.isEmpty()) {
            this.compact();
            this.data.addAll(list);
            ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
            copy.start = 0;
            copy.end = list.size();
            this.workbook.insertSheet(this.id, copy);
            this.shouldClose = false;
        }
        if (this.shouldClose && this.data != null) {
            this.data = null;
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.size() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        try {
            while (this.start < end) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                Cell[] cells = row.realloc(len);
                for (int i = 0; i < len; ++i) {
                    Field field = this.fields[i];
                    Cell cell = cells[i];
                    cell.clear();
                    Object e = field.get(this.data.get(this.start));
                    this.setCellValueAndStyle(cell, e, this.columns[i]);
                }
                ++this.rows;
                ++this.start;
            }
        }
        catch (IllegalAccessException e) {
            throw new ExcelWriteException(e);
        }
    }

    protected void append() {
        block4: {
            int rbs = this.getRowBlockSize();
            while (true) {
                List<T> list;
                if ((list = this.more()) == null || list.isEmpty()) {
                    this.shouldClose = true;
                    this.eof = true;
                    break block4;
                }
                if (this.data == null) {
                    this.setData(list);
                    if (list.size() < rbs) {
                        continue;
                    }
                    break block4;
                }
                this.compact();
                this.data.addAll(list);
                this.start = 0;
                this.end = this.data.size();
                if (this.end >= rbs) break;
            }
            this.paging();
        }
    }

    private void compact() {
        int size = this.size();
        if (this.start > 0 && size > 0) {
            ArrayList<T> last = new ArrayList<T>(size);
            last.addAll(this.data.subList(this.start, this.end));
            this.data.clear();
            this.data.addAll(last);
        } else if (this.start > 0) {
            this.data.clear();
        }
    }

    private Field[] init() {
        T o = this.getFirst();
        if (o == null) {
            return null;
        }
        if (!this.hasHeaderColumns()) {
            int i;
            Field[] fields = o.getClass().getDeclaredFields();
            ArrayList<Sheet.Column> list = new ArrayList<Sheet.Column>(fields.length);
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String gs = field.toGenericString();
                IgnoreExport notExport = field.getAnnotation(IgnoreExport.class);
                if (notExport != null || StringUtil.indexOf(exclude, gs.substring(gs.lastIndexOf(46) + 1)) >= 0) {
                    fields[i] = null;
                    continue;
                }
                DisplayName dn = field.getAnnotation(DisplayName.class);
                ExcelColumn ec = field.getAnnotation(ExcelColumn.class);
                if (ec != null && StringUtil.isNotEmpty(ec.value())) {
                    list.add(new Sheet.Column(ec.value(), field.getName(), field.getType()).setShare(ec.share()));
                    continue;
                }
                if (dn != null && StringUtil.isNotEmpty(dn.value())) {
                    list.add(new Sheet.Column(dn.value(), field.getName(), field.getType()).setShare(dn.share()));
                    continue;
                }
                list.add(new Sheet.Column(field.getName(), field.getName(), field.getType()).setShare(dn == null || dn.share()));
            }
            this.columns = new Sheet.Column[list.size()];
            list.toArray(this.columns);
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].styles = this.workbook.getStyles();
            }
            int len = fields.length;
            for (int n = len - 1; n >= 0; --n) {
                if (fields[n] != null) {
                    fields[n].setAccessible(true);
                    continue;
                }
                if (n < len - 1) {
                    System.arraycopy(fields, n + 1, fields, n, len - n - 1);
                }
                --len;
            }
            return fields;
        }
        Field[] fields = new Field[this.columns.length];
        Class<?> clazz = o.getClass();
        for (int i = 0; i < this.columns.length; ++i) {
            Sheet.Column hc = this.columns[i];
            try {
                fields[i] = clazz.getDeclaredField(hc.key);
                fields[i].setAccessible(true);
                if (hc.getClazz() != null) continue;
                hc.setClazz(fields[i].getType());
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new ExcelWriteException("Column " + hc.getName() + " not declare in class " + clazz);
            }
        }
        return fields;
    }

    @Override
    public Sheet.Column[] getHeaderColumns() {
        if (!this.headerReady) {
            this.fields = this.init();
            if (this.fields == null || this.fields.length == 0 || this.fields[0] == null) {
                this.columns = new Sheet.Column[0];
            } else {
                this.checkColumnLimit();
                this.headerReady = true;
            }
        }
        return this.columns;
    }

    protected int getEndIndex() {
        int end;
        int rowLimit;
        int blockSize = this.getRowBlockSize();
        if (this.rows + blockSize > (rowLimit = this.sheetWriter.getRowLimit() - 1)) {
            blockSize = rowLimit - this.rows;
        }
        return (end = this.start + blockSize) <= this.end ? end : this.end;
    }

    @Override
    public int size() {
        return !this.shouldClose ? this.size : -1;
    }

    @Override
    protected void paging() {
        int limit;
        int len = this.dataSize();
        if (len + this.rows > (limit = this.sheetWriter.getRowLimit() - 1)) {
            this.end = limit - this.rows + this.start;
            this.shouldClose = false;
            this.eof = true;
            this.size = limit;
            int n = this.id;
            int i = this.end;
            while (i < len) {
                ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
                copy.start = i;
                i = i + limit < len ? i + limit : len;
                copy.end = i;
                copy.size = copy.end - copy.start;
                copy.eof = copy.size == limit;
                this.workbook.insertSheet(n++, copy);
            }
            this.workbook.getSheetAt((int)(n - 1)).shouldClose = true;
        } else {
            this.end = len;
            this.size += len;
        }
    }

    public int dataSize() {
        return this.data != null ? this.data.size() : 0;
    }

    protected List<T> more() {
        return null;
    }
}

