/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ttzero.excel.entity.EmptySheet;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.I18N;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.ListMapSheet;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.ResultSetSheet;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.StatementSheet;
import org.ttzero.excel.entity.Storageable;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.e7.XMLWorkbookWriter;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.processor.ParamProcessor;
import org.ttzero.excel.processor.Watch;
import org.ttzero.excel.util.FileUtil;

public class Workbook
implements Storageable {
    private Logger logger = LogManager.getLogger(this.getClass());
    private String name;
    private Sheet[] sheets;
    private WaterMark waterMark;
    private int size;
    private Connection con;
    private boolean autoSize;
    private int autoOdd = 0;
    private String creator;
    private String company;
    private Fill oddFill;
    private Watch watch;
    private I18N i18N;
    private SharedStrings sst;
    private Styles styles;
    private IWorkbookWriter workbookWriter;
    private InputStream is;
    private Object o;

    public Workbook() {
        this(null);
    }

    public Workbook(String name) {
        this(name, null);
    }

    public Workbook(String name, String creator) {
        this.name = name;
        this.creator = creator;
        this.sheets = new Sheet[3];
        this.sst = new SharedStrings();
        this.i18N = new I18N();
        this.styles = Styles.create(this.i18N);
        this.workbookWriter = new XMLWorkbookWriter(this);
    }

    public String getName() {
        return this.name;
    }

    public Workbook setName(String name) {
        this.name = name;
        return this;
    }

    public int getAutoOdd() {
        return this.autoOdd;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCompany() {
        return this.company;
    }

    public Fill getOddFill() {
        return this.oddFill;
    }

    public I18N getI18N() {
        return this.i18N;
    }

    public int getSize() {
        return this.size;
    }

    public SharedStrings getSst() {
        return this.sst;
    }

    public final Sheet[] getSheets() {
        return Arrays.copyOf(this.sheets, this.size);
    }

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public Workbook setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
        return this;
    }

    public Workbook setConnection(Connection con) {
        this.con = con;
        return this;
    }

    public Workbook setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        return this;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public Styles getStyles() {
        return this.styles;
    }

    public Workbook setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public Workbook setCompany(String company) {
        this.company = company;
        return this;
    }

    public Workbook cancelOddFill() {
        this.autoOdd = 1;
        return this;
    }

    public Workbook setOddFill(Fill fill) {
        this.oddFill = fill;
        return this;
    }

    public Workbook addSheet(Sheet sheet) {
        this.ensureCapacityInternal();
        sheet.setWorkbook(this);
        this.sheets[this.size++] = sheet;
        return this;
    }

    public Workbook addSheet(List<?> data, Sheet.Column ... columns) {
        return this.addSheet(null, data, columns);
    }

    public Workbook addSheet(String name, List<?> data, Sheet.Column ... columns) {
        Object o;
        if (data == null || data.isEmpty() || (o = this.getFirst(data)) == null) {
            this.addSheet(new EmptySheet(name, columns));
            return this;
        }
        if (o instanceof Map) {
            this.addSheet(new ListMapSheet(name, columns).setData(data));
        } else {
            this.addSheet(new ListSheet(name, columns).setData(data));
        }
        return this;
    }

    private Object getFirst(List<?> data) {
        if (data == null) {
            return null;
        }
        Object first = data.get(0);
        if (first != null) {
            return first;
        }
        int i = 1;
        while ((first = data.get(i++)) == null) {
        }
        return first;
    }

    public Workbook addSheet(ResultSet rs, Sheet.Column ... columns) {
        return this.addSheet(null, rs, columns);
    }

    public Workbook addSheet(String name, ResultSet rs, Sheet.Column ... columns) {
        ResultSetSheet sheet = new ResultSetSheet(name, columns);
        sheet.setRs(rs);
        this.addSheet(sheet);
        return this;
    }

    public Workbook addSheet(String sql, Sheet.Column ... columns) throws SQLException {
        return this.addSheet(null, sql, columns);
    }

    public Workbook addSheet(String name, String sql, Sheet.Column ... columns) throws SQLException {
        StatementSheet sheet = new StatementSheet(name, columns);
        PreparedStatement ps = this.con.prepareStatement(sql, 1003, 1007);
        try {
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException e) {
            this.watch.what("Not support fetch size value of -2147483648");
        }
        sheet.setPs(ps);
        this.addSheet(sheet);
        return this;
    }

    public Workbook addSheet(String sql, ParamProcessor pp, Sheet.Column ... columns) throws SQLException {
        return this.addSheet(null, sql, pp, columns);
    }

    public Workbook addSheet(String name, String sql, ParamProcessor pp, Sheet.Column ... columns) throws SQLException {
        StatementSheet sheet = new StatementSheet(name, columns);
        PreparedStatement ps = this.con.prepareStatement(sql, 1003, 1007);
        try {
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException e) {
            this.watch.what("Not support fetch size value of -2147483648");
        }
        pp.build(ps);
        sheet.setPs(ps);
        this.addSheet(sheet);
        return this;
    }

    public Workbook addSheet(PreparedStatement ps, Sheet.Column ... columns) throws SQLException {
        return this.addSheet(null, ps, columns);
    }

    public Workbook addSheet(String name, PreparedStatement ps, Sheet.Column ... columns) throws SQLException {
        StatementSheet sheet = new StatementSheet(name, columns);
        try {
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException e) {
            this.watch.what("Not support fetch size value of -2147483648");
        }
        sheet.setPs(ps);
        this.addSheet(sheet);
        return this;
    }

    public Workbook addSheet(PreparedStatement ps, ParamProcessor pp, Sheet.Column ... columns) throws SQLException {
        return this.addSheet(null, ps, pp, columns);
    }

    public Workbook addSheet(String name, PreparedStatement ps, ParamProcessor pp, Sheet.Column ... columns) throws SQLException {
        this.ensureCapacityInternal();
        StatementSheet sheet = new StatementSheet(name, columns);
        try {
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException e) {
            this.watch.what("Not support fetch size value of -2147483648");
        }
        pp.build(ps);
        sheet.setPs(ps);
        this.addSheet(sheet);
        return this;
    }

    public Workbook insertSheet(int index, Sheet sheet) {
        this.ensureCapacityInternal();
        if (this.sheets[index] != null) {
            for (int _size = this.size; _size > index; --_size) {
                this.sheets[_size] = this.sheets[_size - 1];
                this.sheets[_size].setId(this.sheets[_size].getId() + 1);
            }
        }
        this.sheets[index] = sheet;
        sheet.setId(index + 1);
        sheet.setWorkbook(this);
        ++this.size;
        return this;
    }

    public Workbook remove(int index) {
        if (index < 0 || index >= this.size) {
            return this;
        }
        if (index == this.size - 1) {
            this.sheets[index] = null;
        } else {
            while (index < this.size - 1) {
                this.sheets[index] = this.sheets[index + 1];
                this.sheets[index].setId(this.sheets[index].getId() - 1);
                ++index;
            }
        }
        --this.size;
        return this;
    }

    public Sheet getSheetAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.sheets[index];
    }

    public Sheet getSheet(String sheetName) {
        for (Sheet sheet : this.sheets) {
            if (!sheet.getName().equals(sheetName)) continue;
            return sheet;
        }
        return null;
    }

    public Workbook watch(Watch watch) {
        this.watch = watch;
        return this;
    }

    public Workbook saveAsExcel2003() throws OperationNotSupportedException {
        try {
            Class<?> clazz = Class.forName("org.ttzero.excel.entity.e3.BIFF8WorkbookWriter");
            Constructor<?> constructor = clazz.getDeclaredConstructor(this.getClass());
            this.workbookWriter = (IWorkbookWriter)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new OperationNotSupportedException("Excel97-2003 Not support now.");
        }
        return this;
    }

    public void what(String code) {
        String msg = this.i18N.get(code);
        this.logger.debug(msg);
        if (this.watch != null) {
            this.watch.what(msg);
        }
    }

    public void what(String code, String ... args) {
        String msg = this.i18N.get(code, args);
        this.logger.debug(msg);
        if (this.watch != null) {
            this.watch.what(msg);
        }
    }

    private void ensureCapacityInternal() {
        if (this.size >= this.sheets.length) {
            this.sheets = Arrays.copyOf(this.sheets, this.size + 1);
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            String name = path.getFileName().toString();
            if (name.indexOf(46) > 0) {
                Path parent = path.getParent();
                FileUtil.mkdir(parent);
                this.writeTo(path.toFile());
                return;
            }
            FileUtil.mkdir(path);
        } else if (!Files.isDirectory(path, new LinkOption[0])) {
            this.writeTo(path.toFile());
            return;
        }
        this.workbookWriter.writeTo(path);
    }

    public void writeTo(OutputStream os) throws IOException, ExcelWriteException {
        this.workbookWriter.writeTo(os);
    }

    public void writeTo(File file) throws IOException, ExcelWriteException {
        if (!file.getParentFile().exists()) {
            FileUtil.mkdir(file.toPath().getParent());
        }
        this.workbookWriter.writeTo(file);
    }

    public InputStream getTemplate() {
        return this.is;
    }

    public Object getBind() {
        return this.o;
    }

    public Workbook withTemplate(InputStream is, Object o) {
        this.is = is;
        this.o = o;
        return this;
    }

    protected Path template() throws IOException {
        return this.workbookWriter.template();
    }

    public Workbook setWorkbookWriter(IWorkbookWriter workbookWriter) {
        this.workbookWriter = workbookWriter;
        this.workbookWriter.setWorkbook(this);
        return this;
    }
}

