/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import java.lang.reflect.Field;
import org.dom4j.Element;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.ColorParseException;
import org.ttzero.excel.entity.style.PatternType;
import org.ttzero.excel.util.StringUtil;

public class Fill
implements Cloneable {
    private PatternType patternType;
    private Color bgColor;
    private Color fgColor;

    public Fill(PatternType patternType, Color bgColor, Color fgColor) {
        this.patternType = patternType;
        this.bgColor = bgColor;
        this.fgColor = fgColor;
    }

    public Fill(PatternType patternType, Color fgColor) {
        this.patternType = patternType;
        this.fgColor = fgColor;
    }

    public Fill(PatternType patternType) {
        this.patternType = patternType;
    }

    public Fill(Color fgColor) {
        this.fgColor = fgColor;
        this.patternType = PatternType.solid;
    }

    public Fill() {
    }

    public PatternType getPatternType() {
        return this.patternType;
    }

    public Fill setPatternType(PatternType patternType) {
        this.patternType = patternType;
        return this;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Fill setBgColor(Color bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public Fill setFgColor(Color fgColor) {
        this.fgColor = fgColor;
        return this;
    }

    public int hashCode() {
        int hash = 0;
        if (this.patternType != null) {
            hash += this.patternType.ordinal() << 24;
        }
        int c = 0;
        if (this.bgColor != null) {
            c += this.bgColor.hashCode();
        }
        if (this.fgColor != null) {
            c += this.fgColor.hashCode();
        }
        return hash + (c << 8 >>> 8);
    }

    public boolean equals(Object o) {
        if (o instanceof Fill) {
            Fill other = (Fill)o;
            return other.patternType == this.patternType && (other.bgColor != null ? other.bgColor.equals(this.bgColor) : null == this.bgColor) && (other.fgColor != null ? other.fgColor.equals(this.fgColor) : null == this.fgColor);
        }
        return false;
    }

    public static Fill parse(String text) {
        Fill fill = new Fill();
        if (StringUtil.isNotEmpty(text)) {
            String[] values;
            for (String v : values = text.split(" ")) {
                PatternType patternType;
                try {
                    patternType = PatternType.valueOf(v);
                }
                catch (IllegalArgumentException e) {
                    patternType = null;
                }
                if (patternType == null) {
                    Color color;
                    if (v.charAt(0) == '#') {
                        color = Color.decode(v);
                    } else {
                        try {
                            Field field = Color.class.getDeclaredField(v);
                            color = (Color)field.get(null);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            throw new ColorParseException("Color \"" + v + "\" not support.");
                        }
                    }
                    if (fill.fgColor == null) {
                        fill.fgColor = color;
                        continue;
                    }
                    fill.bgColor = color;
                    continue;
                }
                fill.patternType = patternType;
            }
        }
        if (fill.patternType == null) {
            fill.patternType = PatternType.solid;
        }
        return fill;
    }

    Element toDom4j(Element root) {
        int colorIndex;
        if (this.patternType == null) {
            this.patternType = PatternType.solid;
        }
        Element element = root.addElement(StringUtil.lowFirstKey(this.getClass().getSimpleName()));
        Element patternFill = element.addElement("patternFill").addAttribute("patternType", this.patternType.name());
        if (this.fgColor != null) {
            colorIndex = ColorIndex.indexOf(this.fgColor);
            if (colorIndex > -1) {
                patternFill.addElement("fgColor").addAttribute("indexed", String.valueOf(colorIndex));
            } else {
                patternFill.addElement("fgColor").addAttribute("rgb", ColorIndex.toARGB(this.fgColor));
            }
        }
        if (this.bgColor != null) {
            colorIndex = ColorIndex.indexOf(this.bgColor);
            if (colorIndex > -1) {
                patternFill.addElement("bgColor").addAttribute("indexed", String.valueOf(colorIndex));
            } else {
                patternFill.addElement("bgColor").addAttribute("rgb", ColorIndex.toARGB(this.bgColor));
            }
        }
        return element;
    }

    public Fill clone() {
        Fill other;
        try {
            other = (Fill)super.clone();
        }
        catch (CloneNotSupportedException e) {
            other = new Fill();
            other.patternType = this.patternType;
        }
        if (this.bgColor != null) {
            other.bgColor = new Color(this.bgColor.getRGB());
        }
        if (this.fgColor != null) {
            other.fgColor = new Color(this.fgColor.getRGB());
        }
        return other;
    }
}

