/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.annotation.NS;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.ExcelType;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.docProps.App;
import org.ttzero.excel.manager.docProps.Core;
import org.ttzero.excel.reader.AppInfo;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.util.ZipUtil;

public class ExcelReader
implements AutoCloseable {
    private Logger logger = LogManager.getLogger(this.getClass());
    protected Path self;
    protected Sheet[] sheets;
    private Path temp;
    private ExcelType type;
    private AppInfo appInfo;
    private SharedStrings sst;
    private Styles styles;

    protected ExcelReader() {
    }

    public static ExcelReader read(Path path) throws IOException {
        return ExcelReader.read(path, 0, 0);
    }

    public static ExcelReader read(InputStream stream) throws IOException {
        return ExcelReader.read(stream, 0, 0);
    }

    public static ExcelReader read(Path path, int bufferSize) throws IOException {
        return ExcelReader.read(path, bufferSize, 0);
    }

    public static ExcelReader read(InputStream stream, int bufferSize) throws IOException {
        return ExcelReader.read(stream, bufferSize, 0);
    }

    public static ExcelReader read(Path path, int bufferSize, int cacheSize) throws IOException {
        return ExcelReader.read(path, bufferSize, cacheSize, false);
    }

    public static ExcelReader read(InputStream stream, int bufferSize, int cacheSize) throws IOException {
        Path temp = FileUtil.isWindows() ? Files.createTempFile("eec+", null, new FileAttribute[0]) : Files.createTempFile("eec+", null, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
        if (temp == null) {
            throw new IOException("Create temp directory error. Please check your permission");
        }
        FileUtil.cp(stream, temp);
        return ExcelReader.read(temp, bufferSize, cacheSize, true);
    }

    public ExcelType getType() {
        return this.type;
    }

    public Stream<Sheet> sheets() {
        Iterator<Sheet> iter = new Iterator<Sheet>(){
            int n = 0;

            @Override
            public boolean hasNext() {
                return this.n < ExcelReader.this.sheets.length;
            }

            @Override
            public Sheet next() {
                try {
                    return ExcelReader.this.sheets[this.n++].load();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return StreamSupport.stream(Spliterators.spliterator(iter, (long)this.sheets.length, 272), false);
    }

    public Sheet sheet(int index) {
        try {
            return this.sheets[index].load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Sheet sheet(String sheetName) {
        try {
            for (Sheet t : this.sheets) {
                if (!sheetName.equals(t.getName())) continue;
                return t.load();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    public Sheet[] all() {
        return this.sheets;
    }

    public int getSize() {
        return this.sheets != null ? this.sheets.length : 0;
    }

    @Override
    public void close() throws IOException {
        for (Sheet st : this.sheets) {
            st.close();
        }
        if (this.sst != null) {
            this.sst.close();
        }
        FileUtil.rm_rf(this.self.toFile(), true);
        if (this.temp != null) {
            FileUtil.rm(this.temp);
        }
    }

    public AppInfo getAppInfo() {
        if (this.appInfo == null) {
            this.appInfo = this.getGeneralInfo();
        }
        return this.appInfo;
    }

    private ExcelReader(Path path, int bufferSize, int cacheSize) throws IOException {
        Document document;
        Path temp = FileUtil.mktmp("eec+");
        ZipUtil.unzip(Files.newInputStream(path, new OpenOption[0]), temp);
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(Files.newInputStream(temp.resolve("xl/_rels/workbook.xml.rels"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            FileUtil.rm_rf(temp.toFile(), true);
            throw new ExcelReadException(e);
        }
        List list = document.getRootElement().elements();
        Relationship[] rels = new Relationship[list.size()];
        int i = 0;
        for (Element e : list) {
            rels[i++] = new Relationship(e.attributeValue("Id"), e.attributeValue("Target"), e.attributeValue("Type"));
        }
        RelManager relManager = RelManager.of(rels);
        try {
            document = reader.read(Files.newInputStream(temp.resolve("xl/workbook.xml"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            FileUtil.rm_rf(temp.toFile(), true);
            throw new ExcelReadException(e);
        }
        Element root = document.getRootElement();
        Namespace ns = root.getNamespaceForPrefix("r");
        this.sst = new SharedStrings(temp.resolve("xl/sharedStrings.xml"), bufferSize, cacheSize).load();
        this.styles = Styles.load(temp.resolve("xl/styles.xml"));
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        Iterator sheetIter = root.element("sheets").elementIterator();
        while (sheetIter.hasNext()) {
            Element e = (Element)sheetIter.next();
            XMLSheet sheet = new XMLSheet();
            sheet.setName(e.attributeValue("name"));
            sheet.setIndex(Integer.parseInt(e.attributeValue("sheetId")));
            String state = e.attributeValue("state");
            sheet.setHidden("hidden".equals(state));
            Relationship r = relManager.getById(e.attributeValue(QName.get((String)"id", (Namespace)ns)));
            if (r == null) {
                FileUtil.rm_rf(temp.toFile(), true);
                sheet.close();
                throw new ExcelReadException("File has be destroyed");
            }
            sheet.setPath(temp.resolve("xl").resolve(r.getTarget()));
            sheet.setSst(this.sst);
            sheet.setStyles(this.styles);
            sheets.add(sheet);
        }
        sheets.sort(Comparator.comparingInt(Sheet::getIndex));
        Sheet[] sheets1 = new Sheet[sheets.size()];
        sheets.toArray(sheets1);
        this.sheets = sheets1;
        this.self = temp;
    }

    private static ExcelReader read(Path path, int bufferSize, int cacheSize, boolean rmSource) throws IOException {
        ExcelReader er;
        ExcelType type = ExcelReader.getType(path);
        switch (type) {
            case XLSX: {
                er = new ExcelReader(path, bufferSize, cacheSize);
                break;
            }
            case XLS: {
                try {
                    Class<?> clazz = Class.forName("org.ttzero.excel.reader.BIFF8Reader");
                    Constructor<?> constructor = clazz.getDeclaredConstructor(Path.class, Integer.TYPE, Integer.TYPE);
                    er = (ExcelReader)constructor.newInstance(path, bufferSize, cacheSize);
                    break;
                }
                catch (Exception e) {
                    throw new ExcelReadException("Only support read Office Open XML file.", e);
                }
            }
            default: {
                throw new ExcelReadException("Unknown file type.");
            }
        }
        er.type = type;
        if (rmSource) {
            er.temp = path;
        }
        return er;
    }

    private static ExcelType getType(Path path) {
        ExcelType type;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            byte[] bytes = new byte[8];
            int len = is.read(bytes);
            type = ExcelReader.typeOfStream(bytes, len);
        }
        catch (IOException e) {
            type = ExcelType.UNKNOWN;
        }
        return type;
    }

    private static ExcelType typeOfStream(byte[] bytes, int size) {
        ExcelType excelType = ExcelType.UNKNOWN;
        int length = Math.min(bytes.length, size);
        if (length < 4) {
            return excelType;
        }
        int type = bytes[0] & 0xFF;
        type += (bytes[1] & 0xFF) << 8;
        type += (bytes[2] & 0xFF) << 16;
        int zip = 67324752;
        int b1 = -535703600;
        int b2 = -518344287;
        if ((type += (bytes[3] & 0xFF) << 24) == zip) {
            excelType = ExcelType.XLSX;
        } else if (type == b1 && length >= 8) {
            type = bytes[4] & 0xFF;
            type += (bytes[5] & 0xFF) << 8;
            type += (bytes[6] & 0xFF) << 16;
            if ((type += (bytes[7] & 0xFF) << 24) == b2) {
                excelType = ExcelType.XLS;
            }
        }
        return excelType;
    }

    protected AppInfo getGeneralInfo() {
        Document document;
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(Files.newInputStream(this.self.resolve("docProps/app.xml"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException(e);
        }
        Element root = document.getRootElement();
        App app = new App();
        app.setCompany(root.elementText("Company"));
        app.setApplication(root.elementText("Application"));
        app.setAppVersion(root.elementText("AppVersion"));
        try {
            document = reader.read(Files.newInputStream(this.self.resolve("docProps/core.xml"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException(e);
        }
        root = document.getRootElement();
        Core core = new Core();
        Class<Core> clazz = Core.class;
        TopNS topNS = clazz.getAnnotation(TopNS.class);
        String[] prefixs = topNS.prefix();
        String[] urls = topNS.uri();
        Field[] fields = clazz.getDeclaredFields();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        for (Field f : fields) {
            NS ns = f.getAnnotation(NS.class);
            if (ns == null) continue;
            f.setAccessible(true);
            int nsIndex = StringUtil.indexOf(prefixs, ns.value());
            if (nsIndex <= -1) continue;
            Namespace namespace = new Namespace(ns.value(), urls[nsIndex]);
            Class<?> type = f.getType();
            String v = root.elementText(new QName(f.getName(), namespace));
            if (type == String.class) {
                try {
                    f.set(core, v);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn("Set field (" + f + ") error.");
                }
                continue;
            }
            if (type != Date.class) continue;
            try {
                f.set(core, format.parse(v));
            }
            catch (IllegalAccessException | ParseException e) {
                this.logger.warn("Set field (" + f + ") error.");
            }
        }
        return new AppInfo(app, core);
    }
}

