/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.StringJoiner;
import org.ttzero.excel.annotation.DisplayName;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.IgnoreImport;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.util.StringUtil;

class HeaderRow
extends Row {
    private String[] names;
    private Class<?> clazz;
    private Field[] fields;
    private int[] columns;
    private Class<?>[] fieldClazz;
    private Object t;

    private HeaderRow() {
    }

    static HeaderRow with(Row row) {
        int i;
        HeaderRow hr = new HeaderRow();
        hr.names = new String[row.lc];
        for (i = row.fc; i < row.lc; ++i) {
            hr.names[i] = row.getString(i);
        }
        hr.fc = row.fc;
        hr.lc = row.lc;
        hr.index = row.index;
        hr.cells = new Cell[hr.names.length];
        for (i = 0; i < row.fc; ++i) {
            hr.cells[i] = new Cell();
        }
        for (i = row.fc; i < row.lc; ++i) {
            Cell cell = new Cell();
            cell.setSv(hr.names[i]);
            hr.cells[i] = cell;
        }
        return hr;
    }

    final boolean is(Class<?> clazz) {
        return this.clazz != null && this.clazz == clazz;
    }

    final HeaderRow setClass(Class<?> clazz) {
        int i;
        this.clazz = clazz;
        Field[] fields = clazz.getDeclaredFields();
        int[] index = new int[fields.length];
        int count = 0;
        for (i = 0; i < fields.length; ++i) {
            int n;
            Field f = fields[i];
            IgnoreImport nit = f.getAnnotation(IgnoreImport.class);
            if (nit != null) {
                fields[i] = null;
                continue;
            }
            DisplayName ano = f.getAnnotation(DisplayName.class);
            ExcelColumn ec = f.getAnnotation(ExcelColumn.class);
            if (ec != null && StringUtil.isNotEmpty(ec.value())) {
                n = StringUtil.indexOf(this.names, ec.value());
                if (n == -1) {
                    this.logger.warn(clazz + " field [" + ec.value() + "] can't find in header" + Arrays.toString(this.names));
                    fields[i] = null;
                    continue;
                }
            } else if (ano != null && StringUtil.isNotEmpty(ano.value())) {
                n = StringUtil.indexOf(this.names, ano.value());
                if (n == -1) {
                    this.logger.warn(clazz + " field [" + ano.value() + "] can't find in header" + Arrays.toString(this.names));
                    fields[i] = null;
                    continue;
                }
            } else {
                String name = f.getName();
                n = StringUtil.indexOf(this.names, name);
                if (n == -1 && (n = StringUtil.indexOf(this.names, StringUtil.toPascalCase(name))) == -1) {
                    fields[i] = null;
                    continue;
                }
            }
            index[i] = n;
            ++count;
        }
        this.fields = new Field[count];
        this.columns = new int[count];
        this.fieldClazz = new Class[count];
        for (i = fields.length - 1; i >= 0; --i) {
            if (fields[i] == null) continue;
            this.fields[--count] = fields[i];
            this.fields[count].setAccessible(true);
            this.columns[count] = index[i];
            this.fieldClazz[count] = fields[i].getType();
        }
        return this;
    }

    final HeaderRow setClassOnce(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        this.setClass(clazz);
        this.t = clazz.newInstance();
        return this;
    }

    final Field[] getFields() {
        return this.fields;
    }

    final int[] getColumns() {
        return this.columns;
    }

    final Class<?>[] getFieldClazz() {
        return this.fieldClazz;
    }

    final <T> T getT() {
        return (T)this.t;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public CellType getCellType(int columnIndex) {
        return CellType.STRING;
    }

    public String get(int columnIndex) {
        this.rangeCheck(columnIndex);
        return this.names[columnIndex];
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(" | ");
        int i = 0;
        while (this.names[i++] == null) {
        }
        while (i < this.names.length) {
            joiner.add(this.names[i]);
            ++i;
        }
        return joiner.toString();
    }

    void put(Row row, Object t) throws IllegalAccessException {
        for (int i = 0; i < this.columns.length; ++i) {
            int c = this.columns[i];
            if (this.fieldClazz[i] == String.class) {
                this.fields[i].set(t, row.getString(c));
                continue;
            }
            if (this.fieldClazz[i] == Integer.TYPE || this.fieldClazz[i] == Integer.class) {
                this.fields[i].set(t, row.getInt(c));
                continue;
            }
            if (this.fieldClazz[i] == Long.TYPE || this.fieldClazz[i] == Long.class) {
                this.fields[i].set(t, row.getLong(c));
                continue;
            }
            if (this.fieldClazz[i] == java.util.Date.class || this.fieldClazz[i] == Date.class) {
                this.fields[i].set(t, row.getDate(c));
                continue;
            }
            if (this.fieldClazz[i] == Timestamp.class) {
                this.fields[i].set(t, row.getTimestamp(c));
                continue;
            }
            if (this.fieldClazz[i] == Double.TYPE || this.fieldClazz[i] == Double.class) {
                this.fields[i].set(t, row.getDouble(c));
                continue;
            }
            if (this.fieldClazz[i] == Float.TYPE || this.fieldClazz[i] == Float.class) {
                this.fields[i].set(t, Float.valueOf(row.getFloat(c)));
                continue;
            }
            if (this.fieldClazz[i] == Boolean.TYPE || this.fieldClazz[i] == Boolean.class) {
                this.fields[i].set(t, row.getBoolean(c));
                continue;
            }
            if (this.fieldClazz[i] == Character.TYPE || this.fieldClazz[i] == Character.class) {
                this.fields[i].set(t, Character.valueOf(row.getChar(c)));
                continue;
            }
            if (this.fieldClazz[i] == Byte.TYPE || this.fieldClazz[i] == Byte.class) {
                this.fields[i].set(t, row.getByte(c));
                continue;
            }
            if (this.fieldClazz[i] != Short.TYPE && this.fieldClazz[i] != Short.class) continue;
            this.fields[i].set(t, row.getShort(c));
        }
    }
}

