/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.UncheckedTypeException;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

public abstract class Row {
    protected Logger logger = LogManager.getLogger(this.getClass());
    int index = -1;
    int fc = 0;
    int lc = -1;
    Cell[] cells;
    SharedStrings sst;
    private HeaderRow hr;
    boolean unknownLength;
    Styles styles;

    public int getRowNumber() {
        return this.index;
    }

    public int getFirstColumnIndex() {
        return this.fc;
    }

    public int getLastColumnIndex() {
        return this.lc;
    }

    public boolean isEmpty() {
        return this.lc - this.fc <= 0;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.lc;
    }

    protected void rangeCheck(int index) {
        if (index >= this.lc) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected Cell getCell(int i) {
        this.rangeCheck(i);
        return this.cells[i];
    }

    public HeaderRow asHeader() {
        HeaderRow hr;
        this.hr = hr = HeaderRow.with(this);
        return hr;
    }

    Row setHr(HeaderRow hr) {
        this.hr = hr;
        return this;
    }

    public boolean getBoolean(int columnIndex) {
        boolean v;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'b': {
                v = c.bv;
                break;
            }
            case 'd': 
            case 'n': {
                v = c.nv != 0 || c.dv >= 1.0E-6 || c.dv <= -1.0E-6;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                v = StringUtil.isNotEmpty(c.sv);
                break;
            }
            case 'r': {
                v = StringUtil.isNotEmpty(c.sv);
                break;
            }
            default: {
                v = false;
            }
        }
        return v;
    }

    public byte getByte(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        byte b = 0;
        switch (c.t) {
            case 'n': {
                b = (byte)(b | c.nv);
                break;
            }
            case 'l': {
                b = (byte)((long)b | c.lv);
                break;
            }
            case 'b': {
                b = (byte)(b | (c.bv ? 1 : 0));
                break;
            }
            case 'd': {
                b = (byte)(b | (int)c.dv);
                break;
            }
            default: {
                throw new UncheckedTypeException("can't convert to byte");
            }
        }
        return b;
    }

    public char getChar(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        char cc = '\u0000';
        switch (c.t) {
            case 's': {
                String s;
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                if (!StringUtil.isNotEmpty(s = c.sv)) break;
                cc = (char)(cc | s.charAt(0));
                break;
            }
            case 'r': {
                String s = c.sv;
                if (!StringUtil.isNotEmpty(s)) break;
                cc = (char)(cc | s.charAt(0));
                break;
            }
            case 'n': {
                cc = (char)(cc | c.nv);
                break;
            }
            case 'l': {
                cc = (char)((long)cc | c.lv);
                break;
            }
            case 'b': {
                cc = (char)(cc | (c.bv ? 1 : 0));
                break;
            }
            case 'd': {
                cc = (char)(cc | (int)c.dv);
                break;
            }
            default: {
                throw new UncheckedTypeException("can't convert to char");
            }
        }
        return cc;
    }

    public short getShort(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        short s = 0;
        switch (c.t) {
            case 'n': {
                s = (short)(s | c.nv);
                break;
            }
            case 'l': {
                s = (short)((long)s | c.lv);
                break;
            }
            case 'b': {
                s = (short)(s | (c.bv ? 1 : 0));
                break;
            }
            case 'd': {
                s = (short)(s | (int)c.dv);
                break;
            }
            default: {
                throw new UncheckedTypeException("can't convert to short");
            }
        }
        return s;
    }

    public int getInt(int columnIndex) {
        int n;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'n': {
                n = c.nv;
                break;
            }
            case 'l': {
                n = (int)c.lv;
                break;
            }
            case 'd': {
                n = (int)c.dv;
                break;
            }
            case 'b': {
                n = c.bv ? 1 : 0;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                try {
                    n = Integer.parseInt(c.sv);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedTypeException("String value " + c.sv + " can't convert to int");
                }
            }
            case 'r': {
                try {
                    n = Integer.parseInt(c.sv);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedTypeException("String value " + c.sv + " can't convert to int");
                }
            }
            default: {
                throw new UncheckedTypeException("unknown type");
            }
        }
        return n;
    }

    public long getLong(int columnIndex) {
        long l;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'l': {
                l = c.lv;
                break;
            }
            case 'n': {
                l = c.nv;
                break;
            }
            case 'd': {
                l = (long)c.dv;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                try {
                    l = Long.parseLong(c.sv);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedTypeException("String value " + c.sv + " can't convert to long");
                }
            }
            case 'r': {
                try {
                    l = Long.parseLong(c.sv);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedTypeException("String value " + c.sv + " can't convert to long");
                }
            }
            case 'b': {
                l = c.bv ? 1L : 0L;
                break;
            }
            default: {
                throw new UncheckedTypeException("unknown type");
            }
        }
        return l;
    }

    public String getString(int columnIndex) {
        String s;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                s = c.sv;
                break;
            }
            case 'r': {
                s = c.sv;
                break;
            }
            case 'k': {
                s = "";
                break;
            }
            case 'l': {
                s = String.valueOf(c.lv);
                break;
            }
            case 'n': {
                s = String.valueOf(c.nv);
                break;
            }
            case 'd': {
                s = String.valueOf(c.dv);
                break;
            }
            case 'b': {
                s = c.bv ? "true" : "false";
                break;
            }
            default: {
                s = c.sv;
            }
        }
        return s;
    }

    public float getFloat(int columnIndex) {
        return (float)this.getDouble(columnIndex);
    }

    public double getDouble(int columnIndex) {
        double d;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'd': {
                d = c.dv;
                break;
            }
            case 'n': {
                d = c.nv;
                break;
            }
            case 's': {
                try {
                    d = Double.valueOf(c.sv);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedTypeException("String value " + c.sv + " can't convert to double");
                }
            }
            case 'r': {
                try {
                    d = Double.valueOf(c.sv);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedTypeException("String value " + c.sv + " can't convert to double");
                }
            }
            default: {
                throw new UncheckedTypeException("unknown type");
            }
        }
        return d;
    }

    public BigDecimal getDecimal(int columnIndex) {
        BigDecimal bd;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'd': {
                bd = BigDecimal.valueOf(c.dv);
                break;
            }
            case 'n': {
                bd = BigDecimal.valueOf(c.nv);
                break;
            }
            default: {
                bd = new BigDecimal(c.sv);
            }
        }
        return bd;
    }

    public Date getDate(int columnIndex) {
        Date date;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'n': {
                date = DateUtil.toDate(c.nv);
                break;
            }
            case 'd': {
                date = DateUtil.toDate(c.dv);
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                date = DateUtil.toDate(c.sv);
                break;
            }
            case 'r': {
                date = DateUtil.toDate(c.sv);
                break;
            }
            default: {
                throw new UncheckedTypeException("");
            }
        }
        return date;
    }

    public Timestamp getTimestamp(int columnIndex) {
        Timestamp ts;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'n': {
                ts = DateUtil.toTimestamp(c.nv);
                break;
            }
            case 'd': {
                ts = DateUtil.toTimestamp(c.dv);
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                ts = DateUtil.toTimestamp(c.sv);
                break;
            }
            case 'r': {
                ts = DateUtil.toTimestamp(c.sv);
                break;
            }
            default: {
                throw new UncheckedTypeException("");
            }
        }
        return ts;
    }

    public Time getTime(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        if (c.t == 'd') {
            return DateUtil.toTime(c.dv);
        }
        throw new UncheckedTypeException("can't convert to java.sql.Time");
    }

    public CellType getCellType(int columnIndex) {
        CellType type;
        Cell c = this.getCell(columnIndex);
        switch (c.t) {
            case 'r': 
            case 's': {
                type = CellType.STRING;
                break;
            }
            case 'c': 
            case 'n': {
                type = !this.styles.fastTestDateFmt(c.s) ? CellType.INTEGER : CellType.DATE;
                break;
            }
            case 'l': {
                type = CellType.LONG;
                break;
            }
            case 'd': {
                type = !this.styles.fastTestDateFmt(c.s) ? CellType.DOUBLE : CellType.DATE;
                break;
            }
            case 'b': {
                type = CellType.BOOLEAN;
                break;
            }
            case 'a': 
            case 'i': 
            case 't': {
                type = CellType.DATE;
                break;
            }
            case 'k': {
                type = CellType.BLANK;
                break;
            }
            default: {
                type = CellType.STRING;
            }
        }
        return type;
    }

    public <T> T get() {
        if (this.hr != null && this.hr.getClazz() != null) {
            Object t;
            try {
                t = this.hr.getClazz().newInstance();
                this.hr.put(this, t);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UncheckedTypeException(this.hr.getClazz() + " new instance error.", e);
            }
            return (T)t;
        }
        return (T)this;
    }

    public <T> T geet() {
        if (this.hr != null && this.hr.getClazz() != null) {
            Object t = this.hr.getT();
            try {
                this.hr.put(this, t);
            }
            catch (IllegalAccessException e) {
                throw new UncheckedTypeException("call set method error.", e);
            }
            return t;
        }
        return (T)this;
    }

    public <T> T to(Class<T> clazz) {
        T t;
        if (this.hr == null) {
            throw new UncheckedTypeException("Lost header row info");
        }
        if (!this.hr.is(clazz)) {
            this.hr.setClass(clazz);
        }
        try {
            t = clazz.newInstance();
            this.hr.put(this, t);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UncheckedTypeException(clazz + " new instance error.", e);
        }
        return t;
    }

    public <T> T too(Class<T> clazz) {
        if (this.hr == null) {
            throw new UncheckedTypeException("Lost header row info");
        }
        if (!this.hr.is(clazz)) {
            try {
                this.hr.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UncheckedTypeException(clazz + " new instance error.", e);
            }
        }
        Object t = this.hr.getT();
        try {
            this.hr.put(this, t);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedTypeException("call set method error.", e);
        }
        return t;
    }

    public String toString() {
        if (this.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(" | ");
        block10: for (int i = this.fc; i < this.lc; ++i) {
            Cell c = this.cells[i];
            switch (c.t) {
                case 's': {
                    if (c.sv == null) {
                        c.setSv(this.sst.get(c.nv));
                    }
                    joiner.add(c.sv);
                    continue block10;
                }
                case 'r': {
                    joiner.add(c.sv);
                    continue block10;
                }
                case 'b': {
                    joiner.add(String.valueOf(c.bv));
                    continue block10;
                }
                case 'f': {
                    joiner.add("<function>");
                    continue block10;
                }
                case 'n': {
                    if (!this.styles.fastTestDateFmt(c.s)) {
                        joiner.add(String.valueOf(c.nv));
                        continue block10;
                    }
                    joiner.add(DateUtil.toLocalDate(c.nv).toString());
                    continue block10;
                }
                case 'l': {
                    joiner.add(String.valueOf(c.lv));
                    continue block10;
                }
                case 'd': {
                    if (!this.styles.fastTestDateFmt(c.s)) {
                        joiner.add(String.valueOf(c.dv));
                        continue block10;
                    }
                    joiner.add(DateUtil.toTimestamp(c.dv).toString());
                    continue block10;
                }
                case 'k': {
                    joiner.add("");
                }
                default: {
                    joiner.add(null);
                }
            }
        }
        return joiner.toString();
    }
}

