/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.util.StringUtil;

public interface Sheet
extends AutoCloseable {
    public String getName();

    public int getIndex();

    public int getSize();

    public boolean isHidden();

    default public boolean isShow() {
        return !this.isHidden();
    }

    public Row getHeader();

    public Sheet bind(Class<?> var1);

    public Sheet load() throws IOException;

    public Iterator<Row> iterator();

    public Iterator<Row> dataIterator();

    default public Sheet reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Stream<Row> rows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 272), false);
    }

    default public Stream<Row> dataRows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.dataIterator(), 272), false);
    }

    default public int col2Int(String col) {
        if (StringUtil.isEmpty(col)) {
            return 1;
        }
        char[] values = col.toCharArray();
        int n = 0;
        for (char value : values) {
            if (value < 'A' || value > 'Z') {
                throw new ExcelReadException("Column mark out of range: " + col);
            }
            n = n * 26 + value - 65 + 1;
        }
        return n;
    }

    @Override
    public void close() throws IOException;
}

