/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ttzero.excel.entity.TooManyColumnsException;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.RowSetIterator;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLRow;

class XMLSheet
implements Sheet {
    private Logger logger = LogManager.getLogger(this.getClass());
    private String name;
    private int index;
    private int size = -1;
    private Path path;
    private SharedStrings sst;
    private Styles styles;
    private int startRow = -1;
    private HeaderRow header;
    private boolean hidden;
    private BufferedReader reader;
    private char[] cb;
    private int nChar;
    private int length;
    private boolean eof = false;
    private boolean heof = false;
    private XMLRow sRow;

    XMLSheet() {
    }

    void setName(String name) {
        this.name = name;
    }

    void setPath(Path path) {
        this.path = path;
    }

    void setSst(SharedStrings sst) {
        this.sst = sst;
    }

    void setStyles(Styles styles) {
        this.styles = styles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public int getFirstRow() {
        return this.startRow;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    XMLSheet setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public Row getHeader() {
        XMLRow row;
        if (this.header == null && !this.heof && (row = this.findRow0()) != null) {
            this.header = row.asHeader();
            this.sRow.setHr(this.header);
        }
        return this.header;
    }

    @Override
    public XMLSheet bind(Class<?> clazz) {
        if (this.getHeader() != null) {
            try {
                this.header.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelReadException(e);
            }
        }
        return this;
    }

    public String toString() {
        return "Sheet name: " + this.name + " has " + this.size + " rows.";
    }

    @Override
    public XMLSheet load() throws IOException {
        this.logger.debug("load {}", (Object)this.path.toString());
        this.reader = Files.newBufferedReader(this.path);
        this.cb = new char[8192];
        this.nChar = 0;
        block0: while (true) {
            this.length = this.reader.read(this.cb);
            if (this.length < 11) break;
            if (this.nChar == 0) {
                int end;
                String line = new String(this.cb, 56, 1024);
                String size = "<dimension ref=\"";
                int index = line.indexOf(size);
                int n = end = index > 0 ? line.indexOf(34, index += size.length()) : -1;
                if (end > 0) {
                    String l_ = line.substring(index, end);
                    Pattern pat = Pattern.compile("([A-Z]+)(\\d+):([A-Z]+)(\\d+)");
                    Matcher mat = pat.matcher(l_);
                    if (mat.matches()) {
                        int from = Integer.parseInt(mat.group(2));
                        int to = Integer.parseInt(mat.group(4));
                        this.startRow = from;
                        this.size = to - from + 1;
                        int c1 = this.col2Int(mat.group(1));
                        int c2 = this.col2Int(mat.group(3));
                        int columnSize = c2 - c1 + 1;
                        if (columnSize > 16384) {
                            throw new TooManyColumnsException(columnSize, 16384);
                        }
                        this.logger.debug("column size: {}", (Object)columnSize);
                    } else {
                        pat = Pattern.compile("[A-Z]+(\\d+)");
                        mat = pat.matcher(l_);
                        if (mat.matches()) {
                            this.startRow = Integer.parseInt(mat.group(1));
                        }
                    }
                    this.nChar += end;
                }
            }
            while (true) {
                if (this.nChar >= this.length - 12) continue block0;
                if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == 's' && this.cb[this.nChar + 2] == 'h' && this.cb[this.nChar + 3] == 'e' && this.cb[this.nChar + 4] == 'e' && this.cb[this.nChar + 5] == 't' && this.cb[this.nChar + 6] == 'D' && this.cb[this.nChar + 7] == 'a' && this.cb[this.nChar + 8] == 't' && this.cb[this.nChar + 9] == 'a' && (this.cb[this.nChar + 10] == '>' || this.cb[this.nChar + 10] == '/' && this.cb[this.nChar + 11] == '>')) {
                    this.nChar += 11;
                    break block0;
                }
                ++this.nChar;
            }
            break;
        }
        if (this.cb[this.nChar] == '>') {
            ++this.nChar;
            this.eof = true;
        } else {
            this.eof = false;
            this.sRow = new XMLRow(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1);
        }
        return this;
    }

    private XMLRow nextRow() throws IOException {
        if (this.eof) {
            return null;
        }
        boolean endTag = false;
        int start = this.nChar;
        while (++this.nChar < this.length && this.cb[this.nChar] != '>') {
        }
        if (this.cb[this.nChar++ - 1] == '/') {
            return this.sRow.empty(this.cb, start, this.nChar - start);
        }
        while (this.nChar < this.length - 6) {
            if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == '/' && this.cb[this.nChar + 2] == 'r' && this.cb[this.nChar + 3] == 'o' && this.cb[this.nChar + 4] == 'w' && this.cb[this.nChar + 5] == '>') {
                this.nChar += 6;
                endTag = true;
                break;
            }
            ++this.nChar;
        }
        if (!endTag) {
            int n;
            if (start == 0) {
                char[] _cb = new char[this.cb.length << 1];
                n = this.length - start;
                System.arraycopy(this.cb, start, _cb, 0, n);
                this.cb = _cb;
            } else {
                n = this.length - start;
                System.arraycopy(this.cb, start, this.cb, 0, n);
            }
            this.length = this.reader.read(this.cb, n, this.cb.length - n);
            if (this.length < 0) {
                this.eof = true;
                this.reader.close();
                this.reader = null;
                this.logger.debug("end of file.");
                return null;
            }
            this.nChar = 0;
            this.length += n;
            return this.nextRow();
        }
        return this.sRow.with(this.cb, start, this.nChar - start);
    }

    /*
     * Unable to fully structure code
     */
    protected XMLRow findRow0() {
        block23: {
            cb = new char[8192];
            nChar = 0;
            try {
                reader = Files.newBufferedReader(this.path);
                var5_6 = null;
                try {
                    block11: while (true) {
                        length = reader.read(cb);
                        while (true) {
                            if (nChar >= length - 12) continue block11;
                            if (cb[nChar] == '<' && cb[nChar + 1] == 's' && cb[nChar + 2] == 'h' && cb[nChar + 3] == 'e' && cb[nChar + 4] == 'e' && cb[nChar + 5] == 't' && cb[nChar + 6] == 'D' && cb[nChar + 7] == 'a' && cb[nChar + 8] == 't' && cb[nChar + 9] == 'a' && (cb[nChar + 10] == '>' || cb[nChar + 10] == '/' && cb[nChar + 11] == '>')) {
                                break block23;
                            }
                            ++nChar;
                        }
                        break;
                    }
                }
                catch (Throwable var6_10) {
                    var5_6 = var6_10;
                    throw var6_10;
                }
                finally {
                    if (reader != null) {
                        if (var5_6 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable var6_9) {
                                var5_6.addSuppressed(var6_9);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Read header row error.");
                return null;
            }
        }
        v0 = eof = cb[nChar += 11] == '>';
        if (eof) {
            this.heof = true;
            return null;
        }
        block13: while (true) {
            start = nChar;
            while (cb[++nChar] != '>' && nChar < length) {
            }
            if (cb[nChar++ - 1] == '/') continue;
            while (true) {
                if (nChar >= length - 6) ** break;
                if (cb[nChar] == '<' && cb[nChar + 1] == '/' && cb[nChar + 2] == 'r' && cb[nChar + 3] == 'o' && cb[nChar + 4] == 'w' && cb[nChar + 5] == '>') {
                    nChar += 6;
                    break block13;
                }
                ++nChar;
            }
            break;
        }
        endTag = true;
        if (!endTag) {
            return null;
        }
        return new XMLRow(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1).with(cb, start, nChar - start);
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowSetIterator(this::nextRow, false);
    }

    @Override
    public Iterator<Row> dataIterator() {
        RowSetIterator nIter = new RowSetIterator(this::nextRow, true);
        if (nIter.hasNext()) {
            Row row = (Row)nIter.next();
            if (this.header == null) {
                this.header = row.asHeader();
            }
        }
        return nIter;
    }

    @Override
    public void close() throws IOException {
        this.cb = null;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public XMLSheet reset() throws IOException {
        this.close();
        return this.load();
    }
}

