/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.util.CSVUtil;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

public interface Sheet
extends AutoCloseable {
    public String getName();

    public int getIndex();

    public int getSize();

    public boolean isHidden();

    default public boolean isShow() {
        return !this.isHidden();
    }

    public Row getHeader();

    public Sheet bind(Class<?> var1);

    public Sheet load() throws IOException;

    public Iterator<Row> iterator();

    public Iterator<Row> dataIterator();

    default public Sheet reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Stream<Row> rows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 272), false);
    }

    default public Stream<Row> dataRows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.dataIterator(), 272), false);
    }

    default public int col2Int(String col) {
        if (StringUtil.isEmpty(col)) {
            return 1;
        }
        char[] values = col.toCharArray();
        int n = 0;
        for (char value : values) {
            if (value < 'A' || value > 'Z') {
                throw new ExcelReadException("Column mark out of range: " + col);
            }
            n = n * 26 + value - 65 + 1;
        }
        return n;
    }

    @Override
    public void close() throws IOException;

    default public void saveAsCSV(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve(this.getName() + ".csv");
        }
        this.saveAsCSV(Files.newOutputStream(path, new OpenOption[0]));
    }

    default public void saveAsCSV(OutputStream os) throws IOException {
        try (CSVUtil.Writer writer = CSVUtil.newWriter(os);){
            Iterator<Row> iter = this.iterator();
            while (iter.hasNext()) {
                Row row = iter.next();
                if (row.isEmpty()) continue;
                block19: for (int i = row.fc; i < row.lc; ++i) {
                    Cell c = row.cells[i];
                    switch (c.t) {
                        case 's': {
                            if (c.sv == null) {
                                c.setSv(row.sst.get(c.nv));
                            }
                            writer.write(c.sv);
                            continue block19;
                        }
                        case 'r': {
                            writer.write(c.sv);
                            continue block19;
                        }
                        case 'b': {
                            writer.write(c.bv);
                            continue block19;
                        }
                        case 'f': {
                            writer.write("<function>");
                            continue block19;
                        }
                        case 'n': {
                            if (!row.styles.fastTestDateFmt(c.s)) {
                                writer.write(c.nv);
                                continue block19;
                            }
                            writer.write(DateUtil.toLocalDate(c.nv).toString());
                            continue block19;
                        }
                        case 'l': {
                            writer.write(c.lv);
                            continue block19;
                        }
                        case 'd': {
                            if (!row.styles.fastTestDateFmt(c.s)) {
                                writer.write(c.dv);
                                continue block19;
                            }
                            writer.write(DateUtil.toTimestamp(c.dv).toString());
                            continue block19;
                        }
                        default: {
                            writer.writeEmpty();
                        }
                    }
                }
                writer.newLine();
            }
        }
    }
}

