/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.SharedStrings;

class XMLRow
extends Row {
    private int startRow;
    private StringBuilder buf;
    private char[] cb;
    private int from;
    private int to;
    private int cursor;

    @Override
    public int getRowNumber() {
        if (this.index == -1) {
            this.searchRowNumber();
        }
        return this.index - 1;
    }

    private XMLRow() {
    }

    XMLRow(SharedStrings sst, Styles styles, int startRow) {
        this.sst = sst;
        this.styles = styles;
        this.startRow = startRow;
        this.buf = new StringBuilder();
    }

    XMLRow with(char[] cb, int from, int size) {
        this.cb = cb;
        this.from = from;
        this.to = from + size;
        this.cursor = from;
        this.lc = -1;
        this.index = -1;
        this.parseCells();
        return this;
    }

    XMLRow empty(char[] cb, int from, int size) {
        this.cb = cb;
        this.from = from;
        this.to = from + size;
        this.cursor = from;
        this.index = -1;
        this.lc = -1;
        this.fc = -1;
        return this;
    }

    private int searchRowNumber() {
        int _f;
        for (_f = this.from + 4; this.cb[_f] != '>' && _f < this.to; ++_f) {
            if (this.cb[_f] != ' ' || this.cb[_f + 1] != 'r' || this.cb[_f + 2] != '=') continue;
            int a = _f += 4;
            while (this.cb[_f] != '\"' && _f < this.to) {
                ++_f;
            }
            if (_f <= a) break;
            this.index = SharedStrings.toInt(this.cb, a, _f);
            break;
        }
        return _f;
    }

    private int searchSpan() {
        int len;
        int i = this.from;
        while (this.cb[i] != '>') {
            if (this.cb[i] == ' ' && this.cb[i + 1] == 's' && this.cb[i + 2] == 'p' && this.cb[i + 3] == 'a' && this.cb[i + 4] == 'n' && this.cb[i + 5] == 's' && this.cb[i + 6] == '=') {
                int j = i += 8;
                while (this.cb[i] != '\"' && this.cb[i] != '>') {
                    ++i;
                }
                int b = i - 1;
                while (this.cb[b] != ':') {
                    --b;
                }
                if (++b < i) {
                    this.lc = SharedStrings.toInt(this.cb, b, i);
                }
                if (j < --b) {
                    this.fc = SharedStrings.toInt(this.cb, j, b);
                }
            }
            ++i;
        }
        if (this.fc <= 0) {
            this.fc = this.startRow;
        }
        --this.fc;
        if (this.cells == null || this.lc > this.cells.length) {
            this.cells = new Cell[this.lc > 0 ? this.lc : 100];
        }
        int n = len = this.lc > 0 ? this.lc : this.cells.length;
        for (int n2 = 0; n2 < len; ++n2) {
            if (this.cells[n2] != null) {
                this.cells[n2].clear();
                continue;
            }
            this.cells[n2] = new Cell();
        }
        return i;
    }

    private void parseCells() {
        int index = 0;
        this.cursor = this.searchSpan();
        while (this.cb[this.cursor++] != '>') {
        }
        boolean bl = this.unknownLength = this.lc < 0;
        if (this.unknownLength) {
            while (this.nextCell() != null) {
                ++index;
            }
        } else {
            while (index < this.lc && this.nextCell() != null) {
            }
        }
    }

    protected Cell nextCell() {
        int a;
        int e;
        while (this.cursor < this.to && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != 'c' || this.cb[this.cursor + 2] != ' ')) {
            ++this.cursor;
        }
        if (this.cursor >= this.to) {
            return null;
        }
        this.cursor += 2;
        for (e = this.cursor; e < this.to && (this.cb[e] != '<' || this.cb[e + 1] != 'c' || this.cb[e + 2] != ' '); ++e) {
        }
        Cell cell = null;
        int t = 110;
        short s = 0;
        while (this.cb[this.cursor] != '>') {
            if (this.cb[this.cursor] == ' ' && this.cb[this.cursor + 1] == 'r' && this.cb[this.cursor + 2] == '=') {
                int n;
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                if (this.unknownLength) {
                    this.lc = this.toCellIndex(a, this.cursor);
                    n = this.lc - 1;
                } else {
                    n = this.toCellIndex(a, this.cursor) - 1;
                }
                cell = this.cells[n];
            }
            if (this.cb[this.cursor] == ' ' && this.cb[this.cursor + 1] == 't' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                int n = this.cursor - a;
                if (n == 1) {
                    t = this.cb[a];
                } else if (n == 3 && this.cb[a] == 's' && this.cb[a + 1] == 't' && this.cb[a + 2] == 'r') {
                    t = 102;
                } else if (n == 9 && this.cb[a] == 'i' && this.cb[a + 1] == 'n' && this.cb[a + 2] == 'l' && this.cb[a + 6] == 'S' && this.cb[a + 8] == 'r') {
                    t = 114;
                }
            }
            if (this.cb[this.cursor] == ' ' && this.cb[this.cursor + 1] == 's' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                s = (short)(SharedStrings.toInt(this.cb, a, this.cursor) & 0xFFFF);
            }
            ++this.cursor;
        }
        if (cell == null) {
            return null;
        }
        cell.s = s;
        switch (t) {
            case 114: {
                a = this.getT(e);
                if (a == this.cursor) {
                    cell.setT('k');
                    break;
                }
                cell.setSv(SharedStrings.unescape(this.buf, this.cb, a, this.cursor));
                break;
            }
            case 115: {
                a = this.getV(e);
                cell.setNv(SharedStrings.toInt(this.cb, a, this.cursor));
                cell.setT('s');
                break;
            }
            case 98: {
                a = this.getV(e);
                if (this.cursor - a != 1) break;
                cell.setBv(SharedStrings.toInt(this.cb, a, this.cursor) == 1);
                break;
            }
            case 102: {
                break;
            }
            default: {
                a = this.getV(e);
                if (a >= this.cursor) break;
                if (this.isNumber(a, this.cursor)) {
                    long l = this.toLong(a, this.cursor);
                    if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                        cell.setNv((int)l);
                        break;
                    }
                    cell.setLv(l);
                    break;
                }
                if (this.isDouble(a, this.cursor)) {
                    cell.setDv(this.toDouble(a, this.cursor));
                    break;
                }
                cell.setSv(this.toString(a, this.cursor));
            }
        }
        this.cursor = e;
        return cell;
    }

    private long toLong(int a, int b) {
        boolean _n = this.cb[a] == '-';
        if (_n) {
            // empty if block
        }
        int n = ++a;
        ++a;
        long n2 = this.cb[n] - 48;
        while (b > a) {
            n2 = n2 * 10L + (long)this.cb[a++] - 48L;
        }
        return _n ? -n2 : n2;
    }

    private String toString(int a, int b) {
        return new String(this.cb, a, b - a);
    }

    private double toDouble(int a, int b) {
        return Double.valueOf(this.toString(a, b));
    }

    private boolean isNumber(int a, int b) {
        char c;
        if (a == b) {
            return false;
        }
        if (this.cb[a] == '-') {
            ++a;
        }
        while (a < b && (c = this.cb[a++]) >= '0' && c <= '9') {
        }
        return a == b;
    }

    private boolean isDouble(int a, int b) {
        if (a == b) {
            return false;
        }
        if (this.cb[a] == '-') {
            ++a;
        }
        int i = 0;
        while (a < b) {
            char c = this.cb[a++];
            if (i > 1) {
                return false;
            }
            if (c >= '0' && c <= '9' || c != '.') continue;
            i = (char)(i + 1);
        }
        return true;
    }

    private int getT(int e) {
        while (this.cursor < e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != 't' || this.cb[this.cursor + 2] != '>')) {
            ++this.cursor;
        }
        if (this.cursor == e) {
            return this.cursor;
        }
        int a = this.cursor += 3;
        while (this.cursor < e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != '/' || this.cb[this.cursor + 2] != 't' || this.cb[this.cursor + 3] != '>')) {
            ++this.cursor;
        }
        return a;
    }

    private int getV(int e) {
        while (this.cursor < e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != 'v' || this.cb[this.cursor + 2] != '>')) {
            ++this.cursor;
        }
        if (this.cursor == e) {
            return this.cursor;
        }
        int a = this.cursor += 3;
        while (this.cursor < e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != '/' || this.cb[this.cursor + 2] != 'v' || this.cb[this.cursor + 3] != '>')) {
            ++this.cursor;
        }
        return a;
    }

    private int getF(int e) {
        return e;
    }

    private int toCellIndex(int a, int b) {
        int n = 0;
        while (a <= b) {
            if (this.cb[a] <= 'Z' && this.cb[a] >= 'A') {
                n = n * 26 + this.cb[a] - 64;
            } else {
                if (this.cb[a] > 'z' || this.cb[a] < 'a') break;
                n = n * 26 + this.cb[a] - 12289;
            }
            ++a;
        }
        return n;
    }
}

