/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.RowSetProcessor;

class RowSetIterator
implements Iterator<Row> {
    private boolean onlyDataRow;
    private RowSetProcessor processor;
    private Row nextRow = null;

    public RowSetIterator(RowSetProcessor processor, boolean onlyDataRow) {
        this.processor = processor;
        this.onlyDataRow = onlyDataRow;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        try {
            if (this.onlyDataRow) {
                while ((this.nextRow = this.processor.next()) != null && this.nextRow.isEmpty()) {
                }
            } else {
                this.nextRow = this.processor.next();
            }
            return this.nextRow != null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Row next() {
        if (this.nextRow != null || this.hasNext()) {
            Row next = this.nextRow;
            this.nextRow = null;
            return next;
        }
        throw new NoSuchElementException();
    }
}

