/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.reader.Cache;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.FixSizeLRUCache;
import org.ttzero.excel.reader.IndexSharedStringTable;

public class SharedStrings
implements AutoCloseable {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Path sstPath;
    private String[] forward;
    private String[] backward;
    private int page = 512;
    private int max = -1;
    private int vt = 0;
    private int offsetM = 0;
    private int offset_forward = -1;
    private int offset_backward = -1;
    private int limit_forward;
    private int limit_backward;
    private Map<Integer, Integer> count_area = null;
    private Cache<Integer, String> hot;
    private int hotSize;
    private BufferedReader reader;
    private char[] cb;
    private int offset;
    private StringBuilder escapeBuf;
    private IndexSharedStringTable sst;
    private int total;
    private int total_forward;
    private int total_backward;
    private int total_hot;

    SharedStrings(String[] data) {
        this.max = data.length;
        this.offset_forward = 0;
        if (this.max <= this.page) {
            this.forward = new String[this.max];
            System.arraycopy(data, this.offset_forward, this.forward, 0, this.max);
            this.limit_forward = this.max;
        } else {
            if (this.max > this.page << 1) {
                this.page = this.max >> 1;
            }
            this.forward = new String[this.page];
            this.limit_forward = this.page;
            System.arraycopy(data, this.offset_forward, this.forward, 0, this.limit_forward);
            this.offset_backward = this.page;
            this.limit_backward = this.max - this.page;
            this.backward = new String[this.limit_backward];
            System.arraycopy(data, this.offset_backward, this.backward, 0, this.limit_backward);
        }
    }

    SharedStrings(Path sstPath, int cacheSize, int hotSize) {
        this.sstPath = sstPath;
        if (cacheSize > 0) {
            this.page = cacheSize;
        }
        this.hotSize = hotSize;
    }

    public int size() {
        return this.max;
    }

    SharedStrings load() throws IOException {
        if (Files.exists(this.sstPath, new LinkOption[0])) {
            this.max = this.uniqueCount();
            this.logger.debug("Size of SharedString: {}", (Object)this.max);
            int default_cap = 10;
            if (this.max < 0 || this.max > this.page) {
                this.forward = new String[this.page];
                this.backward = new String[this.page];
                if (this.max > 0 && this.max / this.page + 1 > default_cap) {
                    default_cap = this.max / this.page + 1;
                }
                this.count_area = new HashMap<Integer, Integer>(default_cap);
                this.hot = this.hotSize > 0 ? FixSizeLRUCache.create(this.hotSize) : FixSizeLRUCache.create();
                this.sst = new IndexSharedStringTable();
                this.sst.setShortSectorSize(9);
            } else {
                this.forward = new String[this.max];
            }
        } else {
            this.max = 0;
        }
        this.escapeBuf = new StringBuilder();
        return this;
    }

    private int uniqueCount() throws IOException {
        int end;
        int i;
        int off = -1;
        this.reader = Files.newBufferedReader(this.sstPath);
        this.cb = new char[4096];
        this.offset = 0;
        this.offset = this.reader.read(this.cb);
        int len = this.offset - 4;
        for (i = 0; i < len && (this.cb[i] != '<' || this.cb[i + 1] != 's' || this.cb[i + 2] != 'i' || this.cb[i + 3] != '>'); ++i) {
        }
        if (i == len) {
            return 0;
        }
        String line = new String(this.cb, 0, i);
        String uniqueCount = " uniqueCount=";
        int index = line.indexOf(uniqueCount);
        int n = end = index > 0 ? line.indexOf(34, index += uniqueCount.length() + 1) : -1;
        if (end > 0) {
            off = Integer.parseInt(line.substring(index, end));
        } else {
            String count = " count=";
            index = line.indexOf(count);
            int n2 = end = index > 0 ? line.indexOf(34, index += count.length() + 1) : -1;
            if (end > 0) {
                off = Integer.parseInt(line.substring(index, end));
            }
        }
        this.vt = i + 4;
        System.arraycopy(this.cb, this.vt, this.cb, 0, this.offset -= this.vt);
        return off;
    }

    public String get(int index) {
        this.checkBound(index);
        ++this.total;
        if (this.offset_forward == -1) {
            this.offset_forward = index / this.page * this.page;
            if (this.vt < 0) {
                this.vt = 0;
            }
            this.loadXml();
            this.test(index);
        }
        if (this.forwardRange(index)) {
            String value = this.forward[index - this.offset_forward];
            ++this.total_forward;
            return value;
        }
        if (this.backwardRange(index)) {
            String value = this.backward[index - this.offset_backward];
            ++this.total_backward;
            return value;
        }
        String value = this.hot.get(index);
        if (value == null) {
            System.arraycopy(this.forward, 0, this.backward, 0, this.limit_forward);
            this.offset_backward = this.offset_forward;
            this.limit_backward = this.limit_forward;
            this.offset_forward = index / this.page * this.page;
            this.forward[0] = null;
            if (index < this.sst.size()) {
                try {
                    this.limit_forward = this.sst.get(this.offset_forward, this.forward);
                }
                catch (IOException e) {
                    throw new ExcelWriteException(e);
                }
            } else {
                this.loadXml();
            }
            if (this.forward[0] == null) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
            }
            value = this.forward[index - this.offset_forward];
            if (this.test(index)) {
                this.logger.debug("put hot {}", (Object)index);
                this.hot.put(index, value);
            }
            ++this.total_forward;
        } else {
            ++this.total_hot;
        }
        return value;
    }

    private boolean forwardRange(int index) {
        return this.offset_forward >= 0 && this.offset_forward <= index && this.offset_forward + this.limit_forward > index;
    }

    private boolean backwardRange(int index) {
        return this.offset_backward >= 0 && this.offset_backward <= index && this.offset_backward + this.limit_backward > index;
    }

    private void checkBound(int index) {
        if (index < 0 || this.max > -1 && this.max <= index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
        }
    }

    private boolean test(int index) {
        if (this.max < this.page) {
            return false;
        }
        int idx = index / this.page;
        int n = this.count_area.getOrDefault(idx, 0) + 1;
        this.count_area.put(idx, n);
        return n > 1;
    }

    private void loadXml() {
        int index = this.offset_forward / this.page;
        try {
            int n = index - this.offsetM;
            while (n-- >= 0) {
                this.readData();
            }
        }
        catch (IOException e) {
            throw new ExcelReadException(e);
        }
    }

    private int readData() throws IOException {
        int length;
        int n = 0;
        while ((length = this.reader.read(this.cb, this.offset, this.cb.length - this.offset)) > 0 || this.offset > 0) {
            int nChar = this.offset &= 0;
            int len0 = (length += this.offset) - 3;
            int len1 = len0 - 1;
            int[] t = this.findT(this.cb, nChar, length, len0, len1, n);
            nChar = t[0];
            this.limit_forward = n = t[1];
            if (nChar < length) {
                this.offset = length - nChar;
                System.arraycopy(this.cb, nChar, this.cb, 0, this.offset);
            }
            if (n == this.page) {
                ++this.offsetM;
                break;
            }
            if (length >= this.cb.length || nChar != length - 6) continue;
            if (this.max == -1) {
                this.max = this.offsetM * this.page + n;
            }
            ++this.offsetM;
            break;
        }
        return n;
    }

    private int[] findT(char[] cb, int nChar, int length, int len0, int len1, int n) throws IOException {
        while (nChar < length && n < this.page) {
            int cursor = nChar;
            int[] subT = this.subT(cb, nChar, len0, len1);
            int a = subT[0];
            if (a == -1) break;
            nChar = subT[1];
            String tmp = SharedStrings.unescape(this.escapeBuf, cb, a, nChar);
            nChar += 4;
            while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/')) {
                ++nChar;
            }
            if (nChar < len1 && cb[nChar + 2] == 's' && cb[nChar + 3] == 'i' && cb[nChar + 4] == '>') {
                this.forward[n++] = tmp;
                if (this.sst != null) {
                    this.sst.push(this.forward[n - 1]);
                }
                nChar += 5;
            } else {
                StringBuilder buf = new StringBuilder(tmp);
                int t = nChar;
                while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/' || cb[nChar + 2] != 's' || cb[nChar + 3] != 'i' || cb[nChar + 4] != '>')) {
                    ++nChar;
                }
                if (nChar >= len1) {
                    nChar = cursor;
                    break;
                }
                int end = nChar;
                nChar = t;
                while ((a = (subT = this.subT(cb, nChar, end, end))[0]) != -1) {
                    nChar = subT[1];
                    buf.append(SharedStrings.unescape(this.escapeBuf, cb, a, nChar));
                    nChar += 4;
                }
                this.forward[n++] = buf.toString();
                if (this.sst != null) {
                    this.sst.push(this.forward[n - 1]);
                }
            }
            if (n != this.page) continue;
            break;
        }
        return new int[]{nChar, n};
    }

    private int[] subT(char[] cb, int nChar, int len0, int len1) {
        while (nChar < len0 && (cb[nChar] != '<' || cb[nChar + 1] != 't' || cb[nChar + 2] != '>' && cb[nChar + 2] != ' ')) {
            ++nChar;
        }
        if (nChar >= len0) {
            return new int[]{-1};
        }
        int a = nChar += 3;
        if (cb[nChar - 1] == ' ') {
            while (nChar < len0 && cb[nChar++] != '>') {
            }
            if (nChar >= len0) {
                return new int[]{-1};
            }
            a = nChar;
        }
        while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/' || cb[nChar + 2] != 't' || cb[nChar + 3] != '>')) {
            ++nChar;
        }
        if (nChar >= len1) {
            return new int[]{-1};
        }
        return new int[]{a, nChar};
    }

    static String unescape(StringBuilder escapeBuf, char[] cb, int from, int to) {
        int idx_59;
        int idx_38 = SharedStrings.indexOf(cb, '&', from);
        int n = idx_59 = idx_38 > -1 && idx_38 < to ? SharedStrings.indexOf(cb, ';', idx_38 + 1) : -1;
        if (idx_38 <= 0 || idx_38 >= idx_59 || idx_59 > to) {
            return new String(cb, from, to - from);
        }
        escapeBuf.delete(0, escapeBuf.length());
        do {
            escapeBuf.append(cb, from, idx_38 - from);
            if (cb[idx_38 + 1] == '#') {
                int n2 = SharedStrings.toInt(cb, idx_38 + 2, idx_59);
                escapeBuf.append((char)n2);
            } else {
                String name;
                switch (name = new String(cb, idx_38 + 1, idx_59 - idx_38 - 1)) {
                    case "lt": {
                        escapeBuf.append('<');
                        break;
                    }
                    case "gt": {
                        escapeBuf.append('>');
                        break;
                    }
                    case "amp": {
                        escapeBuf.append('&');
                        break;
                    }
                    case "quot": {
                        escapeBuf.append('\"');
                        break;
                    }
                    case "nbsp": {
                        escapeBuf.append(' ');
                        break;
                    }
                    default: {
                        escapeBuf.append(cb, idx_38, idx_59 - idx_38 + 1);
                    }
                }
            }
            from = ++idx_59;
            idx_38 = SharedStrings.indexOf(cb, '&', idx_59);
            int n3 = idx_59 = idx_38 > -1 && idx_38 < to ? SharedStrings.indexOf(cb, ';', idx_38 + 1) : -1;
        } while (idx_38 > -1 && idx_59 > idx_38 && idx_59 <= to);
        if (from < to) {
            escapeBuf.append(cb, from, to - from);
        }
        return escapeBuf.toString();
    }

    private static int indexOf(char[] cb, char c, int from) {
        while (from < cb.length) {
            if (cb[from] == c) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    static int toInt(char[] cb, int a, int b) {
        boolean _n = cb[a] == '-';
        if (_n) {
            // empty if block
        }
        int n = ++a;
        ++a;
        int n2 = cb[n] - 48;
        while (b > a) {
            n2 = n2 * 10 + cb[a++] - 48;
        }
        return _n ? -n2 : n2;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.logger.debug("total: {}, forward: {}, backward: {}, hot: {}", (Object)this.total, (Object)this.total_forward, (Object)this.total_backward, (Object)this.total_hot);
            this.reader.close();
        }
        this.cb = null;
        this.forward = null;
        this.backward = null;
        if (this.count_area != null) {
            this.count_area.clear();
            this.count_area = null;
        }
        this.escapeBuf = null;
        if (this.sst != null) {
            this.sst.close();
        }
    }
}

