/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnels;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.SharedStringTable;
import org.ttzero.excel.entity.Storageable;
import org.ttzero.excel.manager.Const;
import org.ttzero.excel.reader.Cache;
import org.ttzero.excel.reader.FixSizeLRUCache;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, value="sst", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main"})
public class SharedStrings
implements Storageable,
AutoCloseable {
    private int count;
    private BloomFilter<String> filter;
    private int[] ascii;
    private Path temp;
    private ExtBufferedWriter writer;
    private Cache<String, Integer> hot;
    private SharedStringTable sst;
    private int expectedInsertions = 0x100000;
    private ThreadLocal<char[]> charCache = ThreadLocal.withInitial(() -> new char[1]);

    SharedStrings() {
        this.hot = FixSizeLRUCache.create();
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        this.filter = BloomFilter.create(Funnels.stringFunnel(StandardCharsets.UTF_8), this.expectedInsertions, 3.0E-4);
        this.init();
    }

    private void init() {
        try {
            this.temp = Files.createTempFile("~", "sst", new FileAttribute[0]);
            this.writer = new ExtBufferedWriter(Files.newBufferedWriter(this.temp, StandardCharsets.UTF_8, new OpenOption[0]));
            this.sst = new SharedStringTable();
        }
        catch (IOException e) {
            throw new ExcelWriteException(e);
        }
    }

    public int get(char c) throws IOException {
        if (c < '\u0080') {
            int n = this.ascii[c];
            if (n == -1) {
                this.ascii[c] = n = this.add(c);
            }
            ++this.count;
            return n;
        }
        char[] cs = this.charCache.get();
        cs[0] = c;
        return this.get(new String(cs));
    }

    public int get(String key) throws IOException {
        ++this.count;
        if (!this.filter.mightContain(key)) {
            if (this.sst.size() >= this.expectedInsertions) {
                this.resetBloomFilter();
            }
            this.filter.put(key);
            return this.add(key);
        }
        Integer n = this.hot.get(key);
        if (n == null) {
            n = this.sst.find(key);
            if (n < 0) {
                n = this.add(key);
            }
            this.hot.put(key, n);
        }
        return n;
    }

    private int add(String key) throws IOException {
        this.writer.write("<si><t>");
        this.writer.escapeWrite(key);
        this.writer.write("</t></si>");
        return this.sst.push(key);
    }

    private int add(char c) throws IOException {
        this.writer.write("<si><t>");
        this.writer.escapeWrite(c);
        this.writer.write("</t></si>");
        return this.sst.push(c);
    }

    @Override
    public void writeTo(Path root) throws IOException {
        FileUtil.close(this.writer);
        if (!Files.exists(root, new LinkOption[0])) {
            FileUtil.mkdir(root);
        }
        StringBuilder buf = new StringBuilder();
        TopNS topNS = this.getClass().getAnnotation(TopNS.class);
        if (topNS != null) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            buf.append(Const.lineSeparator);
            buf.append("<").append(topNS.value()).append(" xmlns=\"").append(topNS.uri()[0]).append("\"").append(" count=\"").append(this.count).append("\"").append(" uniqueCount=\"").append(this.sst.size()).append("\">").append(Const.lineSeparator);
        } else {
            buf.append("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"").append(this.count).append("\" uniqueCount=\"").append(this.sst.size()).append("\">").append(Const.lineSeparator);
        }
        Path dist = root.resolve(StringUtil.lowFirstKey(this.getClass().getSimpleName() + ".xml"));
        try (FileOutputStream fos = new FileOutputStream(dist.toFile());
             FileChannel channel = fos.getChannel();){
            ByteBuffer buffer = ByteBuffer.allocate(512);
            buffer.put(buf.toString().getBytes(StandardCharsets.UTF_8));
            buffer.flip();
            channel.write(buffer);
            if (this.sst.size() > 0) {
                this.transfer(channel);
            }
            buffer.clear();
            buf.delete(0, buf.length());
            if (topNS != null) {
                buf.append("</").append(topNS.value()).append(">");
            } else {
                buf.append("</sst>");
            }
            buffer.put(buf.toString().getBytes(StandardCharsets.UTF_8));
            buffer.flip();
            channel.write(buffer);
        }
    }

    private void transfer(FileChannel channel) throws IOException {
        try (FileChannel tempChannel = FileChannel.open(this.temp, StandardOpenOption.READ);){
            tempChannel.transferTo(0L, tempChannel.size(), channel);
        }
    }

    private void resetBloomFilter() {
        this.filter = BloomFilter.create(Funnels.stringFunnel(StandardCharsets.UTF_8), this.expectedInsertions, 3.0E-4);
        for (Cache.Entry entry : this.hot) {
            this.filter.put((String)entry.getKey());
        }
    }

    @Override
    public void close() throws IOException {
        this.filter = null;
        this.hot.clear();
        this.hot = null;
        this.sst.close();
        FileUtil.rm(this.temp);
    }
}

