/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.e7.ContentType;
import org.ttzero.excel.entity.e7.EmbedTemplate;
import org.ttzero.excel.entity.e7.XMLCellValueAndStyle;
import org.ttzero.excel.entity.e7.XMLWorksheetWriter;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.PatternType;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.docProps.App;
import org.ttzero.excel.manager.docProps.Core;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.util.ZipUtil;

@TopNS(prefix={"", "r"}, value="workbook", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main", "http://schemas.openxmlformats.org/officeDocument/2006/relationships"})
public class XMLWorkbookWriter
implements IWorkbookWriter {
    private Workbook workbook;
    private RelManager relManager;

    public XMLWorkbookWriter() {
        this.relManager = new RelManager();
    }

    public XMLWorkbookWriter(Workbook workbook) {
        this.workbook = workbook;
        this.relManager = new RelManager();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public RelManager getRelManager() {
        return this.relManager;
    }

    @Override
    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public String getSuffix() {
        return ".xlsx";
    }

    @Override
    public void writeTo(Path path) throws IOException {
        Path zip = this.workbook.getTemplate() == null ? this.createTemp() : this.template();
        this.reMarkPath(zip, path);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        Path zip = this.workbook.getTemplate() == null ? this.createTemp() : this.template();
        Files.copy(zip, os);
    }

    @Override
    public void writeTo(File file) throws IOException {
        Path zip = this.workbook.getTemplate() == null ? this.createTemp() : this.template();
        FileUtil.cp(zip, file);
    }

    private void addRel(Relationship rel) {
        this.relManager.add(rel);
    }

    private void writeXML(Path root) throws IOException {
        int i;
        ContentType contentType = new ContentType();
        contentType.add(new ContentType.Default("application/vnd.openxmlformats-package.relationships+xml", "rels"));
        contentType.add(new ContentType.Default("application/xml", "xml"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "/xl/sharedStrings.xml"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "/xl/workbook.xml"));
        contentType.addRel(new Relationship("xl/workbook.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"));
        this.writeApp(root, contentType);
        this.writeCore(root, contentType);
        Path themeP = root.resolve("theme");
        if (!Files.exists(themeP, new LinkOption[0])) {
            Files.createDirectory(themeP, new FileAttribute[0]);
        }
        try {
            InputStream theme = this.getClass().getClassLoader().getResourceAsStream("template/theme1.xml");
            if (theme != null) {
                Files.copy(theme, themeP.resolve("theme1.xml"), new CopyOption[0]);
            }
        }
        catch (IOException theme) {
            // empty catch block
        }
        this.addRel(new Relationship("theme/theme1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.theme+xml", "/xl/theme/theme1.xml"));
        this.addRel(new Relationship("styles.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "/xl/styles.xml"));
        this.addRel(new Relationship("sharedStrings.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings"));
        WaterMark waterMark = this.workbook.getWaterMark();
        if (waterMark != null) {
            contentType.add(new ContentType.Default(waterMark.getContentType(), waterMark.getSuffix().substring(1)));
        }
        int size = this.workbook.getSize();
        for (i = 0; i < size; ++i) {
            WaterMark wm = this.workbook.getSheetAt(i).getWaterMark();
            if (wm == null) continue;
            contentType.add(new ContentType.Default(wm.getContentType(), wm.getSuffix().substring(1)));
        }
        for (i = 0; i < size; ++i) {
            contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "/xl/worksheets/sheet" + this.workbook.getSheetAt(i).getId() + ".xml"));
        }
        contentType.writeTo(root.getParent());
        TopNS topNS = this.getClass().getAnnotation(TopNS.class);
        String name = topNS != null ? topNS.value() : "workbook";
        this.relManager.write(root, name + ".xml");
        this.writeSelf(root);
        this.workbook.getStyles().writeTo(root.resolve("styles.xml"));
        try (SharedStrings sst = this.workbook.getSst();){
            sst.writeTo(root);
        }
    }

    private void writeApp(Path root, ContentType contentType) throws IOException {
        App app = new App();
        if (StringUtil.isNotEmpty(this.workbook.getCompany())) {
            app.setCompany(this.workbook.getCompany());
        }
        try {
            URL url;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.ttzero/eec/pom.properties");
            Properties pom = new Properties();
            if (is == null && (url = this.getClass().getClassLoader().getResource(".")) != null) {
                Path targetPath = (FileUtil.isWindows() ? Paths.get(url.getFile().substring(1), new String[0]) : Paths.get(url.getFile(), new String[0])).getParent();
                Path pomPath = targetPath.resolve("maven-archiver/pom.properties");
                if (Files.exists(pomPath, new LinkOption[0])) {
                    is = Files.newInputStream(pomPath, new OpenOption[0]);
                } else {
                    pomPath = targetPath.getParent().resolve("pom.xml");
                    SAXReader reader = new SAXReader();
                    try {
                        Document document = reader.read(Files.newInputStream(pomPath, new OpenOption[0]));
                        Element pomRoot = document.getRootElement();
                        String application = pomRoot.elementText("groupId") + "." + pomRoot.elementText("artifactId");
                        app.setApplication(application);
                        String appVersion = pomRoot.elementText("version");
                        app.setAppVersion(appVersion);
                    }
                    catch (IOException | DocumentException throwable) {
                        // empty catch block
                    }
                }
            }
            if (is != null) {
                pom.load(is);
                app.setApplication(pom.getProperty("groupId") + '.' + pom.getProperty("artifactId"));
                app.setAppVersion(pom.getProperty("version"));
            }
        }
        catch (IOException is) {
            // empty catch block
        }
        if (StringUtil.isEmpty(app.getAppVersion())) {
            app.setApplication("org.ttzero.eec");
            app.setAppVersion("1.0.0");
        }
        int size = this.workbook.getSize();
        ArrayList<String> titleParts = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            titleParts.add(sheet.getName());
            this.addRel(new Relationship("worksheets/sheet" + sheet.getId() + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet"));
        }
        app.setTitlePards(titleParts);
        try {
            app.writeTo(root.getParent() + "/docProps/app.xml");
            contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.extended-properties+xml", "/docProps/app.xml"));
            contentType.addRel(new Relationship("docProps/app.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties"));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExcelWriteException(e);
        }
    }

    private void writeCore(Path root, ContentType contentType) throws IOException {
        Core core = new Core();
        core.setCreated(new Date());
        if (this.workbook.getCreator() != null) {
            core.setCreator(this.workbook.getCreator());
        } else {
            core.setCreator(System.getProperty("user.name"));
        }
        core.setTitle(this.workbook.getName());
        core.setModified(new Date());
        try {
            core.writeTo(root.getParent() + "/docProps/core.xml");
            contentType.add(new ContentType.Override("application/vnd.openxmlformats-package.core-properties+xml", "/docProps/core.xml"));
            contentType.addRel(new Relationship("docProps/core.xml", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties"));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExcelWriteException(e);
        }
    }

    private void madeMark(Path parent) throws IOException {
        Relationship supRel = null;
        int n = 1;
        WaterMark waterMark = this.workbook.getWaterMark();
        if (waterMark != null) {
            Path media = parent.resolve("media");
            if (!Files.exists(media, new LinkOption[0])) {
                Files.createDirectory(media, new FileAttribute[0]);
            }
            Path image = media.resolve("image" + n++ + waterMark.getSuffix());
            Files.copy(waterMark.get(), image, new CopyOption[0]);
            supRel = new Relationship("../media/" + image.getFileName(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
        }
        for (int i = 0; i < this.workbook.getSize(); ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            WaterMark wm = sheet.getWaterMark();
            if (wm != null) {
                Path media = parent.resolve("media");
                if (!Files.exists(media, new LinkOption[0])) {
                    Files.createDirectory(media, new FileAttribute[0]);
                }
                Path image = media.resolve("image" + n++ + wm.getSuffix());
                Files.copy(wm.get(), image, new CopyOption[0]);
                sheet.addRel(new Relationship("../media/" + image.getFileName(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image"));
                continue;
            }
            if (waterMark == null) continue;
            sheet.setWaterMark(waterMark);
            sheet.addRel(supRel);
        }
    }

    private void writeSelf(Path root) throws IOException {
        int i;
        DocumentFactory factory = DocumentFactory.getInstance();
        Element rootElement = null;
        String[] prefixs = null;
        String[] uris = null;
        String rootName = null;
        TopNS topNs = this.getClass().getAnnotation(TopNS.class);
        boolean hasTopNs = this.getClass().isAnnotationPresent(TopNS.class);
        if (hasTopNs) {
            prefixs = topNs.prefix();
            uris = topNs.uri();
            rootName = topNs.value();
            for (i = 0; i < prefixs.length; ++i) {
                if (prefixs[i].length() != 0) continue;
                rootElement = factory.createElement(rootName, uris[i]);
                break;
            }
        }
        if (rootElement == null) {
            if (hasTopNs) {
                rootElement = factory.createElement(rootName);
            } else {
                this.workbook.what("9004", "workbook.xml");
                return;
            }
        }
        if (hasTopNs) {
            for (i = 0; i < prefixs.length; ++i) {
                rootElement.add(Namespace.get((String)prefixs[i], (String)uris[i]));
            }
        }
        rootElement.addElement("bookViews").addElement("workbookView").addAttribute("activeTab", "0");
        Element sheetEle = rootElement.addElement("sheets");
        for (int i2 = 0; i2 < this.workbook.getSize(); ++i2) {
            Relationship rs;
            Sheet sheetInfo = this.workbook.getSheetAt(i2);
            Element st = sheetEle.addElement("sheet").addAttribute("sheetId", String.valueOf(i2 + 1)).addAttribute("name", sheetInfo.getName());
            if (sheetInfo.isHidden()) {
                st.addAttribute("state", "hidden");
            }
            if ((rs = this.relManager.getByTarget("worksheets/sheet" + (i2 + 1) + ".xml")) == null) continue;
            st.addAttribute(QName.get((String)"id", (Namespace)Namespace.get((String)"r", (String)uris[StringUtil.indexOf(prefixs, "r")])), rs.getId());
        }
        Document doc = factory.createDocument(rootElement);
        FileUtil.writeToDiskNoFormat(doc, root.resolve(rootName + ".xml"));
    }

    protected Path createTemp() throws IOException, ExcelWriteException {
        Sheet[] sheets = this.workbook.getSheets();
        for (int i = 0; i < sheets.length; ++i) {
            Sheet sheet = sheets[i];
            IWorksheetWriter worksheetWriter = this.getWorksheetWriter(sheet);
            sheet.setSheetWriter(worksheetWriter);
            if (sheet.getAutoSize() == 0) {
                if (this.workbook.isAutoSize()) {
                    sheet.autoSize();
                } else {
                    sheet.fixSize();
                }
            }
            if (sheet.getAutoOdd() == -1) {
                sheet.setAutoOdd(this.workbook.getAutoOdd());
            }
            if (sheet.getAutoOdd() == 0) {
                sheet.setOddFill(this.workbook.getOddFill() == null ? new Fill(PatternType.solid, new Color(226, 237, 218)) : this.workbook.getOddFill());
            }
            sheet.setId(i + 1);
            if (StringUtil.isEmpty(sheet.getName())) {
                sheet.setName("Sheet" + (i + 1));
            }
            sheet.setCellValueAndStyle(new XMLCellValueAndStyle(sheet.getAutoOdd(), sheet.getOddFill()));
        }
        this.workbook.what("0001");
        Path root = null;
        try {
            root = FileUtil.mktmp("eec+");
            this.workbook.what("0002", root.toString());
            Path xl = Files.createDirectory(root.resolve("xl"), new FileAttribute[0]);
            this.madeMark(xl);
            for (int i = 0; i < this.workbook.getSize(); ++i) {
                Sheet e = this.workbook.getSheetAt(i);
                e.writeTo(xl);
                if (e.getWaterMark() != null) {
                    e.getWaterMark().delete();
                }
                e.close();
            }
            this.writeXML(xl);
            if (this.workbook.getWaterMark() != null) {
                this.workbook.getWaterMark().delete();
            }
            this.workbook.what("0003");
            Path zipFile = ZipUtil.zipExcludeRoot(root, root);
            this.workbook.what("0004", zipFile.toString());
            FileUtil.rm_rf(root.toFile(), true);
            this.workbook.what("0005");
            return zipFile;
        }
        catch (IOException | ExcelWriteException e) {
            if (root != null) {
                FileUtil.rm_rf(root);
            }
            this.workbook.getSst().close();
            throw e;
        }
    }

    protected void reMarkPath(Path zip, Path path) throws IOException {
        String name = this.workbook.getName();
        if (StringUtil.isEmpty(name)) {
            name = this.workbook.getI18N().getOrElse("non-name-file", "Non name");
        }
        Path resultPath = this.reMarkPath(zip, path, name);
        this.workbook.what("0006", resultPath.toString());
    }

    @Override
    public Path template() throws IOException {
        this.workbook.what("0007");
        Path temp = FileUtil.mktmp("eec+");
        ZipUtil.unzip(this.workbook.getTemplate(), temp);
        this.workbook.what("0008");
        EmbedTemplate bt = new EmbedTemplate(temp, this.workbook);
        if (bt.check()) {
            bt.bind(this.workbook.getBind());
        }
        this.workbook.what("0003");
        Path zipFile = ZipUtil.zipExcludeRoot(temp, temp);
        this.workbook.what("0004", zipFile.toString());
        FileUtil.rm_rf(temp.toFile(), true);
        this.workbook.what("0005");
        this.workbook.getSst().close();
        return zipFile;
    }

    protected IWorksheetWriter getWorksheetWriter(Sheet sheet) {
        return new XMLWorksheetWriter(sheet);
    }
}

