/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public class XMLWorksheetWriter
implements IWorksheetWriter {
    private Path workSheetPath;
    private ExtBufferedWriter bw;
    private Sheet sheet;
    private Sheet.Column[] columns;
    private SharedStrings sst;

    public XMLWorksheetWriter(Sheet sheet) {
        this.sheet = sheet;
        this.sst = sheet.getSst();
    }

    @Override
    public void writeTo(Path path, Supplier<RowBlock> supplier) throws IOException {
        Path sheetPath = this.initWriter(path);
        RowBlock rowBlock = supplier.get();
        this.writeBefore();
        if (rowBlock != null && rowBlock.hasNext()) {
            if (this.sheet.isAutoSize()) {
                do {
                    this.writeAutoSizeRowBlock(rowBlock);
                } while (!rowBlock.isEof() && (rowBlock = supplier.get()) != null);
            } else {
                do {
                    this.writeRowBlock(rowBlock);
                } while (!rowBlock.isEof() && (rowBlock = supplier.get()) != null);
            }
        }
        int total = rowBlock != null ? rowBlock.getTotal() : 0;
        this.writeAfter(total);
        this.sheet.afterSheetAccess(this.workSheetPath);
        if (this.sheet.isAutoSize()) {
            this.close();
            this.resizeColumnWidth(sheetPath.toFile(), total);
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        Path sheetPath = this.initWriter(path);
        RowBlock rowBlock = this.sheet.nextBlock();
        this.writeBefore();
        if (rowBlock.hasNext()) {
            if (this.sheet.isAutoSize()) {
                while (true) {
                    this.writeAutoSizeRowBlock(rowBlock);
                    if (!rowBlock.isEof()) {
                        rowBlock = this.sheet.nextBlock();
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    this.writeRowBlock(rowBlock);
                    if (rowBlock.isEof()) break;
                    rowBlock = this.sheet.nextBlock();
                }
            }
        }
        this.writeAfter(rowBlock.getTotal());
        this.sheet.afterSheetAccess(this.workSheetPath);
        if (this.sheet.isAutoSize()) {
            this.close();
            this.resizeColumnWidth(sheetPath.toFile(), rowBlock.getTotal());
        }
    }

    protected Path initWriter(Path root) throws IOException {
        this.workSheetPath = root.resolve("worksheets");
        if (!Files.exists(this.workSheetPath, new LinkOption[0])) {
            FileUtil.mkdir(this.workSheetPath);
        }
        this.sheet.what("0010", this.sheet.getName());
        Path sheetPath = this.workSheetPath.resolve(this.sheet.getFileName());
        this.bw = new ExtBufferedWriter(Files.newBufferedWriter(sheetPath, StandardCharsets.UTF_8, new OpenOption[0]));
        return sheetPath;
    }

    @Override
    public IWorksheetWriter setWorksheet(Sheet sheet) {
        this.sheet = sheet;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorksheetWriter clone() {
        IWorksheetWriter copy = null;
        try {
            copy = (IWorksheetWriter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this);
                ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                copy = (IWorksheetWriter)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e1) {
                try {
                    try {
                        copy = (IWorksheetWriter)this.getClass().getConstructor(Sheet.class).newInstance(this.sheet);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(oos);
                    FileUtil.close(ois);
                    throw throwable;
                }
                FileUtil.close(oos);
                FileUtil.close(ois);
            }
            FileUtil.close(oos);
            FileUtil.close(ois);
        }
        return copy;
    }

    @Override
    public int getRowLimit() {
        return 0x100000;
    }

    @Override
    public int getColumnLimit() {
        return 16384;
    }

    protected void writeBefore() throws IOException {
        this.columns = this.sheet.getHeaderColumns();
        boolean noneHeader = this.sheet.hasNonHeader();
        this.bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.bw.newLine();
        if (this.sheet.getClass().isAnnotationPresent(TopNS.class)) {
            TopNS topNS = this.sheet.getClass().getAnnotation(TopNS.class);
            this.bw.write(60);
            this.bw.write(topNS.value());
            String[] prefixs = topNS.prefix();
            String[] urls = topNS.uri();
            int i = 0;
            int len = prefixs.length;
            while (i < len) {
                this.bw.write(" xmlns");
                if (prefixs[i] != null && !prefixs[i].isEmpty()) {
                    this.bw.write(58);
                    this.bw.write(prefixs[i]);
                }
                this.bw.write("=\"");
                this.bw.write(urls[i]);
                if (++i >= len) continue;
                this.bw.write(34);
            }
        } else {
            this.bw.write("<worksheet xmlns=\"");
            this.bw.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        }
        this.bw.write("\">");
        this.bw.append("<dimension ref=\"A1");
        int n = 11;
        int size = this.sheet.size();
        if (size > 0) {
            this.bw.write(58);
            --n;
            char[] col = Sheet.int2Col(this.columns.length);
            this.bw.write(col);
            n -= col.length;
            this.bw.writeInt(size + 1);
            n -= ExtBufferedWriter.stringSize(size + 1);
        }
        this.bw.write(34);
        while (n-- > 0) {
            this.bw.write(32);
        }
        this.bw.write("/>");
        this.bw.write("<sheetViews><sheetView workbookViewId=\"0\"");
        if (this.sheet.getId() == 1) {
            this.bw.write(" tabSelected=\"1\"");
        }
        this.bw.write("/></sheetViews>");
        n = 6;
        this.bw.write("<sheetFormatPr defaultRowHeight=\"15.5\" defaultColWidth=\"");
        BigDecimal width = BigDecimal.valueOf(!noneHeader ? this.sheet.getDefaultWidth() : 8.38);
        String stringWidth = width.setScale(2, 4).toString();
        this.bw.write(stringWidth);
        this.bw.write(34);
        int i = n -= stringWidth.length();
        while (i-- >= 0) {
            this.bw.write(32);
        }
        this.bw.write("/>");
        this.bw.write("<cols>");
        for (i = 0; i < this.columns.length; ++i) {
            this.bw.write("<col customWidth=\"1\" width=\"");
            this.bw.write(stringWidth);
            this.bw.write(34);
            int j = n;
            while (j-- > 0) {
                this.bw.write(32);
            }
            this.bw.write(" max=\"");
            this.bw.writeInt(i + 1);
            this.bw.write("\" min=\"");
            this.bw.writeInt(i + 1);
            this.bw.write("\" bestFit=\"1\"/>");
        }
        this.bw.write("</cols>");
        this.bw.write("<sheetData>");
        if (!noneHeader) {
            this.writeHeaderRow();
        }
    }

    protected void writeHeaderRow() throws IOException {
        int row = 1;
        this.bw.write("<row r=\"");
        this.bw.writeInt(row);
        this.bw.write("\" customHeight=\"1\" ht=\"18.6\" spans=\"1:");
        this.bw.writeInt(this.columns.length);
        this.bw.write("\">");
        int c = 0;
        int defaultStyle = this.sheet.defaultHeadStyle();
        if (this.sheet.isAutoSize()) {
            for (Sheet.Column hc : this.columns) {
                this.writeStringAutoSize(StringUtil.isNotEmpty(hc.getName()) ? hc.getName() : hc.key, row, c++, defaultStyle);
            }
        } else {
            for (Sheet.Column hc : this.columns) {
                this.writeString(StringUtil.isNotEmpty(hc.getName()) ? hc.getName() : hc.key, row, c++, defaultStyle);
            }
        }
        this.bw.write("</row>");
    }

    protected void writeAfter(int total) throws IOException {
        Relationship r;
        this.bw.write("</sheetData>");
        if (this.sheet.getWaterMark() != null && (r = this.sheet.find("media/image")) != null) {
            this.bw.write("<picture r:id=\"");
            this.bw.write(r.getId());
            this.bw.write("\"/>");
        }
        if (this.getClass().isAnnotationPresent(TopNS.class)) {
            TopNS topNS = this.getClass().getAnnotation(TopNS.class);
            this.bw.write("</");
            this.bw.write(topNS.value());
            this.bw.write(62);
        } else {
            this.bw.write("</worksheet>");
        }
        this.sheet.what("0009", this.sheet.getName(), String.valueOf(total));
    }

    private void writeRowBlock(RowBlock rowBlock) throws IOException {
        while (rowBlock.hasNext()) {
            this.writeRow(rowBlock.next());
        }
    }

    private void writeAutoSizeRowBlock(RowBlock rowBlock) throws IOException {
        while (rowBlock.hasNext()) {
            this.writeRowAutoSize(rowBlock.next());
        }
    }

    protected int startRow(int rows, int columns) throws IOException {
        int r = rows + 2;
        if (r % 10000 == 0) {
            this.sheet.what("0014", String.valueOf(r));
        }
        this.bw.write("<row r=\"");
        this.bw.writeInt(r);
        this.bw.write("\" spans=\"1:");
        this.bw.writeInt(columns);
        this.bw.write("\">");
        return r;
    }

    protected void writeRow(Row row) throws IOException {
        Cell[] cells = row.getCells();
        int len = cells.length;
        int r = this.startRow(row.getIndex(), len);
        block10: for (int i = 0; i < len; ++i) {
            Cell cell = cells[i];
            int xf = cell.xf;
            switch (cell.t) {
                case 'r': 
                case 's': {
                    this.writeString(cell.sv, r, i, xf);
                    continue block10;
                }
                case 'a': 
                case 'n': {
                    this.writeNumeric(cell.nv, r, i, xf);
                    continue block10;
                }
                case 'l': {
                    this.writeNumeric(cell.lv, r, i, xf);
                    continue block10;
                }
                case 'd': 
                case 'i': 
                case 't': {
                    this.writeDouble(cell.dv, r, i, xf);
                    continue block10;
                }
                case 'b': {
                    this.writeBool(cell.bv, r, i, xf);
                    continue block10;
                }
                case 'm': {
                    this.writeDecimal(cell.mv, r, i, xf);
                    continue block10;
                }
                case 'c': {
                    this.writeChar(cell.cv, r, i, xf);
                    continue block10;
                }
                case 'k': {
                    this.writeNull(r, i, xf);
                    continue block10;
                }
            }
        }
        this.bw.write("</row>");
    }

    protected void writeRowAutoSize(Row row) throws IOException {
        Cell[] cells = row.getCells();
        int len = cells.length;
        int r = this.startRow(row.getIndex(), len);
        block10: for (int i = 0; i < len; ++i) {
            Cell cell = cells[i];
            int xf = cell.xf;
            switch (cell.t) {
                case 'r': 
                case 's': {
                    this.writeStringAutoSize(cell.sv, r, i, xf);
                    continue block10;
                }
                case 'a': 
                case 'n': {
                    this.writeNumericAutoSize(cell.nv, r, i, xf);
                    continue block10;
                }
                case 'l': {
                    this.writeNumericAutoSize(cell.lv, r, i, xf);
                    continue block10;
                }
                case 'd': 
                case 'i': 
                case 't': {
                    this.writeDoubleAutoSize(cell.dv, r, i, xf);
                    continue block10;
                }
                case 'b': {
                    this.writeBool(cell.bv, r, i, xf);
                    continue block10;
                }
                case 'm': {
                    this.writeDecimalAutoSize(cell.mv, r, i, xf);
                    continue block10;
                }
                case 'c': {
                    this.writeChar(cell.cv, r, i, xf);
                    continue block10;
                }
                case 'k': {
                    this.writeNull(r, i, xf);
                    continue block10;
                }
            }
        }
        this.bw.write("</row>");
    }

    protected void writeString(String s, int row, int column, int xf) throws IOException {
        int i;
        if (s != null && s.length() > Short.MAX_VALUE) {
            throw new ExcelWriteException("Characters per cell out of limit. size=" + s.length() + ", limit=" + Short.MAX_VALUE);
        }
        Sheet.Column hc = this.columns[column];
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        if (StringUtil.isEmpty(s)) {
            this.bw.write("\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"/>");
        } else if (hc.isShare() && (i = this.sst.get(s)) >= 0) {
            this.bw.write("\" t=\"s\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"><v>");
            this.bw.writeInt(i);
            this.bw.write("</v></c>");
        } else {
            this.bw.write("\" t=\"inlineStr\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"><is><t>");
            this.bw.escapeWrite(s);
            this.bw.write("</t></is></c>");
        }
    }

    protected void writeStringAutoSize(String s, int row, int column, int xf) throws IOException {
        int ln;
        this.writeString(s, row, column, xf);
        Sheet.Column hc = this.columns[column];
        if (hc.width == 0.0 && hc.o < (ln = s.getBytes(StandardCharsets.UTF_8).length)) {
            hc.o = ln;
        }
    }

    protected void writeDouble(double d, int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.write(d);
        this.bw.write("</v></c>");
    }

    protected void writeDoubleAutoSize(double d, int row, int column, int xf) throws IOException {
        int n;
        this.writeDouble(d, row, column, xf);
        Sheet.Column hc = this.columns[column];
        if (hc.width == 0.0 && hc.o < (n = Double.toString(d).length())) {
            hc.o = n;
        }
    }

    protected void writeDecimal(BigDecimal bd, int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.write(bd.toString());
        this.bw.write("</v></c>");
    }

    protected void writeDecimalAutoSize(BigDecimal bd, int row, int column, int xf) throws IOException {
        int l;
        this.writeDecimal(bd, row, column, xf);
        Sheet.Column hc = this.columns[column];
        if (hc.width == 0.0 && hc.o < (l = bd.toString().length())) {
            hc.o = l;
        }
    }

    protected void writeChar(char c, int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        this.bw.write("\" t=\"s\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.writeInt(this.sst.get(c));
        this.bw.write("</v></c>");
    }

    protected void writeNumeric(long l, int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.write(l);
        this.bw.write("</v></c>");
    }

    protected void writeNumericAutoSize(long l, int row, int column, int xf) throws IOException {
        int n;
        this.writeNumeric(l, row, column, xf);
        Sheet.Column hc = this.columns[column];
        if (hc.width == 0.0 && hc.o < (n = ExtBufferedWriter.stringSize(l))) {
            hc.o = n;
        }
    }

    protected void writeBool(boolean bool, int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        this.bw.write("\" t=\"b\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.writeInt(bool ? 1 : 0);
        this.bw.write("</v></c>");
    }

    protected void writeNull(int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(column + 1));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"/>");
    }

    protected void resizeColumnWidth(File path, int rows) throws IOException {
        if (this.columns.length <= 0 || rows <= 1) {
            return;
        }
        String[] widths = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Sheet.Column hc = this.columns[i];
            double width = hc.width;
            if (width < 1.0E-7) {
                int _l = hc.name.getBytes(StandardCharsets.UTF_8).length;
                Class<?> clazz = hc.getClazz();
                int len = IWorksheetWriter.isString(clazz) ? hc.o : (IWorksheetWriter.isDate(clazz) || IWorksheetWriter.isLocalDate(clazz) ? 10 : (IWorksheetWriter.isDateTime(clazz) || IWorksheetWriter.isLocalDateTime(clazz) ? 20 : (IWorksheetWriter.isChar(clazz) ? 1 : (IWorksheetWriter.isInt(clazz) || IWorksheetWriter.isLong(clazz) ? hc.o : (IWorksheetWriter.isFloat(clazz) || IWorksheetWriter.isDouble(clazz) ? hc.o : (IWorksheetWriter.isBigDecimal(clazz) ? hc.o : (IWorksheetWriter.isTime(clazz) || IWorksheetWriter.isLocalTime(clazz) ? 8 : (IWorksheetWriter.isBool(clazz) ? 5 : 10))))))));
                double d = width = _l > len ? (double)_l + 3.38 : (double)len + 3.38;
                if (width > 255.0) {
                    width = 255.0;
                }
            }
            widths[i] = BigDecimal.valueOf(width).setScale(2, 4).toString();
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocate(387 + this.columns.length * 73);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = channel.read(buffer);
            if (n < 0) {
                throw new ExcelWriteException("Write worksheet [" + this.sheet.getName() + "] error.");
            }
            buffer.flip();
            int position = this.findPosition(buffer, "<dimension ");
            if (position > 0) {
                buffer.put("ref=\"A1".getBytes(StandardCharsets.US_ASCII));
                int fill = 11;
                buffer.put((byte)58);
                --fill;
                char[] col = Sheet.int2Col(this.columns.length);
                buffer.put((new String(col) + (rows + 1)).getBytes(StandardCharsets.US_ASCII));
                fill -= col.length;
                fill -= ExtBufferedWriter.stringSize(rows + 1);
                buffer.put((byte)34);
                while (fill-- > 0) {
                    buffer.put((byte)32);
                }
            }
            if ((position = this.findPosition(buffer, "<cols>")) > 0) {
                for (String s : widths) {
                    position = this.findPosition(buffer, "width=\"");
                    if (position == -1) continue;
                    buffer.put(s.getBytes(StandardCharsets.US_ASCII));
                    buffer.put((byte)34);
                    int j = 6 - s.length();
                    while (j-- > 0) {
                        buffer.put((byte)32);
                    }
                }
            }
            buffer.position(n);
            buffer.flip();
            channel.position(0L);
            channel.write(buffer);
        }
    }

    private int findPosition(ByteBuffer buffer, String key) {
        block3: {
            byte[] values = key.getBytes(StandardCharsets.UTF_8);
            while (true) {
                if (buffer.hasRemaining() && buffer.get() != values[0]) {
                    continue;
                }
                if (!buffer.hasRemaining()) break block3;
                int j = 1;
                while (j < values.length && buffer.hasRemaining() && buffer.get() == values[j++]) {
                }
                if (j == values.length) break;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public void close() {
        FileUtil.close(this.bw);
    }
}

