/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ttzero.excel.annotation.DisplayName;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.IgnoreExport;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

public class ListSheet<T>
extends Sheet {
    protected List<T> data;
    private Field[] fields;
    private Method[] methods;
    protected int start;
    protected int end;
    protected boolean eof;
    private int size;
    private static final String[] exclude = new String[]{"serialVersionUID", "this$0"};

    public ListSheet() {
    }

    public ListSheet(String name) {
        super(name);
    }

    public ListSheet(String name, Sheet.Column ... columns) {
        super(name, columns);
    }

    public ListSheet(String name, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListSheet(List<T> data) {
        this(null, data);
    }

    public ListSheet(String name, List<T> data) {
        super(name);
        this.setData(data);
    }

    public ListSheet(List<T> data, Sheet.Column ... columns) {
        this(null, data, columns);
    }

    public ListSheet(String name, List<T> data, Sheet.Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListSheet(List<T> data, WaterMark waterMark, Sheet.Column ... columns) {
        this(null, data, waterMark, columns);
    }

    public ListSheet(String name, List<T> data, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    public ListSheet<T> setData(List<T> data) {
        this.data = data;
        if (!this.headerReady && this.workbook != null) {
            this.getHeaderColumns();
        }
        if (data != null && this.sheetWriter != null) {
            this.paging();
        }
        return this;
    }

    protected T getFirst() {
        if (this.data == null) {
            return null;
        }
        T first = this.data.get(this.start);
        if (first != null) {
            return first;
        }
        int i = this.start + 1;
        while ((first = this.data.get(i++)) == null) {
        }
        return first;
    }

    @Override
    public void close() throws IOException {
        List<T> list;
        if (!this.eof && this.rows >= this.sheetWriter.getRowLimit() - 1 && (list = this.more()) != null && !list.isEmpty()) {
            this.compact();
            this.data.addAll(list);
            ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
            copy.start = 0;
            copy.end = list.size();
            this.workbook.insertSheet(this.id, copy);
            this.shouldClose = false;
        }
        if (this.shouldClose && this.data != null) {
            this.data = null;
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.left() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        try {
            while (this.start < end) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                Cell[] cells = row.realloc(len);
                T o = this.data.get(this.start);
                for (int i = 0; i < len; ++i) {
                    Cell cell = cells[i];
                    cell.clear();
                    Object e = this.methods[i] != null ? this.methods[i].invoke(o, new Object[0]) : this.fields[i].get(o);
                    this.cellValueAndStyle.reset(this.rows, cell, e, this.columns[i]);
                }
                ++this.rows;
                ++this.start;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExcelWriteException(e);
        }
    }

    protected void append() {
        block4: {
            int rbs = this.getRowBlockSize();
            while (true) {
                List<T> list;
                if ((list = this.more()) == null || list.isEmpty()) {
                    this.shouldClose = true;
                    this.eof = true;
                    break block4;
                }
                if (this.data == null) {
                    this.setData(list);
                    if (list.size() < rbs) {
                        continue;
                    }
                    break block4;
                }
                this.compact();
                this.data.addAll(list);
                this.start = 0;
                this.end = this.data.size();
                if (this.end >= rbs) break;
            }
            this.paging();
        }
    }

    private void compact() {
        int size = this.left();
        if (this.start > 0 && size > 0) {
            ArrayList<T> last = new ArrayList<T>(size);
            last.addAll(this.data.subList(this.start, this.end));
            this.data.clear();
            this.data.addAll(last);
        } else if (this.start > 0) {
            this.data.clear();
        }
    }

    private Class<?> getTClass() {
        Class clazz;
        if (this.getClass().getGenericSuperclass() instanceof ParameterizedType) {
            Class tClass;
            clazz = tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        } else {
            T o = this.getFirst();
            if (o == null) {
                return null;
            }
            clazz = o.getClass();
        }
        return clazz;
    }

    private int methodMapping(Class<?> clazz, Method[] readMethods, Map<String, Method> tmp) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            Method[] allMethods = clazz.getMethods();
            Method[] mergedMethods = new Method[propertyDescriptors.length];
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                Method method = propertyDescriptors[i].getReadMethod();
                if (method == null) continue;
                int index = ReflectUtil.indexOf(allMethods, method);
                mergedMethods[i] = index >= 0 ? allMethods[index] : method;
            }
            return ReflectUtil.mapping(readMethods, tmp, propertyDescriptors, mergedMethods);
        }
        catch (IntrospectionException e) {
            this.what("Get " + clazz + " property descriptor failed.");
            return 0;
        }
    }

    private int init() {
        Class<?> clazz = this.getTClass();
        if (clazz == null) {
            return 0;
        }
        Field[] declaredFields = ReflectUtil.listDeclaredFields(clazz);
        Method[] readMethods = null;
        try {
            readMethods = ReflectUtil.listReadMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null);
        }
        catch (IntrospectionException e) {
            this.what("Get " + clazz + " read declared failed.");
        }
        LinkedHashMap<String, Method> tmp = new LinkedHashMap<String, Method>();
        int readLength = this.methodMapping(clazz, readMethods, tmp);
        if (!this.hasHeaderColumns()) {
            int i;
            this.methods = new Method[declaredFields.length + readLength];
            ArrayList<Sheet.Column> list = new ArrayList<Sheet.Column>(declaredFields.length);
            for (i = 0; i < declaredFields.length; ++i) {
                IgnoreExport notExport;
                Field field = declaredFields[i];
                field.setAccessible(true);
                String gs = field.getName();
                Method method2 = (Method)tmp.get(gs);
                if (method2 != null) {
                    if (method2.getAnnotation(IgnoreExport.class) != null) {
                        declaredFields[i] = null;
                        continue;
                    }
                    method2.setAccessible(true);
                    this.methods[i] = method2;
                    ExcelColumn mec = method2.getAnnotation(ExcelColumn.class);
                    if (mec != null && StringUtil.isNotEmpty(mec.value())) {
                        list.add(new Sheet.Column(mec.value(), field.getName(), method2.getReturnType()).setShare(mec.share()));
                        continue;
                    }
                }
                if ((notExport = field.getAnnotation(IgnoreExport.class)) != null || StringUtil.indexOf(exclude, gs.substring(gs.lastIndexOf(46) + 1)) >= 0) {
                    declaredFields[i] = null;
                    continue;
                }
                ExcelColumn ec = field.getAnnotation(ExcelColumn.class);
                DisplayName dn = field.getAnnotation(DisplayName.class);
                if (ec != null && StringUtil.isNotEmpty(ec.value())) {
                    list.add(new Sheet.Column(ec.value(), field.getName(), field.getType()).setShare(ec.share()));
                    continue;
                }
                if (dn != null && StringUtil.isNotEmpty(dn.value())) {
                    list.add(new Sheet.Column(dn.value(), field.getName(), field.getType()).setShare(dn.share()));
                    continue;
                }
                if (method2 == null) continue;
                list.add(new Sheet.Column(field.getName(), field.getName(), field.getType()).setShare(ec == null || ec.share()));
            }
            if (readLength > 0) {
                for (int j = 0; j < readLength; ++j) {
                    Method readMethod = readMethods[j];
                    readMethod.setAccessible(true);
                    this.methods[i++] = readMethod;
                    ExcelColumn mec = readMethod.getAnnotation(ExcelColumn.class);
                    list.add(new Sheet.Column(mec.value(), readMethod.getName(), readMethod.getReturnType()).setShare(mec.share()));
                }
            }
            if (list.isEmpty()) {
                this.shouldClose = true;
                this.eof = true;
                this.headerReady = true;
                this.end = 0;
                this.what("Class [" + clazz + "] do not contains getter method and ExcelColumn annotation.");
                return 0;
            }
            this.columns = new Sheet.Column[list.size()];
            list.toArray(this.columns);
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].styles = this.workbook.getStyles();
            }
            i = 0;
            this.fields = new Field[this.columns.length];
            for (int j = 0; j < declaredFields.length; ++j) {
                if (declaredFields[j] == null) continue;
                declaredFields[j].setAccessible(true);
                this.fields[i] = declaredFields[j];
                this.methods[i] = this.methods[j];
                ++i;
            }
            if (declaredFields.length < this.methods.length) {
                System.arraycopy(this.methods, declaredFields.length, this.methods, i, this.methods.length - declaredFields.length);
                i += this.methods.length - declaredFields.length;
            }
            return i + readLength;
        }
        this.fields = new Field[this.columns.length];
        this.methods = new Method[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Sheet.Column hc = this.columns[i];
            this.methods[i] = (Method)tmp.get(hc.key);
            if (this.methods[i] != null) {
                this.methods[i].setAccessible(true);
            }
            for (Field field : declaredFields) {
                if (!hc.key.equals(field.getName())) continue;
                field.setAccessible(true);
                this.fields[i] = field;
                break;
            }
            if (this.methods[i] == null && this.fields[i] == null) {
                throw new ExcelWriteException("Column [" + hc.getName() + "(" + hc.key + ")] not declare in class " + clazz);
            }
            if (hc.getClazz() != null) continue;
            hc.setClazz(this.methods[i] != null ? this.methods[i].getReturnType() : this.fields[i].getType());
        }
        return this.columns.length;
    }

    @Override
    public Sheet.Column[] getHeaderColumns() {
        if (!this.headerReady) {
            int size = this.init();
            if (size <= 0) {
                this.columns = new Sheet.Column[0];
            } else {
                this.checkColumnLimit();
                this.headerReady = true;
            }
        }
        return this.columns;
    }

    protected int getEndIndex() {
        int end;
        int rowLimit;
        int blockSize = this.getRowBlockSize();
        if (this.rows + blockSize > (rowLimit = this.sheetWriter.getRowLimit() - 1)) {
            blockSize = rowLimit - this.rows;
        }
        return (end = this.start + blockSize) <= this.end ? end : this.end;
    }

    @Override
    public int size() {
        return !this.shouldClose ? this.size : -1;
    }

    protected int left() {
        return this.end - this.start;
    }

    @Override
    protected void paging() {
        int limit;
        int len = this.dataSize();
        if (len + this.rows > (limit = this.sheetWriter.getRowLimit() - 1)) {
            this.end = limit - this.rows + this.start;
            this.shouldClose = false;
            this.eof = true;
            this.size = limit;
            int n = this.id;
            int i = this.end;
            while (i < len) {
                ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
                copy.start = i;
                i = i + limit < len ? i + limit : len;
                copy.end = i;
                copy.size = copy.end - copy.start;
                copy.eof = copy.size == limit;
                this.workbook.insertSheet(n++, copy);
            }
            this.workbook.getSheetAt((int)(n - 1)).shouldClose = true;
        } else {
            this.end = len;
            this.size += len;
        }
    }

    public int dataSize() {
        return this.data != null ? this.data.size() : 0;
    }

    protected List<T> more() {
        return null;
    }
}

