/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.SharedStrings;

class PreCalc {
    private long position;
    private char[] cb;
    private Node head;
    private Node tail;

    PreCalc(long position) {
        this.position = position;
    }

    void setCalc(char[] cb) {
        int f;
        this.cb = cb;
        int len = cb.length;
        int m = f = 0;
        while (f < len) {
            int r;
            while (f < len && (cb[f] < 'A' || cb[f] > 'Z') && cb[f] != '\"') {
                ++f;
            }
            if (f >= len) break;
            if (cb[f] == '\"') {
                while (++f < len && cb[f] != '\"') {
                }
                if (f >= len) break;
                ++f;
                continue;
            }
            int n = f;
            while (f < len && cb[f] >= 'A' && cb[f] <= 'Z') {
                ++f;
            }
            int c = Row.toCellIndex(cb, n, f);
            if (c < 0 || c > 16384) continue;
            int t = f;
            while (f < len && cb[f] >= '0' && cb[f] <= '9') {
                ++f;
            }
            if (f == t || (r = SharedStrings.toInt(cb, t, f)) < 0 || r > 0x100000) continue;
            Node node = new Node();
            node.f = m;
            node.t = n;
            if (this.head == null) {
                this.head = this.tail = node;
            } else {
                this.tail.next = node;
                this.tail = node;
            }
            Node next = new Node();
            next.coordinate = r << 14 | c;
            this.tail.next = next;
            this.tail = next;
            m = f;
        }
        if (m > 0 && m < f) {
            Node node = new Node();
            node.f = m;
            node.t = f;
            this.tail.next = node;
            this.tail = node;
        }
    }

    String get(long coordinate) {
        if (this.head == null) {
            return new String(this.cb, 0, this.cb.length);
        }
        int offset_x = (int)((coordinate & 0x3FFFL) - (this.position >> 28 & 0x3FFFL));
        int offset_y = (int)((coordinate >> 14 & 0xFFFFFL) - (this.position >> 42 & 0xFFFFFL));
        Node node = this.head;
        StringBuilder buf = new StringBuilder();
        while (node != null) {
            if (node.coordinate > 0L) {
                buf.append(Sheet.int2Col((int)(node.coordinate & 0x3FFFL) + offset_x));
                buf.append((int)(node.coordinate >> 14) + offset_y);
            } else {
                buf.append(this.cb, node.f, node.t - node.f);
            }
            node = node.next;
        }
        return buf.toString();
    }

    public String toString() {
        return this.get((this.position >> 42 & 0xFFFFFL) << 14 | this.position >> 28 & 0x3FFFL);
    }

    private static class Node {
        private int f;
        private int t;
        private long coordinate;
        private Node next;

        private Node() {
        }
    }
}

