/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.PreCalc;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.UncheckedTypeException;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

public abstract class Row {
    protected Logger logger = LogManager.getLogger(this.getClass());
    int index = -1;
    int fc = 0;
    int lc = -1;
    Cell[] cells;
    SharedStrings sst;
    protected HeaderRow hr;
    boolean unknownLength;
    private PreCalc[] sharedCalc;
    Styles styles;

    public int getRowNumber() {
        return this.index;
    }

    public int getFirstColumnIndex() {
        return this.fc;
    }

    public int getLastColumnIndex() {
        return this.lc;
    }

    public boolean isEmpty() {
        return this.lc - this.fc <= 0;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.lc;
    }

    protected void rangeCheck(int index) {
        if (index >= this.lc || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected Cell getCell(int i) {
        this.rangeCheck(i);
        return this.cells[i];
    }

    protected Cell getCell(String name) {
        int i = this.hr.getIndex(name);
        this.rangeCheck(i);
        return this.cells[i];
    }

    HeaderRow asHeader() {
        HeaderRow hr;
        this.hr = hr = HeaderRow.with(this);
        return hr;
    }

    Row setHr(HeaderRow hr) {
        this.hr = hr;
        return this;
    }

    public boolean getBoolean(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getBoolean(c);
    }

    public boolean getBoolean(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getBoolean(c);
    }

    protected boolean getBoolean(Cell c) {
        boolean v;
        switch (c.t) {
            case 'b': {
                v = c.bv;
                break;
            }
            case 'd': 
            case 'n': {
                v = c.nv != 0 || c.dv >= 1.0E-6 || c.dv <= -1.0E-6;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                v = StringUtil.isNotEmpty(c.sv);
                break;
            }
            case 'r': {
                v = StringUtil.isNotEmpty(c.sv);
                break;
            }
            default: {
                v = false;
            }
        }
        return v;
    }

    public byte getByte(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getByte(c);
    }

    public byte getByte(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getByte(c);
    }

    protected byte getByte(Cell c) {
        byte b = 0;
        switch (c.t) {
            case 'n': {
                b = (byte)(b | c.nv);
                break;
            }
            case 'l': {
                b = (byte)((long)b | c.lv);
                break;
            }
            case 'b': {
                b = (byte)(b | (c.bv ? 1 : 0));
                break;
            }
            case 'd': {
                b = (byte)(b | (int)c.dv);
                break;
            }
            default: {
                throw new UncheckedTypeException("can't convert to byte");
            }
        }
        return b;
    }

    public char getChar(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getChar(c);
    }

    public char getChar(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getChar(c);
    }

    protected char getChar(Cell c) {
        char cc = '\u0000';
        switch (c.t) {
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                if (!StringUtil.isNotEmpty(c.sv)) break;
                cc = (char)(cc | c.sv.charAt(0));
                break;
            }
            case 'r': {
                if (!StringUtil.isNotEmpty(c.sv)) break;
                cc = (char)(cc | c.sv.charAt(0));
                break;
            }
            case 'n': {
                cc = (char)(cc | c.nv);
                break;
            }
            case 'l': {
                cc = (char)((long)cc | c.lv);
                break;
            }
            case 'b': {
                cc = (char)(cc | (c.bv ? (char)'\u0001' : '\u0000'));
                break;
            }
            case 'd': {
                cc = (char)(cc | (int)c.dv);
                break;
            }
            default: {
                throw new UncheckedTypeException("can't convert to char");
            }
        }
        return cc;
    }

    public short getShort(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getShort(c);
    }

    public short getShort(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getShort(c);
    }

    protected short getShort(Cell c) {
        short s = 0;
        switch (c.t) {
            case 'n': {
                s = (short)(s | c.nv);
                break;
            }
            case 'l': {
                s = (short)((long)s | c.lv);
                break;
            }
            case 'b': {
                s = (short)(s | (c.bv ? 1 : 0));
                break;
            }
            case 'd': {
                s = (short)(s | (int)c.dv);
                break;
            }
            default: {
                throw new UncheckedTypeException("can't convert to short");
            }
        }
        return s;
    }

    public int getInt(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getInt(c);
    }

    public int getInt(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getInt(c);
    }

    protected int getInt(Cell c) {
        int n;
        switch (c.t) {
            case 'n': {
                n = c.nv;
                break;
            }
            case 'l': {
                n = (int)c.lv;
                break;
            }
            case 'd': {
                n = (int)c.dv;
                break;
            }
            case 'b': {
                n = c.bv ? 1 : 0;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                n = Integer.parseInt(c.sv);
                break;
            }
            case 'r': {
                n = Integer.parseInt(c.sv);
                break;
            }
            default: {
                throw new UncheckedTypeException("unknown type");
            }
        }
        return n;
    }

    public long getLong(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getLong(c);
    }

    public long getLong(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getLong(c);
    }

    protected long getLong(Cell c) {
        long l;
        switch (c.t) {
            case 'l': {
                l = c.lv;
                break;
            }
            case 'n': {
                l = c.nv;
                break;
            }
            case 'd': {
                l = (long)c.dv;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                l = Long.parseLong(c.sv);
                break;
            }
            case 'r': {
                l = Long.parseLong(c.sv);
                break;
            }
            case 'b': {
                l = c.bv ? 1L : 0L;
                break;
            }
            default: {
                throw new UncheckedTypeException("unknown type");
            }
        }
        return l;
    }

    public String getString(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getString(c);
    }

    public String getString(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getString(c);
    }

    protected String getString(Cell c) {
        String s;
        switch (c.t) {
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                s = c.sv;
                break;
            }
            case 'r': {
                s = c.sv;
                break;
            }
            case 'k': {
                s = "";
                break;
            }
            case 'l': {
                s = String.valueOf(c.lv);
                break;
            }
            case 'n': {
                s = String.valueOf(c.nv);
                break;
            }
            case 'd': {
                s = String.valueOf(c.dv);
                break;
            }
            case 'b': {
                s = c.bv ? "true" : "false";
                break;
            }
            default: {
                s = c.sv;
            }
        }
        return s;
    }

    public float getFloat(int columnIndex) {
        return (float)this.getDouble(columnIndex);
    }

    public float getFloat(String columnName) {
        return (float)this.getDouble(columnName);
    }

    public double getDouble(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getDouble(c);
    }

    public double getDouble(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getDouble(c);
    }

    protected double getDouble(Cell c) {
        double d;
        switch (c.t) {
            case 'd': {
                d = c.dv;
                break;
            }
            case 'n': {
                d = c.nv;
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                d = Double.valueOf(c.sv);
                break;
            }
            case 'r': {
                d = Double.valueOf(c.sv);
                break;
            }
            default: {
                throw new UncheckedTypeException("unknown type");
            }
        }
        return d;
    }

    public BigDecimal getDecimal(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getDecimal(c);
    }

    public BigDecimal getDecimal(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getDecimal(c);
    }

    protected BigDecimal getDecimal(Cell c) {
        BigDecimal bd;
        switch (c.t) {
            case 'd': {
                bd = BigDecimal.valueOf(c.dv);
                break;
            }
            case 'n': {
                bd = BigDecimal.valueOf(c.nv);
                break;
            }
            default: {
                bd = new BigDecimal(c.sv);
            }
        }
        return bd;
    }

    public Date getDate(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getDate(c);
    }

    public Date getDate(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getDate(c);
    }

    protected Date getDate(Cell c) {
        Date date;
        switch (c.t) {
            case 'n': {
                date = DateUtil.toDate(c.nv);
                break;
            }
            case 'd': {
                date = DateUtil.toDate(c.dv);
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                date = DateUtil.toDate(c.sv);
                break;
            }
            case 'r': {
                date = DateUtil.toDate(c.sv);
                break;
            }
            default: {
                throw new UncheckedTypeException("");
            }
        }
        return date;
    }

    public Timestamp getTimestamp(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getTimestamp(c);
    }

    public Timestamp getTimestamp(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getTimestamp(c);
    }

    protected Timestamp getTimestamp(Cell c) {
        Timestamp ts;
        switch (c.t) {
            case 'n': {
                ts = DateUtil.toTimestamp(c.nv);
                break;
            }
            case 'd': {
                ts = DateUtil.toTimestamp(c.dv);
                break;
            }
            case 's': {
                if (c.sv == null) {
                    c.setSv(this.sst.get(c.nv));
                }
                ts = DateUtil.toTimestamp(c.sv);
                break;
            }
            case 'r': {
                ts = DateUtil.toTimestamp(c.sv);
                break;
            }
            default: {
                throw new UncheckedTypeException("");
            }
        }
        return ts;
    }

    public Time getTime(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        if (c.t == 'd') {
            return DateUtil.toTime(c.dv);
        }
        throw new UncheckedTypeException("can't convert to java.sql.Time");
    }

    public Time getTime(String columnName) {
        Cell c = this.getCell(columnName);
        if (c.t == 'd') {
            return DateUtil.toTime(c.dv);
        }
        throw new UncheckedTypeException("can't convert to java.sql.Time");
    }

    public String getFormula(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return c.fv;
    }

    public String getFormula(String columnName) {
        Cell c = this.getCell(columnName);
        return c.fv;
    }

    public boolean hasFormula(int columnIndex) {
        return this.getCell((int)columnIndex).f;
    }

    public boolean hasFormula(String columnName) {
        return this.getCell((String)columnName).f;
    }

    public CellType getCellType(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getCellType(c);
    }

    public CellType getCellType(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getCellType(c);
    }

    protected CellType getCellType(Cell c) {
        CellType type;
        switch (c.t) {
            case 'r': 
            case 's': {
                type = CellType.STRING;
                break;
            }
            case 'c': 
            case 'n': {
                type = !this.styles.fastTestDateFmt(c.xf) ? CellType.INTEGER : CellType.DATE;
                break;
            }
            case 'l': {
                type = CellType.LONG;
                break;
            }
            case 'd': {
                type = !this.styles.fastTestDateFmt(c.xf) ? CellType.DOUBLE : CellType.DATE;
                break;
            }
            case 'b': {
                type = CellType.BOOLEAN;
                break;
            }
            case 'a': 
            case 'i': 
            case 't': {
                type = CellType.DATE;
                break;
            }
            case 'k': {
                type = CellType.BLANK;
                break;
            }
            default: {
                type = CellType.STRING;
            }
        }
        return type;
    }

    public <T> T get() {
        if (this.hr != null && this.hr.getClazz() != null) {
            Object t;
            try {
                t = this.hr.getClazz().newInstance();
                this.hr.put(this, t);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new UncheckedTypeException(this.hr.getClazz() + " new instance error.", e);
            }
            return (T)t;
        }
        return (T)this;
    }

    public <T> T geet() {
        if (this.hr != null && this.hr.getClazz() != null) {
            Object t = this.hr.getT();
            try {
                this.hr.put(this, t);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UncheckedTypeException("call set method error.", e);
            }
            return t;
        }
        return (T)this;
    }

    public <T> T to(Class<T> clazz) {
        T t;
        if (this.hr == null) {
            throw new UncheckedTypeException("Lost header row info");
        }
        if (!this.hr.is(clazz)) {
            this.hr.setClass(clazz);
        }
        try {
            t = clazz.newInstance();
            this.hr.put(this, t);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UncheckedTypeException(clazz + " new instance error.", e);
        }
        return t;
    }

    public <T> T too(Class<T> clazz) {
        if (this.hr == null) {
            throw new UncheckedTypeException("Lost header row info");
        }
        if (!this.hr.is(clazz)) {
            try {
                this.hr.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UncheckedTypeException(clazz + " new instance error.", e);
            }
        }
        Object t = this.hr.getT();
        try {
            this.hr.put(this, t);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new UncheckedTypeException("call set method error.", e);
        }
        return t;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" | ");
        block9: for (int i = this.fc; i < this.lc; ++i) {
            Cell c = this.cells[i];
            switch (c.t) {
                case 's': {
                    if (c.sv == null) {
                        c.setSv(this.sst.get(c.nv));
                    }
                    joiner.add(c.sv);
                    continue block9;
                }
                case 'r': {
                    joiner.add(c.sv);
                    continue block9;
                }
                case 'b': {
                    joiner.add(String.valueOf(c.bv));
                    continue block9;
                }
                case 'n': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        joiner.add(String.valueOf(c.nv));
                        continue block9;
                    }
                    joiner.add(DateUtil.toLocalDate(c.nv).toString());
                    continue block9;
                }
                case 'l': {
                    joiner.add(String.valueOf(c.lv));
                    continue block9;
                }
                case 'd': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        joiner.add(String.valueOf(c.dv));
                        continue block9;
                    }
                    joiner.add(DateUtil.toTimestamp(c.dv).toString());
                    continue block9;
                }
                case 'e': 
                case 'k': {
                    joiner.add("");
                    continue block9;
                }
                default: {
                    joiner.add(null);
                }
            }
        }
        return joiner.toString();
    }

    void addRef(int i, String ref) {
        if (StringUtil.isEmpty(ref) || ref.indexOf(58) < 0) {
            return;
        }
        if (this.sharedCalc == null) {
            this.sharedCalc = new PreCalc[Math.max(10, i + 1)];
        } else if (i >= this.sharedCalc.length) {
            this.sharedCalc = Arrays.copyOf(this.sharedCalc, i + 10);
        }
        Dimension dim = Dimension.of(ref);
        long l = 0L;
        l |= (long)(dim.firstRow & 0xFFFFF) << 42;
        l |= (long)(dim.firstColumn & 0x3FFF) << 28;
        if (dim.firstColumn == dim.lastColumn) {
            l |= (long)((dim.lastRow - dim.firstRow & 0xFFFFF) << 8);
            l |= 2L;
        } else if (dim.firstRow == dim.lastRow) {
            l |= (long)((dim.lastColumn - dim.firstColumn & 0x3FFF) << 14);
            l |= 1L;
        }
        this.sharedCalc[i] = new PreCalc(l);
    }

    void setCalc(int i, String calc) {
        if (this.sharedCalc == null || this.sharedCalc.length <= i || this.sharedCalc[i] == null || StringUtil.isEmpty(calc)) {
            return;
        }
        this.sharedCalc[i].setCalc(calc.toCharArray());
    }

    String getCalc(int i, long coordinate) {
        if (this.sharedCalc == null || this.sharedCalc.length <= i || this.sharedCalc[i] == null) {
            return "";
        }
        return this.sharedCalc[i].get(coordinate);
    }

    public static int toCellIndex(char[] cb, int a, int b) {
        int n = 0;
        while (a <= b) {
            if (cb[a] <= 'Z' && cb[a] >= 'A') {
                n = n * 26 + cb[a] - 64;
            } else {
                if (cb[a] > 'z' || cb[a] < 'a') break;
                n = n * 26 + cb[a] - 12289;
            }
            ++a;
        }
        return n;
    }
}

