/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.util.Arrays;
import org.ttzero.excel.reader.CalcSheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.XMLCalcRow;
import org.ttzero.excel.reader.XMLSheet;

class XMLCalcSheet
extends XMLSheet
implements CalcSheet {
    private long[] calc;

    XMLCalcSheet() {
    }

    XMLCalcSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
    }

    @Override
    public XMLCalcSheet load() throws IOException {
        super.load();
        if (!this.eof && !(this.sRow instanceof XMLCalcRow) && this.calc != null) {
            this.sRow = this.sRow.asCalcRow().setCalcFun(this::findCalc);
        }
        return this;
    }

    XMLCalcSheet setCalc(long[] calc) {
        this.calc = calc;
        return this;
    }

    @Override
    Row createHeader(char[] cb, int start, int n) {
        return new XMLCalcRow(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1, this::findCalc).with(cb, start, n);
    }

    private void findCalc(int row, Cell[] cells, int n) {
        long r = (long)row << 16;
        int i = Arrays.binarySearch(this.calc, r);
        if (i < 0 && (i ^= 0xFFFFFFFF) >= this.calc.length) {
            return;
        }
        long a = this.calc[i];
        if ((int)(a >> 16) != row) {
            return;
        }
        cells[((int)a & Short.MAX_VALUE) - 1].f = true;
        int j = 1;
        if (n == -1) {
            n = cells.length;
        }
        n = Math.min(n, this.calc.length - i);
        while (j < n && this.calc[i + j] >> 16 == (long)row) {
            cells[((int)this.calc[i + j] & Short.MAX_VALUE) - 1].f = true;
            ++j;
        }
    }
}

