/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.XMLCalcRow;
import org.ttzero.excel.reader.XMLMergeRow;

class XMLRow
extends Row {
    int startRow;
    StringBuilder buf;
    char[] cb;
    int from;
    int to;
    int cursor;
    int e;

    @Override
    public int getRowNumber() {
        if (this.index == -1) {
            this.searchRowNumber();
        }
        return this.index;
    }

    XMLRow() {
    }

    XMLRow(SharedStrings sst, Styles styles, int startRow) {
        this.sst = sst;
        this.styles = styles;
        this.startRow = startRow;
        this.buf = new StringBuilder();
    }

    XMLRow with(char[] cb, int from, int size) {
        this.cb = cb;
        this.from = from;
        this.to = from + size;
        this.cursor = from;
        this.lc = -1;
        this.index = -1;
        this.parseCells();
        return this;
    }

    XMLRow empty(char[] cb, int from, int size) {
        this.cb = cb;
        this.from = from;
        this.to = from + size;
        this.cursor = from;
        this.index = -1;
        this.lc = -1;
        this.fc = -1;
        return this;
    }

    private void searchRowNumber() {
        for (int _f = this.from + 4; this.cb[_f] != '>' && _f < this.to; ++_f) {
            if (this.cb[_f] > ' ' || this.cb[_f + 1] != 'r' || this.cb[_f + 2] != '=') continue;
            int a = _f += 4;
            while (this.cb[_f] != '\"' && _f < this.to) {
                ++_f;
            }
            if (_f <= a) break;
            this.index = SharedStrings.toInt(this.cb, a, _f);
            break;
        }
    }

    int searchSpan() {
        int len;
        int i = this.from + 4;
        int _lc = this.lc;
        while (this.cb[i] != '>') {
            if (this.cb[i] <= ' ' && this.cb[i + 1] == 's' && this.cb[i + 2] == 'p' && this.cb[i + 3] == 'a' && this.cb[i + 4] == 'n' && this.cb[i + 5] == 's' && this.cb[i + 6] == '=') {
                int j = i += 8;
                while (this.cb[i] != '\"' && this.cb[i] != '>') {
                    ++i;
                }
                int b = i - 1;
                while (this.cb[b] != ':') {
                    --b;
                }
                if (++b < i) {
                    this.lc = SharedStrings.toInt(this.cb, b, i);
                }
                if (j < --b) {
                    this.fc = SharedStrings.toInt(this.cb, j, b);
                }
            }
            ++i;
        }
        if (this.fc <= 0) {
            this.fc = this.startRow;
        }
        if (this.hr != null && this.lc < this.hr.lc) {
            this.lc = this.hr.lc;
        }
        --this.fc;
        if (this.cells == null || this.lc > this.cells.length) {
            this.cells = new Cell[this.lc > 0 ? this.lc : 100];
        }
        int n = len = this.lc > 0 ? Math.max(this.lc, _lc) : this.cells.length;
        for (int n2 = 0; n2 < len; ++n2) {
            if (this.cells[n2] != null) {
                this.cells[n2].clear();
                continue;
            }
            this.cells[n2] = new Cell((short)(n2 + 1));
        }
        return i;
    }

    void parseCells() {
        this.cursor = this.searchSpan();
        while (this.cb[this.cursor++] != '>') {
        }
        this.unknownLength = this.lc < 0;
        int index = 0;
        if (this.unknownLength) {
            Cell cell;
            while ((cell = this.nextCell()) != null) {
                ++index;
                this.parseCellValue(cell);
            }
        } else {
            Cell cell;
            while (index < this.lc && (cell = this.nextCell()) != null) {
                this.parseCellValue(cell);
            }
        }
    }

    protected Cell nextCell() {
        while (this.cursor < this.to && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != 'c' || this.cb[this.cursor + 2] > ' ')) {
            ++this.cursor;
        }
        if (this.cursor >= this.to) {
            return null;
        }
        this.cursor += 2;
        this.e = this.cursor;
        while (this.e < this.to && (this.cb[this.e] != '<' || this.cb[this.e + 1] != 'c' || this.cb[this.e + 2] > ' ')) {
            ++this.e;
        }
        Cell cell = null;
        int t = 110;
        int xf = 0;
        while (this.cb[this.cursor] != '>') {
            int a;
            if (this.cb[this.cursor] <= ' ' && this.cb[this.cursor + 1] == 'r' && this.cb[this.cursor + 2] == '=') {
                int n;
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                if (this.unknownLength) {
                    n = XMLRow.toCellIndex(this.cb, a, this.cursor);
                    this.lc = this.lc;
                } else {
                    n = XMLRow.toCellIndex(this.cb, a, this.cursor);
                }
                int i = n;
                cell = this.cells[i - 1];
            }
            if (this.cb[this.cursor] <= ' ' && this.cb[this.cursor + 1] == 't' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                int n = this.cursor - a;
                if (n == 1) {
                    t = this.cb[a];
                } else if (n == 3 && this.cb[a] == 's' && this.cb[a + 1] == 't' && this.cb[a + 2] == 'r') {
                    t = 102;
                } else if (n == 9 && this.cb[a] == 'i' && this.cb[a + 1] == 'n' && this.cb[a + 2] == 'l' && this.cb[a + 6] == 'S' && this.cb[a + 8] == 'r') {
                    t = 114;
                }
            }
            if (this.cb[this.cursor] <= ' ' && this.cb[this.cursor + 1] == 's' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                xf = SharedStrings.toInt(this.cb, a, this.cursor);
            }
            ++this.cursor;
        }
        if (cell == null) {
            return null;
        }
        cell.xf = xf;
        cell.t = (char)t;
        return cell;
    }

    private long toLong(int a, int b) {
        boolean _n = this.cb[a] == '-';
        if (_n) {
            // empty if block
        }
        int n = ++a;
        ++a;
        long n2 = this.cb[n] - 48;
        while (b > a) {
            n2 = n2 * 10L + (long)this.cb[a++] - 48L;
        }
        return _n ? -n2 : n2;
    }

    private String toString(int a, int b) {
        return new String(this.cb, a, b - a);
    }

    private double toDouble(int a, int b) {
        return Double.parseDouble(this.toString(a, b));
    }

    private boolean isNumber(int a, int b) {
        char c;
        if (a == b) {
            return false;
        }
        if (this.cb[a] == '-') {
            ++a;
        }
        while (a < b && (c = this.cb[a++]) >= '0' && c <= '9') {
        }
        return a == b;
    }

    private boolean isDouble(int a, int b) {
        if (a == b) {
            return false;
        }
        if (this.cb[a] == '-') {
            ++a;
        }
        int i = 0;
        int e = 0;
        while (a < b) {
            char c = this.cb[a++];
            if (i > 1 || e > 1) {
                return false;
            }
            if (c == '.') {
                i = (char)(i + 1);
                continue;
            }
            if (c == 'e' || c == 'E') {
                e = (char)(e + 1);
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private int get(char c) {
        return this.get(null, c, null);
    }

    int get(Cell cell, char c, Attribute attrConsumer) {
        int a;
        while (this.cursor < this.e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != c || this.cb[this.cursor + 2] != '>' && this.cb[this.cursor + 2] > ' ' && this.cb[this.cursor + 2] != '/')) {
            ++this.cursor;
        }
        if (this.cursor == this.e) {
            return this.cursor;
        }
        if (this.cb[this.cursor + 2] == '>') {
            a = this.cursor += 3;
        } else if (this.cb[this.cursor + 2] == ' ') {
            int i = this.cursor + 3;
            while (this.cursor < this.e && this.cb[this.cursor] != '>') {
                ++this.cursor;
            }
            if (attrConsumer != null) {
                attrConsumer.accept(cell, this.cb, i, this.cb[this.cursor - 1] != '/' ? this.cursor : this.cursor - 1);
            }
            ++this.cursor;
            if (this.cb[this.cursor - 2] == '/' || this.cursor == this.e) {
                return this.cursor;
            }
            a = this.cursor;
        } else {
            if (this.cb[this.cursor + 2] == '/') {
                this.cursor += 3;
                return this.cursor;
            }
            a = this.cursor += 3;
        }
        while (this.cursor < this.e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != '/' || this.cb[this.cursor + 2] != c || this.cb[this.cursor + 3] != '>')) {
            ++this.cursor;
        }
        return a;
    }

    private int getT() {
        return this.get('t');
    }

    private int getV() {
        return this.get('v');
    }

    void parseCellValue(Cell cell) {
        switch (cell.t) {
            case 'r': {
                int a = this.getT();
                if (a > this.cursor) {
                    cell.setSv(SharedStrings.unescape(this.buf, this.cb, a, this.cursor));
                    break;
                }
                cell.setT('k');
                break;
            }
            case 's': {
                int a = this.getV();
                cell.setNv(SharedStrings.toInt(this.cb, a, this.cursor));
                cell.setT('s');
                break;
            }
            case 'b': {
                int a = this.getV();
                if (this.cursor - a == 1) {
                    cell.setBv(SharedStrings.toInt(this.cb, a, this.cursor) == 1);
                    break;
                }
                cell.setBv(false);
                break;
            }
            case 'f': {
                int a = this.getV();
                if (a > this.cursor) {
                    cell.setSv(SharedStrings.unescape(this.buf, this.cb, a, this.cursor));
                    break;
                }
                cell.setT('k');
                break;
            }
            default: {
                int a = this.getV();
                if (a < this.cursor) {
                    if (this.isNumber(a, this.cursor)) {
                        long l = this.toLong(a, this.cursor);
                        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                            cell.setNv((int)l);
                            break;
                        }
                        cell.setLv(l);
                        break;
                    }
                    if (this.isDouble(a, this.cursor)) {
                        cell.setDv(this.toDouble(a, this.cursor));
                        break;
                    }
                    cell.setSv(this.toString(a, this.cursor));
                    break;
                }
                cell.setT('e');
            }
        }
        this.cursor = this.e;
    }

    XMLCalcRow asCalcRow() {
        return !(this instanceof XMLCalcRow) ? new XMLCalcRow(this) : (XMLCalcRow)this;
    }

    XMLMergeRow asMergeRow() {
        return !(this instanceof XMLMergeRow) ? new XMLMergeRow(this) : (XMLMergeRow)this;
    }

    @FunctionalInterface
    static interface Attribute {
        public void accept(Cell var1, char[] var2, int var3, int var4);
    }
}

