/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.RowSetIterator;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLCalcSheet;
import org.ttzero.excel.reader.XMLMergeSheet;
import org.ttzero.excel.reader.XMLRow;

class XMLSheet
implements Sheet {
    Logger logger = LogManager.getLogger(this.getClass());
    String name;
    int index;
    Path path;
    SharedStrings sst;
    Styles styles;
    int startRow = -1;
    HeaderRow header;
    boolean hidden;
    Dimension dimension;
    private BufferedReader reader;
    private char[] cb;
    private int nChar;
    private int length;
    boolean eof = false;
    boolean heof = false;
    long mark;
    XMLRow sRow;

    XMLSheet() {
    }

    void setName(String name) {
        this.name = name;
    }

    void setPath(Path path) {
        this.path = path;
    }

    void setSst(SharedStrings sst) {
        this.sst = sst;
    }

    void setStyles(Styles styles) {
        this.styles = styles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    @Override
    @Deprecated
    public int getSize() {
        return this.dimension != null ? this.dimension.lastRow - this.dimension.firstRow + 1 : -1;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public int getFirstRow() {
        return this.startRow;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    XMLSheet setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public Row getHeader() {
        Row row;
        if (this.header == null && !this.heof && (row = this.findRow0(this::createHeader)) != null) {
            this.header = row.asHeader();
            this.sRow.setHr(this.header);
        }
        return this.header;
    }

    @Override
    public XMLSheet bind(Class<?> clazz) {
        if (this.getHeader() != null) {
            try {
                this.header.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelReadException(e);
            }
        }
        return this;
    }

    public String toString() {
        return "Sheet name: " + this.name + " has " + this.getDimension();
    }

    @Override
    public XMLSheet load() throws IOException {
        this.logger.debug("load {}", (Object)this.path.toString());
        this.reader = Files.newBufferedReader(this.path);
        this.cb = new char[8192];
        this.nChar = 0;
        block0: while (true) {
            this.length = this.reader.read(this.cb);
            if (this.length < 11) break;
            if (this.nChar == 0) {
                int end;
                String line = new String(this.cb, 56, 1024);
                String size = "<dimension ref=\"";
                int index = line.indexOf(size);
                int n = end = index > 0 ? line.indexOf(34, index += size.length()) : -1;
                if (end > 0) {
                    String l_ = line.substring(index, end);
                    this.logger.debug("Dimension-Range: {}", (Object)l_);
                    Pattern pat = Pattern.compile("([A-Z]+)(\\d+):([A-Z]+)(\\d+)");
                    Matcher mat = pat.matcher(l_);
                    if (mat.matches()) {
                        this.dimension = Dimension.of(l_);
                        this.startRow = this.dimension.firstRow;
                    } else {
                        pat = Pattern.compile("([A-Z]+)(\\d+)");
                        mat = pat.matcher(l_);
                        if (mat.matches()) {
                            this.startRow = Integer.parseInt(mat.group(2));
                        }
                    }
                    this.nChar += end;
                }
            }
            while (true) {
                if (this.nChar >= this.length - 12) continue block0;
                if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == 's' && this.cb[this.nChar + 2] == 'h' && this.cb[this.nChar + 3] == 'e' && this.cb[this.nChar + 4] == 'e' && this.cb[this.nChar + 5] == 't' && this.cb[this.nChar + 6] == 'D' && this.cb[this.nChar + 7] == 'a' && this.cb[this.nChar + 8] == 't' && this.cb[this.nChar + 9] == 'a' && (this.cb[this.nChar + 10] == '>' || this.cb[this.nChar + 10] == '/' && this.cb[this.nChar + 11] == '>')) {
                    this.nChar += 11;
                    break block0;
                }
                ++this.nChar;
            }
            break;
        }
        if (this.cb[this.nChar] == '>') {
            ++this.nChar;
            this.eof = true;
        } else {
            this.eof = false;
            this.sRow = new XMLRow(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1);
        }
        this.mark = this.nChar;
        if (!this.eof && this.dimension == null) {
            this.parseDimension();
        }
        return this;
    }

    private XMLRow nextRow() {
        if (this.eof) {
            return null;
        }
        boolean endTag = false;
        int start = this.nChar;
        while (++this.nChar < this.length && this.cb[this.nChar] != '>') {
        }
        if (this.cb[this.nChar++ - 1] == '/') {
            return this.sRow.empty(this.cb, start, this.nChar - start);
        }
        while (this.nChar < this.length - 6) {
            if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == '/' && this.cb[this.nChar + 2] == 'r' && this.cb[this.nChar + 3] == 'o' && this.cb[this.nChar + 4] == 'w' && this.cb[this.nChar + 5] == '>') {
                this.nChar += 6;
                endTag = true;
                break;
            }
            ++this.nChar;
        }
        if (!endTag) {
            int n;
            if (start == 0) {
                char[] _cb = new char[this.cb.length << 1];
                n = this.length - start;
                System.arraycopy(this.cb, start, _cb, 0, n);
                this.cb = _cb;
            } else {
                n = this.length - start;
                System.arraycopy(this.cb, start, this.cb, 0, n);
            }
            try {
                this.length = this.reader.read(this.cb, n, this.cb.length - n);
                if (this.length < 0) {
                    this.eof = true;
                    this.reader.close();
                    this.reader = null;
                    this.logger.debug("end of file.");
                    return null;
                }
            }
            catch (IOException e) {
                throw new ExcelReadException("Parse row data error", e);
            }
            this.nChar = 0;
            this.length += n;
            return this.nextRow();
        }
        return this.sRow.with(this.cb, start, this.nChar - start);
    }

    /*
     * Unable to fully structure code
     */
    protected Row findRow0(HeaderRowFunc func) {
        block23: {
            cb = new char[8192];
            nChar = 0;
            try {
                reader = Files.newBufferedReader(this.path);
                var6_7 = null;
                try {
                    block11: while (true) {
                        length = reader.read(cb);
                        while (true) {
                            if (nChar >= length - 12) continue block11;
                            if (cb[nChar] == '<' && cb[nChar + 1] == 's' && cb[nChar + 2] == 'h' && cb[nChar + 3] == 'e' && cb[nChar + 4] == 'e' && cb[nChar + 5] == 't' && cb[nChar + 6] == 'D' && cb[nChar + 7] == 'a' && cb[nChar + 8] == 't' && cb[nChar + 9] == 'a' && (cb[nChar + 10] == '>' || cb[nChar + 10] == '/' && cb[nChar + 11] == '>')) {
                                break block23;
                            }
                            ++nChar;
                        }
                        break;
                    }
                }
                catch (Throwable var7_11) {
                    var6_7 = var7_11;
                    throw var7_11;
                }
                finally {
                    if (reader != null) {
                        if (var6_7 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable var7_10) {
                                var6_7.addSuppressed(var7_10);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Read header row error.");
                return null;
            }
        }
        v0 = eof = cb[nChar += 11] == '>';
        if (eof) {
            this.heof = true;
            return null;
        }
        endTag = false;
        block13: while (true) {
            start = nChar;
            while (cb[++nChar] != '>' && nChar < length) {
            }
            if (nChar >= length - 6) break;
            if (cb[nChar++ - 1] == '/') continue;
            while (true) {
                if (nChar < length - 6) ** break;
                continue block13;
                if (cb[nChar] == '<' && cb[nChar + 1] == '/' && cb[nChar + 2] == 'r' && cb[nChar + 3] == 'o' && cb[nChar + 4] == 'w' && cb[nChar + 5] == '>') {
                    nChar += 6;
                    endTag = true;
                    break block13;
                }
                ++nChar;
            }
            break;
        }
        if (!endTag) {
            return null;
        }
        return func.accept(cb, start, nChar - start);
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowSetIterator(this::nextRow, false);
    }

    @Override
    public Iterator<Row> dataIterator() {
        RowSetIterator nIter = new RowSetIterator(this::nextRow, true);
        if (nIter.hasNext()) {
            Row row = (Row)nIter.next();
            if (this.header == null) {
                this.header = row.asHeader();
            }
        }
        return nIter;
    }

    @Override
    public void close() throws IOException {
        this.cb = null;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public XMLSheet reset() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = Files.newBufferedReader(this.path);
            this.reader.skip(this.mark);
            this.length = this.reader.read(this.cb);
            this.nChar = 0;
            this.eof = this.length <= 0;
        }
        catch (IOException e) {
            throw new ExcelReadException("Reset worksheet[" + this.getName() + "] error occur.", e);
        }
        return this;
    }

    void parseDimension() {
        try (SeekableByteChannel channel = Files.newByteChannel(this.path, StandardOpenOption.READ);){
            long fileSize = Files.size(this.path);
            int block = (int)Math.min(2048L, fileSize);
            ByteBuffer buffer = ByteBuffer.allocate(block);
            byte[] left = null;
            int left_size = 0;
            int i = 0;
            CharBuffer charBuffer = null;
            boolean eof = false;
            while (!eof) {
                int c;
                channel.position(fileSize - (long)block + (long)left_size);
                channel.read(buffer);
                fileSize -= (long)buffer.limit();
                boolean bl = eof = buffer.limit() < block;
                if (left_size > 0) {
                    buffer.limit(block);
                    buffer.put(left, 0, left_size);
                    left_size = 0;
                }
                buffer.flip();
                charBuffer = StandardCharsets.UTF_8.decode(buffer);
                int limit = charBuffer.limit();
                if (this.dimension == null) {
                    c = 7;
                    for (i = limit - 1; i >= c && (charBuffer.get(i) != '\"' || charBuffer.get(i - 1) != '=' || charBuffer.get(i - 2) != 'r' || charBuffer.get(i - 3) > ' ' || charBuffer.get(i - 4) != 'w' || charBuffer.get(i - 5) != 'o' || charBuffer.get(i - 6) != 'r' || charBuffer.get(i - 7) != '<'); --i) {
                    }
                } else {
                    c = 12;
                    while (i >= c && (charBuffer.get(i) > ' ' || charBuffer.get(i - 1) != 's' || charBuffer.get(i - 2) != 'l' || charBuffer.get(i - 3) != 'l' || charBuffer.get(i - 4) != 'e' || charBuffer.get(i - 5) != 'C' || charBuffer.get(i - 6) != 'e' || charBuffer.get(i - 7) != 'g' || charBuffer.get(i - 8) != 'r' || charBuffer.get(i - 9) != 'e' || charBuffer.get(i - 10) != 'm' || charBuffer.get(i - 11) != '<')) {
                        --i;
                    }
                }
                if (i >= c) break;
                while (i < limit && charBuffer.get(i) != '>') {
                    ++i;
                }
                if (++i < limit - 1) {
                    charBuffer.position(i);
                    int newLimit = StandardCharsets.UTF_8.encode(charBuffer).limit();
                    int last_size = buffer.limit() - newLimit;
                    if (left == null || last_size > left.length) {
                        left = new byte[last_size];
                    }
                    buffer.position(0);
                    buffer.get(left, 0, last_size);
                    left_size = last_size;
                }
                buffer.position(0);
                buffer.limit(buffer.capacity() - left_size);
            }
            if (eof) {
                return;
            }
            charBuffer.position(i);
            if (this.dimension == null) {
                this.parseDim(channel, charBuffer, buffer);
                charBuffer.position(i);
            }
            this.parseMerge(channel, charBuffer, buffer, block);
        }
        catch (IOException e) {
            this.logger.debug("", (Throwable)e);
        }
    }

    private int[] innerParse(CharBuffer charBuffer, int i) {
        int row = 0;
        while (charBuffer.get(i) != '\"') {
            row = row * 10 + (charBuffer.get(i) - 48);
            ++i;
        }
        ++i;
        while (charBuffer.get(i) != 's' || charBuffer.get(i + 1) != 'p' || charBuffer.get(i + 2) != 'a' || charBuffer.get(i + 3) != 'n' || charBuffer.get(i + 4) != 's' || charBuffer.get(i + 5) != '=' || charBuffer.get(i + 6) != '\"') {
            ++i;
        }
        i += 7;
        int cs = 0;
        int ls = 0;
        while (charBuffer.get(i) != ':') {
            cs = cs * 10 + (charBuffer.get(i) - 48);
            ++i;
        }
        ++i;
        while (charBuffer.get(i) != '\"') {
            ls = ls * 10 + (charBuffer.get(i) - 48);
            ++i;
        }
        return new int[]{row, cs, ls};
    }

    private void parseDim(SeekableByteChannel channel, CharBuffer charBuffer, ByteBuffer buffer) throws IOException {
        long rr = 0L;
        int i = charBuffer.position();
        int[] info = this.innerParse(charBuffer, ++i);
        int rc = info[2] << 16 | info[1] & Short.MAX_VALUE;
        rr |= (long)info[0] << 32;
        if (this.mark > 0L) {
            channel.position(this.mark);
            buffer.clear();
            channel.read(buffer);
            buffer.flip();
            charBuffer = StandardCharsets.UTF_8.decode(buffer);
            i = 0;
            while (charBuffer.get(i) != '<' || charBuffer.get(i + 1) != 'r' || charBuffer.get(i + 2) != 'o' || charBuffer.get(i + 3) != 'w' || charBuffer.get(i + 4) > ' ' || charBuffer.get(i + 5) != 'r' || charBuffer.get(i + 6) != '=' || charBuffer.get(i + 7) != '\"') {
                ++i;
            }
            info = this.innerParse(charBuffer, i += 8);
            rr |= (long)info[0];
            if (info[1] > (rc & Short.MAX_VALUE)) {
                rc |= info[1] & Short.MAX_VALUE;
            }
            if (info[2] < rc >>> 16) {
                rc |= info[2] << 16;
            }
        } else {
            rr |= 1L;
        }
        this.dimension = new Dimension((int)rr, (short)rc, (int)(rr >>> 32), (short)(rc >>> 16));
    }

    void parseMerge(SeekableByteChannel channel, CharBuffer charBuffer, ByteBuffer buffer, int block) throws IOException {
    }

    Row createHeader(char[] cb, int start, int n) {
        return new XMLRow(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1).with(cb, start, n);
    }

    @Override
    public XMLCalcSheet asCalcSheet() {
        return !(this instanceof XMLCalcSheet) ? new XMLCalcSheet(this) : (XMLCalcSheet)this;
    }

    @Override
    public XMLMergeSheet asMergeSheet() {
        return !(this instanceof XMLMergeSheet) ? new XMLMergeSheet(this) : (XMLMergeSheet)this;
    }

    static interface HeaderRowFunc {
        public Row accept(char[] var1, int var2, int var3);
    }
}

