/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;

public class I18N {
    private final Properties pro;

    public I18N() {
        block15: {
            Locale locale = Locale.getDefault();
            String fn = "message._.properties";
            this.pro = new Properties();
            try {
                InputStream is = I18N.class.getClassLoader().getResourceAsStream("I18N/" + fn.replace("_", locale.toLanguageTag()));
                if (is == null) {
                    is = I18N.class.getClassLoader().getResourceAsStream("I18N/" + fn.replace("_", "zh-CN"));
                }
                if (is == null) break block15;
                try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    this.pro.load(reader);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String get(String code) {
        return this.pro.getProperty(code, code);
    }

    public String getOrElse(String code, String other) {
        return this.pro.getProperty(code, other);
    }

    public String get(String code, String ... args) {
        String msg = this.pro.getProperty(code, code);
        char[] oldValue = msg.toCharArray();
        int[] indexs = I18N.search(oldValue);
        int len = Math.min(indexs.length, args.length);
        int size = 0;
        int i = 0;
        while (i < len) {
            size += args[i++].length();
        }
        StringBuilder buf = new StringBuilder(oldValue.length + size - (len << 1));
        buf.append(oldValue, 0, indexs[0]).append(args[0]);
        for (int i2 = 1; i2 < len; ++i2) {
            size = indexs[i2 - 1] + 2;
            buf.append(oldValue, size, indexs[i2] - size).append(args[i2]);
        }
        if (indexs[len - 1] + 2 < oldValue.length) {
            size = indexs[len - 1] + 2;
            buf.append(oldValue, size, oldValue.length - size);
        }
        return buf.toString();
    }

    private static int[] search(char[] value) {
        int[] indexs = new int[16];
        int n = 0;
        for (int i = 0; i < value.length - 1; ++i) {
            if (value[i] != '{' || value[i + 1] != '}') continue;
            indexs[n++] = i++;
            if (n != indexs.length) continue;
            int[] _indexs = new int[indexs.length << 1];
            System.arraycopy(indexs, 0, _indexs, 0, indexs.length);
            indexs = _indexs;
        }
        return Arrays.copyOfRange(indexs, 0, n);
    }
}

