/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ttzero.excel.reader.CalcSheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.util.CSVUtil;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public interface Sheet
extends Closeable {
    public String getName();

    public int getIndex();

    @Deprecated
    public int getSize();

    public Dimension getDimension();

    public boolean isHidden();

    default public boolean isShow() {
        return !this.isHidden();
    }

    public Row getHeader();

    public Sheet bind(Class<?> var1);

    public Sheet load() throws IOException;

    public Iterator<Row> iterator();

    public Iterator<Row> dataIterator();

    default public Sheet reset() {
        throw new UnsupportedOperationException();
    }

    default public Stream<Row> rows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 272), false);
    }

    default public Stream<Row> dataRows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.dataIterator(), 272), false);
    }

    public static int col2Int(String col) {
        if (StringUtil.isEmpty(col)) {
            return 1;
        }
        char[] values = col.toCharArray();
        int n = 0;
        for (char value : values) {
            if (value < 'A' || value > 'Z') {
                throw new ExcelReadException("Column mark out of range: " + col);
            }
            n = n * 26 + value - 65 + 1;
        }
        return n;
    }

    @Override
    public void close() throws IOException;

    default public void saveAsCSV(Path path) throws IOException {
        if (!FileUtil.exists(path)) {
            FileUtil.mkdir(path);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve(this.getName() + ".csv");
        }
        this.saveAsCSV(Files.newOutputStream(path, new OpenOption[0]));
    }

    default public void saveAsCSV(OutputStream os) throws IOException {
        try (CSVUtil.Writer writer = CSVUtil.newWriter(os);){
            Iterator<Row> iter = this.iterator();
            while (iter.hasNext()) {
                Row row = iter.next();
                if (row.isEmpty()) continue;
                block18: for (int i = row.fc; i < row.lc; ++i) {
                    Cell c = row.cells[i];
                    switch (c.t) {
                        case 's': {
                            if (c.sv == null) {
                                c.setSv(row.sst.get(c.nv));
                            }
                            writer.write(c.sv);
                            continue block18;
                        }
                        case 'f': 
                        case 'r': {
                            writer.write(c.sv);
                            continue block18;
                        }
                        case 'b': {
                            writer.write(c.bv);
                            continue block18;
                        }
                        case 'n': {
                            if (!row.styles.fastTestDateFmt(c.xf)) {
                                writer.write(c.nv);
                                continue block18;
                            }
                            writer.write(DateUtil.toLocalDate(c.nv).toString());
                            continue block18;
                        }
                        case 'l': {
                            writer.write(c.lv);
                            continue block18;
                        }
                        case 'd': {
                            if (!row.styles.fastTestDateFmt(c.xf)) {
                                writer.write(c.dv);
                                continue block18;
                            }
                            writer.write(DateUtil.toTimestamp(c.dv).toString());
                            continue block18;
                        }
                        default: {
                            writer.writeEmpty();
                        }
                    }
                }
                writer.newLine();
            }
        }
    }

    public CalcSheet asCalcSheet();

    public MergeSheet asMergeSheet();
}

