/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;

public class ReflectUtil {
    private ReflectUtil() {
    }

    public static Field[] listDeclaredFields(Class<?> beanClass) {
        return ReflectUtil.listDeclaredFields(beanClass, Object.class);
    }

    public static Field[] listDeclaredFields(Class<?> beanClass, Class<?> stopClass) {
        Field[] fields = beanClass.getDeclaredFields();
        int i = fields.length;
        int last = 0;
        while ((beanClass = beanClass.getSuperclass()) != stopClass) {
            Field[] subFields = beanClass.getDeclaredFields();
            if (subFields.length <= 0) continue;
            if (subFields.length > last) {
                Field[] tmp = new Field[fields.length + subFields.length];
                System.arraycopy(fields, 0, tmp, 0, i);
                fields = tmp;
                last = tmp.length - i;
            }
            System.arraycopy(subFields, 0, fields, i, subFields.length);
            i += subFields.length;
            last -= subFields.length;
        }
        return fields;
    }

    public static Field[] listDeclaredFields(Class<?> beanClass, Predicate<Field> filter) {
        return ReflectUtil.listDeclaredFields(beanClass, Object.class, filter);
    }

    public static Field[] listDeclaredFields(Class<?> beanClass, Class<?> stopClass, Predicate<Field> filter) {
        Field[] fields = ReflectUtil.listDeclaredFields(beanClass, stopClass);
        return filter != null ? ReflectUtil.fieldFilter(fields, filter) : fields;
    }

    public static Method[] listDeclaredMethods(Class<?> beanClass) throws IntrospectionException {
        return ReflectUtil.listDeclaredMethods(beanClass, Object.class);
    }

    public static Method[] listDeclaredMethods(Class<?> beanClass, Predicate<Method> filter) throws IntrospectionException {
        Method[] methods = ReflectUtil.listDeclaredMethods(beanClass);
        return filter != null ? ReflectUtil.methodFilter(methods, filter) : methods;
    }

    public static Method[] listDeclaredMethods(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        Method[] methods;
        MethodDescriptor[] methodDescriptors = Introspector.getBeanInfo(beanClass, stopClass).getMethodDescriptors();
        Method[] allMethods = beanClass.getMethods();
        if (methodDescriptors.length > 0) {
            methods = new Method[methodDescriptors.length];
            for (int i = 0; i < methodDescriptors.length; ++i) {
                int index = ReflectUtil.indexOf(allMethods, methodDescriptors[i].getMethod());
                methods[i] = index >= 0 ? allMethods[index] : methodDescriptors[i].getMethod();
            }
        } else {
            methods = new Method[]{};
        }
        return methods;
    }

    public static Method[] listDeclaredMethods(Class<?> beanClass, Class<?> stopClass, Predicate<Method> filter) throws IntrospectionException {
        Method[] methods = ReflectUtil.listDeclaredMethods(beanClass, stopClass);
        return filter != null ? ReflectUtil.methodFilter(methods, filter) : methods;
    }

    public static Method[] listReadMethods(Class<?> beanClass) throws IntrospectionException {
        return ReflectUtil.listReadMethods(beanClass, Object.class);
    }

    public static Method[] listReadMethods(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        Method[] methods = ReflectUtil.listDeclaredMethods(beanClass, stopClass);
        int n = 0;
        for (int i = 0; i < methods.length; ++i) {
            Class<?> returnType;
            Method method = methods[i];
            if (method.getParameterCount() != 0 || (returnType = method.getReturnType()) == Void.TYPE || returnType == Void.class) continue;
            methods[n++] = method;
        }
        return n < methods.length ? Arrays.copyOf(methods, n) : methods;
    }

    public static Method[] listReadMethods(Class<?> beanClass, Predicate<Method> filter) throws IntrospectionException {
        Method[] methods = ReflectUtil.listReadMethods(beanClass);
        return filter != null ? ReflectUtil.methodFilter(methods, filter) : methods;
    }

    public static Method[] listReadMethods(Class<?> beanClass, Class<?> stopClass, Predicate<Method> filter) throws IntrospectionException {
        Method[] methods = ReflectUtil.listReadMethods(beanClass, stopClass);
        return filter != null ? ReflectUtil.methodFilter(methods, filter) : methods;
    }

    public static Method[] listWriteMethods(Class<?> beanClass) throws IntrospectionException {
        return ReflectUtil.listWriteMethods(beanClass, Object.class);
    }

    public static Method[] listWriteMethods(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        Method[] methods = ReflectUtil.listDeclaredMethods(beanClass, stopClass);
        Field[] fields = ReflectUtil.listDeclaredFields(beanClass, stopClass);
        HashSet<String> tmp = new HashSet<String>();
        for (Field field : fields) {
            tmp.add("set" + field.getName().toLowerCase());
        }
        int n = 0;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> returnType = method.getReturnType();
            if (method.getParameterCount() != 1 || returnType != Void.TYPE && returnType != Void.class || !tmp.contains(method.getName().toLowerCase())) continue;
            methods[n++] = method;
        }
        return n < methods.length ? Arrays.copyOf(methods, n) : methods;
    }

    public static Method[] listWriteMethods(Class<?> beanClass, Predicate<Method> filter) throws IntrospectionException {
        Method[] methods = ReflectUtil.listWriteMethods(beanClass);
        return filter != null ? ReflectUtil.methodFilter(methods, filter) : methods;
    }

    public static Method[] listWriteMethods(Class<?> beanClass, Class<?> stopClass, Predicate<Method> filter) throws IntrospectionException {
        Method[] methods = ReflectUtil.listWriteMethods(beanClass, stopClass);
        return filter != null ? ReflectUtil.methodFilter(methods, filter) : methods;
    }

    public static int indexOf(Method[] methods, Method source) {
        int i = 0;
        for (Method method : methods) {
            if (method == null) {
                ++i;
                continue;
            }
            if (method.equals(source)) {
                return i;
            }
            if (method.getName().equals(source.getName()) && method.getReturnType() == source.getReturnType() && ReflectUtil.parameterDeepEquals(method.getParameters(), source.getParameters())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int mapping(Method[] writeMethods, Map<String, Method> tmp, PropertyDescriptor[] propertyDescriptors, Method[] mergedMethods) {
        if (writeMethods == null) {
            for (int i = 1; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                tmp.put(pd.getName(), mergedMethods[i]);
            }
        } else {
            int i;
            int j;
            for (j = 0; j < mergedMethods.length; ++j) {
                int n = i = mergedMethods[j] != null ? ReflectUtil.indexOf(writeMethods, mergedMethods[j]) : -1;
                if (i >= 0) {
                    writeMethods[i] = null;
                }
                tmp.put(propertyDescriptors[j].getName(), mergedMethods[j]);
            }
            i = 0;
            for (j = 0; j < writeMethods.length; ++j) {
                if (writeMethods[j] == null) continue;
                writeMethods[i++] = writeMethods[j];
            }
            return i;
        }
        return 0;
    }

    private static Method[] methodFilter(Method[] methods, Predicate<Method> filter) {
        int n = 0;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!filter.test(method)) continue;
            if (i != n) {
                methods[n] = method;
            }
            ++n;
        }
        return n < methods.length ? Arrays.copyOf(methods, n) : methods;
    }

    private static Field[] fieldFilter(Field[] fields, Predicate<Field> filter) {
        int n = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            if (!filter.test(field)) continue;
            if (i != n) {
                fields[n] = field;
            }
            ++n;
        }
        return n < fields.length ? Arrays.copyOf(fields, n) : fields;
    }

    private static boolean parameterDeepEquals(Parameter[] aClass, Parameter[] bClass) {
        boolean equals;
        boolean bl = equals = aClass.length == bClass.length;
        if (equals) {
            for (int i = 0; i < aClass.length && (equals = aClass[i].equals(bClass[i]) || aClass[i].getType() == bClass[i].getType()); ++i) {
            }
        }
        return equals;
    }
}

