/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;

public interface ICellValueAndStyle {
    public void reset(int var1, Cell var2, Object var3, Sheet.Column var4);

    public String getFileSuffix();

    public int getStyleIndex(int var1, Sheet.Column var2, Object var3);

    default public void setCellValue(int row, Cell cell, Object e, Sheet.Column hc, Class<?> clazz) {
        boolean hasIntProcessor;
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        boolean bl = hasIntProcessor = hc.processor != null;
        if (IWorksheetWriter.isString(clazz)) {
            cell.setSv(e.toString());
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            char c = ((Character)e).charValue();
            if (hasIntProcessor) {
                this.conversion(row, cell, c, hc);
            } else {
                cell.setCv(c);
            }
        } else if (IWorksheetWriter.isShort(clazz)) {
            short t = (Short)e;
            if (hasIntProcessor) {
                this.conversion(row, cell, t, hc);
            } else {
                cell.setNv(t);
            }
        } else if (IWorksheetWriter.isInt(clazz)) {
            int n = (Integer)e;
            if (hasIntProcessor) {
                this.conversion(row, cell, n, hc);
            } else {
                cell.setNv(n);
            }
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLv((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDv(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDv((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBv((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setMv((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setIv(DateUtil.toDateValue((LocalDate)e));
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setTv(DateUtil.toTimeValue((Time)e));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setTv(DateUtil.toTimeValue((LocalTime)e));
        } else {
            cell.setSv(e.toString());
        }
    }

    default public void setNullValue(int row, Cell cell, Sheet.Column hc) {
        boolean hasIntProcessor;
        boolean bl = hasIntProcessor = hc.processor != null;
        if (hasIntProcessor) {
            this.conversion(row, cell, 0, hc);
        } else {
            cell.blank();
        }
    }

    default public void conversion(int row, Cell cell, int n, Sheet.Column hc) {
        Object e = hc.processor.conversion(n);
        if (e != null) {
            Class<?> clazz = e.getClass();
            if (IWorksheetWriter.isInt(clazz)) {
                if (IWorksheetWriter.isChar(clazz)) {
                    cell.setCv(((Character)e).charValue());
                } else if (IWorksheetWriter.isShort(clazz)) {
                    cell.setNv(((Short)e).shortValue());
                } else {
                    cell.setNv((Integer)e);
                }
            } else {
                this.setCellValue(row, cell, e, hc, clazz);
            }
        } else {
            cell.blank();
        }
    }
}

