/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.csv;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;

public class CSVCellValueAndStyle
implements ICellValueAndStyle {
    @Override
    public void reset(int row, Cell cell, Object e, Sheet.Column hc) {
        this.setCellValue(row, cell, e, hc, hc.getClazz());
    }

    @Override
    public String getFileSuffix() {
        return ".csv";
    }

    @Override
    public void setCellValue(int row, Cell cell, Object e, Sheet.Column hc, Class<?> clazz) {
        boolean hasIntProcessor;
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        boolean bl = hasIntProcessor = hc.processor != null;
        if (IWorksheetWriter.isString(clazz)) {
            cell.setSv(e.toString());
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setSv(DateUtil.toDateString((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setSv(DateUtil.toString((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            char c = ((Character)e).charValue();
            if (hasIntProcessor) {
                this.conversion(row, cell, c, hc);
            } else {
                cell.setCv(c);
            }
        } else if (IWorksheetWriter.isShort(clazz)) {
            short t = (Short)e;
            if (hasIntProcessor) {
                this.conversion(row, cell, t, hc);
            } else {
                cell.setNv(t);
            }
        } else if (IWorksheetWriter.isInt(clazz)) {
            int n = (Integer)e;
            if (hasIntProcessor) {
                this.conversion(row, cell, n, hc);
            } else {
                cell.setNv(n);
            }
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLv((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDv(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDv((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBv((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setMv((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setSv(((LocalDate)e).toString());
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setSv(DateUtil.LOCAL_DATE_TIME.format((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setSv(DateTimeFormatter.ISO_TIME.format(((Time)e).toLocalTime()));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setSv(DateTimeFormatter.ISO_TIME.format((LocalTime)e));
        } else {
            cell.setSv(e.toString());
        }
    }

    @Override
    public int getStyleIndex(int rows, Sheet.Column hc, Object o) {
        return 0;
    }
}

