/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.dom4j.Element;
import org.ttzero.excel.util.StringUtil;

public class NumFmt
implements Comparable<NumFmt> {
    private String code;
    private int id = -1;

    private NumFmt() {
    }

    NumFmt(int id, String code) {
        this.id = id;
        this.code = code;
    }

    public NumFmt(String code) {
        this.code = NumFmt.clean(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    NumFmt setId(int id) {
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public static NumFmt valueOf(int id) {
        return new NumFmt().setId(id);
    }

    public static NumFmt of(String code) {
        return new NumFmt(code);
    }

    private static String clean(String code) {
        if (StringUtil.isEmpty(code)) {
            throw new NumberFormatException("The format code must not be null or empty.");
        }
        code = NumFmt.escape(code, '-');
        code = NumFmt.escape(code, ' ');
        return code;
    }

    private static String escape(String code, char c) {
        int i = code.indexOf(c);
        if (i > -1) {
            int j = 0;
            StringBuilder buf = new StringBuilder();
            do {
                if (i != j) {
                    buf.append(code, j, i);
                    j = i;
                }
                if (i != 0 && code.charAt(i - 1) == '\\') continue;
                buf.append('\\');
            } while ((i = code.indexOf(c, i + 1)) > -1);
            code = buf.append(code, j, code.length()).toString();
        }
        return code;
    }

    public int calcNumWidth(int base) {
        int n = 0;
        boolean ignore = false;
        boolean comma = false;
        char[] cs = new char[1];
        for (int i = 0; i < this.code.length(); ++i) {
            char c = this.code.charAt(i);
            if (c == '\"' || c == '\\') continue;
            if (ignore) {
                if (c != ']' && c != ')') continue;
                ignore = false;
                continue;
            }
            if (c == '[' || c == '(') {
                ignore = true;
                continue;
            }
            if (c == ',') {
                comma = true;
            }
            cs[0] = c;
            n += (new String(cs).getBytes(StandardCharsets.UTF_8).length >> 1) + 1;
        }
        return comma ? base + base / 3 + n - 5 : n;
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o instanceof NumFmt) {
            NumFmt other = (NumFmt)o;
            return Objects.equals(other.code, this.code);
        }
        return false;
    }

    public String toString() {
        return "id: " + this.id + ", code: " + this.code;
    }

    public Element toDom4j(Element root) {
        if (StringUtil.isEmpty(this.code)) {
            return root;
        }
        return root.addElement(StringUtil.lowFirstKey(this.getClass().getSimpleName())).addAttribute("formatCode", this.code).addAttribute("numFmtId", String.valueOf(this.id));
    }

    @Override
    public int compareTo(NumFmt o) {
        return this.id - o.id;
    }
}

