/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.HeaderComment;
import org.ttzero.excel.annotation.HeaderStyle;
import org.ttzero.excel.annotation.IgnoreExport;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.processor.IntConversionProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

public class ListSheet<T>
extends Sheet {
    protected List<T> data;
    protected int start;
    protected int end;
    protected boolean eof;
    private int size;

    public ListSheet() {
    }

    public ListSheet(String name) {
        super(name);
    }

    public ListSheet(String name, Sheet.Column ... columns) {
        super(name, columns);
    }

    public ListSheet(String name, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListSheet(List<T> data) {
        this(null, data);
    }

    public ListSheet(String name, List<T> data) {
        super(name);
        this.setData(data);
    }

    public ListSheet(List<T> data, Sheet.Column ... columns) {
        this(null, data, columns);
    }

    public ListSheet(String name, List<T> data, Sheet.Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListSheet(List<T> data, WaterMark waterMark, Sheet.Column ... columns) {
        this(null, data, waterMark, columns);
    }

    public ListSheet(String name, List<T> data, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    public ListSheet<T> setData(List<T> data) {
        this.data = data;
        if (!this.headerReady && this.workbook != null) {
            this.getHeaderColumns();
        }
        if (data != null && this.sheetWriter != null) {
            this.paging();
        }
        return this;
    }

    protected T getFirst() {
        if (this.data == null || this.data.isEmpty()) {
            return null;
        }
        T first = this.data.get(this.start);
        if (first != null) {
            return first;
        }
        int i = this.start + 1;
        while ((first = this.data.get(i++)) == null) {
        }
        return first;
    }

    @Override
    public void close() throws IOException {
        List<T> list;
        if (!this.eof && this.rows >= this.sheetWriter.getRowLimit() - 1 && (list = this.more()) != null && !list.isEmpty()) {
            this.compact();
            this.data.addAll(list);
            ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
            copy.start = 0;
            copy.end = list.size();
            this.workbook.insertSheet(this.id, copy);
            this.shouldClose = false;
        }
        if (this.shouldClose && this.data != null) {
            this.data = null;
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.left() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        try {
            while (this.start < end) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                Cell[] cells = row.realloc(len);
                T o = this.data.get(this.start);
                for (int i = 0; i < len; ++i) {
                    Cell cell = cells[i];
                    cell.clear();
                    EntryColumn column = (EntryColumn)this.columns[i];
                    Object e = column.isIgnoreValue() ? null : (column.getMethod() != null ? column.getMethod().invoke(o, new Object[0]) : column.getField().get(o));
                    this.cellValueAndStyle.reset(this.rows, cell, e, this.columns[i]);
                }
                ++this.rows;
                ++this.start;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExcelWriteException(e);
        }
    }

    protected void append() {
        block4: {
            int rbs = this.getRowBlockSize();
            while (true) {
                List<T> list;
                if ((list = this.more()) == null || list.isEmpty()) {
                    this.shouldClose = true;
                    this.eof = true;
                    break block4;
                }
                if (this.data == null) {
                    this.setData(list);
                    if (list.size() < rbs) {
                        continue;
                    }
                    break block4;
                }
                this.compact();
                this.data.addAll(list);
                this.start = 0;
                this.end = this.data.size();
                if (this.end >= rbs) break;
            }
            this.paging();
        }
    }

    private void compact() {
        int size = this.left();
        if (this.start > 0 && size > 0) {
            ArrayList<T> last = new ArrayList<T>(size);
            last.addAll(this.data.subList(this.start, this.end));
            this.data.clear();
            this.data.addAll(last);
        } else if (this.start > 0) {
            this.data.clear();
        }
    }

    protected Class<?> getTClass() {
        Class clazz;
        if (this.getClass().getGenericSuperclass() instanceof ParameterizedType) {
            Class tClass;
            clazz = tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        } else {
            T o = this.getFirst();
            if (o == null) {
                return null;
            }
            clazz = o.getClass();
        }
        return clazz;
    }

    protected int init() {
        boolean forceExport;
        Method method;
        Class<?> clazz = this.getTClass();
        if (clazz == null) {
            return 0;
        }
        HashMap<String, Method> tmp = new HashMap<String, Method>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                method = pd.getReadMethod();
                if (method == null) continue;
                tmp.put(pd.getName(), method);
            }
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get class {} methods failed.", clazz);
        }
        Field[] declaredFields = ReflectUtil.listDeclaredFields(clazz, c -> !this.ignoreColumn((AccessibleObject)c));
        boolean bl = forceExport = this.forceExport == 1;
        if (!this.hasHeaderColumns()) {
            ArrayList<Sheet.Column> list = new ArrayList<Sheet.Column>(declaredFields.length);
            for (int i = 0; i < declaredFields.length; ++i) {
                EntryColumn column;
                Field field = declaredFields[i];
                field.setAccessible(true);
                String gs = field.getName();
                Method method2 = (Method)tmp.get(gs);
                if (method2 != null) {
                    if (this.ignoreColumn(method2)) {
                        declaredFields[i] = null;
                        continue;
                    }
                    column = this.createColumn(method2);
                    if (column == null && forceExport) {
                        column = new EntryColumn(gs, "", false);
                    }
                    if (column != null) {
                        column.method = method2;
                        column.field = field;
                        column.clazz = method2.getReturnType();
                        column.key = gs;
                        column.styles = this.workbook.getStyles();
                        if (StringUtil.isEmpty(column.name)) {
                            column.name = gs;
                        }
                        list.add(column);
                        this.buildHeaderStyle(method2, field, column);
                        this.buildHeaderComment(method2, field, column);
                        continue;
                    }
                }
                if ((column = this.createColumn(field)) == null && forceExport) {
                    column = new EntryColumn(gs, "", false);
                }
                if (column == null) continue;
                list.add(column);
                column.field = field;
                column.key = gs;
                column.styles = this.workbook.getStyles();
                if (StringUtil.isEmpty(column.name)) {
                    column.name = gs;
                }
                if (method2 != null) {
                    column.clazz = method2.getReturnType();
                    column.method = method2;
                } else {
                    column.clazz = field.getType();
                }
                this.buildHeaderStyle(method2, field, column);
                this.buildHeaderComment(method2, field, column);
            }
            List<Sheet.Column> attachList = this.attachOtherColumn(tmp, clazz);
            if (attachList != null) {
                list.addAll(attachList);
            }
            if (list.isEmpty()) {
                this.shouldClose = true;
                this.eof = true;
                this.headerReady = true;
                this.end = 0;
                this.LOGGER.warn("Class [{}] do not contains properties to export.", clazz);
                return 0;
            }
            this.columns = new Sheet.Column[list.size()];
            list.toArray(this.columns);
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                Sheet.Column hc = this.columns[i];
                if (!(hc instanceof EntryColumn)) {
                    this.columns[i] = hc = new EntryColumn(hc);
                }
                EntryColumn ec = (EntryColumn)hc;
                method = (Method)tmp.get(hc.key);
                if (method != null) {
                    method.setAccessible(true);
                }
                ec.method = method;
                for (Field field : declaredFields) {
                    if (!hc.key.equals(field.getName())) continue;
                    field.setAccessible(true);
                    ec.field = field;
                    break;
                }
                if (method == null && ec.field == null) {
                    this.LOGGER.warn("Column [" + hc.getName() + "(" + hc.key + ")] not declare in class " + clazz);
                    hc.ignoreValue();
                } else if (hc.getClazz() == null) {
                    hc.setClazz(ec.method != null ? ec.method.getReturnType() : ec.field.getType());
                }
                if (hc.getHeaderStyleIndex() == -1) {
                    this.buildHeaderStyle(method, ec.field, hc);
                }
                if (hc.headerComment != null) continue;
                this.buildHeaderComment(method, ec.field, hc);
            }
        }
        HeaderStyle headerStyle = clazz.getDeclaredAnnotation(HeaderStyle.class);
        int style = 0;
        if (headerStyle != null) {
            style = this.buildHeadStyle(headerStyle.fontColor(), headerStyle.fillFgColor());
        }
        for (Sheet.Column column : this.columns) {
            if (style <= 0 || column.getHeaderStyleIndex() != -1) continue;
            column.setHeaderStyle(style);
        }
        return this.columns.length;
    }

    protected EntryColumn createColumn(AccessibleObject ao) {
        if (this.ignoreColumn(ao)) {
            return null;
        }
        ao.setAccessible(true);
        ExcelColumn ec = ao.getAnnotation(ExcelColumn.class);
        if (ec != null) {
            EntryColumn column = new EntryColumn(ec.value(), "", ec.share());
            if (StringUtil.isNotEmpty(ec.format())) {
                column.setNumFmt(ec.format());
            }
            column.setWrapText(ec.wrapText());
            if (ec.colIndex() > -1) {
                column.colIndex = ec.colIndex();
            }
            return column;
        }
        return null;
    }

    protected void buildHeaderStyle(AccessibleObject main, AccessibleObject sub, Sheet.Column column) {
        HeaderStyle hs = null;
        if (main != null) {
            hs = main.getAnnotation(HeaderStyle.class);
        }
        if (hs == null && sub != null) {
            hs = sub.getAnnotation(HeaderStyle.class);
        }
        if (hs != null) {
            column.setHeaderStyle(this.buildHeadStyle(hs.fontColor(), hs.fillFgColor()));
        }
    }

    protected void buildHeaderComment(AccessibleObject main, AccessibleObject sub, Sheet.Column column) {
        ExcelColumn ec;
        HeaderComment comment = null;
        if (main != null && (comment = main.getAnnotation(HeaderComment.class)) == null && (ec = main.getAnnotation(ExcelColumn.class)) != null) {
            comment = ec.comment();
        }
        if (comment == null && sub != null && (comment = sub.getAnnotation(HeaderComment.class)) == null && (ec = sub.getAnnotation(ExcelColumn.class)) != null) {
            comment = ec.comment();
        }
        if (comment != null && (StringUtil.isNotEmpty(comment.value()) || StringUtil.isNotEmpty(comment.title()))) {
            column.headerComment = new Comment(comment.title(), comment.value());
        }
    }

    protected boolean ignoreColumn(AccessibleObject ao) {
        return ao.getAnnotation(IgnoreExport.class) != null;
    }

    protected List<Sheet.Column> attachOtherColumn(Map<String, Method> existsMethodMapper, Class<?> clazz) {
        Method[] readMethods = null;
        try {
            Collection<Method> values = existsMethodMapper.values();
            readMethods = ReflectUtil.listReadMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null && method.getAnnotation(IgnoreExport.class) == null && !values.contains(method));
        }
        catch (IntrospectionException values) {
            // empty catch block
        }
        if (readMethods != null) {
            HashSet<Method> existsMethods = new HashSet<Method>(existsMethodMapper.values());
            ArrayList<Sheet.Column> list = new ArrayList<Sheet.Column>();
            for (Method method2 : readMethods) {
                EntryColumn column;
                if (existsMethods.contains(method2) || (column = this.createColumn(method2)) == null) continue;
                list.add(column);
                column.method = method2;
                column.clazz = method2.getReturnType();
                column.key = method2.getName();
                column.styles = this.workbook.getStyles();
                if (StringUtil.isEmpty(column.name)) {
                    column.name = method2.getName();
                }
                this.buildHeaderStyle(method2, null, column);
                this.buildHeaderComment(method2, null, column);
            }
            return list;
        }
        return null;
    }

    @Override
    public Sheet.Column[] getHeaderColumns() {
        if (!this.headerReady) {
            int size = this.init();
            if (size <= 0) {
                this.columns = new Sheet.Column[0];
            } else {
                this.headerReady = true;
            }
        }
        return this.columns;
    }

    protected int getEndIndex() {
        int rowLimit;
        int blockSize = this.getRowBlockSize();
        if (this.rows + blockSize > (rowLimit = this.sheetWriter.getRowLimit() - 1)) {
            blockSize = rowLimit - this.rows;
        }
        int end = this.start + blockSize;
        return Math.min(end, this.end);
    }

    @Override
    public int size() {
        return !this.shouldClose ? this.size : -1;
    }

    protected int left() {
        return this.end - this.start;
    }

    @Override
    protected void paging() {
        int limit;
        int len = this.dataSize();
        if (len + this.rows > (limit = this.sheetWriter.getRowLimit() - 1)) {
            this.end = limit - this.rows + this.start;
            this.shouldClose = false;
            this.eof = true;
            this.size = limit;
            int n = this.id;
            int i = this.end;
            while (i < len) {
                ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
                copy.start = i;
                copy.end = i = Math.min(i + limit, len);
                copy.size = copy.end - copy.start;
                copy.eof = copy.size == limit;
                this.workbook.insertSheet(n++, copy);
            }
            this.workbook.getSheetAt((int)(n - 1)).shouldClose = true;
        } else {
            this.end = len;
            this.size += len;
        }
    }

    public int dataSize() {
        return this.data != null ? this.data.size() : 0;
    }

    protected List<T> more() {
        return null;
    }

    static class EntryColumn
    extends Sheet.Column {
        Method method;
        Field field;

        public EntryColumn() {
        }

        public EntryColumn(String name, Class<?> clazz) {
            super(name, clazz);
        }

        public EntryColumn(String name, String key) {
            super(name, key);
        }

        public EntryColumn(String name, String key, Class<?> clazz) {
            super(name, key, clazz);
        }

        public EntryColumn(String name, Class<?> clazz, IntConversionProcessor processor) {
            super(name, clazz, processor);
        }

        public EntryColumn(String name, String key, IntConversionProcessor processor) {
            super(name, key, processor);
        }

        public EntryColumn(String name, Class<?> clazz, boolean share) {
            super(name, clazz, share);
        }

        public EntryColumn(String name, String key, boolean share) {
            super(name, key, share);
        }

        public EntryColumn(String name, Class<?> clazz, IntConversionProcessor processor, boolean share) {
            super(name, clazz, processor, share);
        }

        public EntryColumn(String name, String key, Class<?> clazz, IntConversionProcessor processor) {
            super(name, key, clazz, processor);
        }

        public EntryColumn(String name, String key, IntConversionProcessor processor, boolean share) {
            super(name, key, processor, share);
        }

        public EntryColumn(String name, Class<?> clazz, int cellStyle) {
            super(name, clazz, cellStyle);
        }

        public EntryColumn(String name, String key, int cellStyle) {
            super(name, key, cellStyle);
        }

        public EntryColumn(String name, Class<?> clazz, int cellStyle, boolean share) {
            super(name, clazz, cellStyle, share);
        }

        public EntryColumn(String name, String key, int cellStyle, boolean share) {
            super(name, key, cellStyle, share);
        }

        public EntryColumn(Sheet.Column other) {
            this.key = other.key;
            this.name = other.name;
            this.clazz = other.clazz;
            this.share = other.share;
            this.type = other.type;
            this.processor = other.processor;
            this.styleProcessor = other.styleProcessor;
            this.width = other.width;
            this.o = other.o;
            this.styles = other.styles;
            this.headerComment = other.headerComment;
            this.numFmt = other.numFmt;
            this.ignoreValue = other.ignoreValue;
            this.wrapText = other.wrapText;
            this.colIndex = other.colIndex;
            if (other.cellStyle > 0) {
                this.setCellStyle(other.cellStyle);
            }
            if (other.headerStyle > 0) {
                this.setHeaderStyle(other.headerStyle);
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public Field getField() {
            return this.field;
        }
    }
}

