/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.Comments;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.TooManyColumnsException;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.e7.XMLWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.processor.IntConversionProcessor;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"", "r"}, value="worksheet", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main", "http://schemas.openxmlformats.org/officeDocument/2006/relationships"})
public abstract class Sheet
implements Cloneable,
Storable {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Workbook workbook;
    protected String name;
    protected Column[] columns;
    protected WaterMark waterMark;
    protected RelManager relManager;
    protected int id;
    protected Comments comments;
    protected int autoSize;
    protected double width = 20.0;
    protected int rows;
    protected boolean hidden;
    protected int headStyleIndex = -1;
    protected int headStyle;
    protected int autoOdd = -1;
    protected int oddFill;
    protected boolean copySheet;
    protected int copyCount;
    protected RowBlock rowBlock;
    protected IWorksheetWriter sheetWriter;
    protected boolean headerReady;
    protected boolean shouldClose = true;
    protected ICellValueAndStyle cellValueAndStyle;
    protected int forceExport;
    private static final ThreadLocal<char[][]> cache = ThreadLocal.withInitial(() -> new char[][]{{'A'}, {'A', 'A'}, {'A', 'A', 'A'}});

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSheetWriter(IWorksheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }

    public void setCellValueAndStyle(ICellValueAndStyle cellValueAndStyle) {
        this.cellValueAndStyle = cellValueAndStyle;
    }

    public Sheet() {
        this(null);
    }

    public Sheet(String name) {
        this.name = name;
        this.relManager = new RelManager();
    }

    public Sheet(String name, Column ... columns) {
        this(name, (WaterMark)null, columns);
    }

    public Sheet(String name, WaterMark waterMark, Column ... columns) {
        this.name = name;
        this.columns = columns;
        this.waterMark = waterMark;
        this.relManager = new RelManager();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].styles = workbook.getStyles();
            }
        }
        return this;
    }

    public void what(String code) {
        this.workbook.what(code);
    }

    public void what(String code, String ... args) {
        this.workbook.what(code, args);
    }

    public SharedStrings getSst() {
        return this.workbook.getSst();
    }

    public double getDefaultWidth() {
        return this.width;
    }

    public Sheet autoSize() {
        this.autoSize = 1;
        return this;
    }

    public Sheet fixSize() {
        this.autoSize = 2;
        return this;
    }

    public Sheet fixSize(double width) {
        this.autoSize = 2;
        this.width = width;
        if (this.headerReady) {
            for (Column hc : this.columns) {
                hc.setWidth(width);
            }
        }
        return this;
    }

    public int getAutoSize() {
        return this.autoSize;
    }

    public boolean isAutoSize() {
        return this.autoSize == 1;
    }

    public Sheet cancelOddStyle() {
        this.autoOdd = 1;
        return this;
    }

    public int getAutoOdd() {
        return this.autoOdd;
    }

    public void setAutoOdd(int autoOdd) {
        this.autoOdd = autoOdd;
    }

    public Sheet setOddFill(Fill fill) {
        this.oddFill = this.workbook.getStyles().addFill(fill);
        return this;
    }

    public int getOddFill() {
        return this.oddFill;
    }

    public String getName() {
        return this.name;
    }

    public Sheet setName(String name) {
        this.name = name;
        return this;
    }

    public Comments getComments() {
        return this.comments;
    }

    public Comments createComments() {
        if (this.comments == null) {
            this.comments = new Comments(this.id, this.workbook.getCreator());
            this.addRel(new Relationship("../drawings/vmlDrawing" + this.id + ".vml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing"));
            this.addRel(new Relationship("../comments" + this.id + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments"));
        }
        return this.comments;
    }

    public Column[] getHeaderColumns() {
        if (!this.headerReady) {
            if (this.columns == null) {
                this.columns = new Column[0];
            }
            this.headerReady = true;
        }
        return this.columns;
    }

    public Column[] getAndSortHeaderColumns() {
        if (!this.headerReady) {
            this.getHeaderColumns();
            this.sortColumns(this.columns);
            for (int i = 0; i < this.columns.length; ++i) {
                if (i > 0 && this.columns[i - 1].colIndex >= this.columns[i].colIndex) {
                    this.columns[i].colIndex = this.columns[i - 1].colIndex + 1;
                    continue;
                }
                if (this.columns[i].colIndex <= i) {
                    this.columns[i].colIndex = i + 1;
                    continue;
                }
                ++this.columns[i].colIndex;
            }
            this.checkColumnLimit();
        }
        return this.columns;
    }

    protected void sortColumns(Column[] columns) {
        if (columns.length <= 1) {
            return;
        }
        int j = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].colIndex < 0) continue;
            int n = this.search(columns, j, columns[i].colIndex);
            if (n < i) {
                this.insert(columns, n, i);
            }
            ++j;
        }
        if (j == columns.length) {
            return;
        }
        int n = columns[0].colIndex;
        int i = 0;
        while (i < columns.length && j < columns.length) {
            if (n > i) {
                int k = Math.min(n - i, columns.length - j);
                while (k > 0) {
                    this.insert(columns, i++, j);
                    --k;
                    ++j;
                }
            } else {
                ++i;
            }
            if (i >= columns.length) continue;
            n = columns[i].colIndex;
        }
    }

    protected int search(Column[] columns, int n, int k) {
        int i;
        for (i = 0; i < n && columns[i].colIndex <= k; ++i) {
        }
        return i;
    }

    private void insert(Column[] columns, int n, int k) {
        Column t = columns[k];
        System.arraycopy(columns, n, columns, n + 1, k - n);
        columns[n] = t;
    }

    public Sheet setColumns(Column[] columns) {
        this.columns = (Column[])columns.clone();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].styles = this.workbook.getStyles();
        }
        return this;
    }

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public Sheet setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Sheet hidden() {
        this.hidden = true;
        return this;
    }

    public Sheet forceExport() {
        this.forceExport = 1;
        return this;
    }

    public Sheet cancelForceExport() {
        this.forceExport = 2;
        return this;
    }

    public int getForceExport() {
        return this.forceExport;
    }

    public void close() throws IOException {
        if (this.sheetWriter != null) {
            this.sheetWriter.close();
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        if (this.sheetWriter == null) {
            throw new ExcelWriteException("Worksheet writer is not instanced.");
        }
        if (!this.copySheet) {
            this.paging();
        }
        if (!this.headerReady) {
            this.getAndSortHeaderColumns();
        }
        if (this.rowBlock == null) {
            this.rowBlock = new RowBlock(this.getRowBlockSize());
        } else {
            this.rowBlock.reopen();
        }
        this.sheetWriter.writeTo(path);
    }

    protected void paging() {
    }

    public Sheet addRel(Relationship rel) {
        this.relManager.add(rel);
        return this;
    }

    public Relationship findRel(String key) {
        return this.relManager.likeByTarget(key);
    }

    public String getFileName() {
        return "sheet" + this.id + this.cellValueAndStyle.getFileSuffix();
    }

    public Sheet setHeadStyle(Font font, Fill fill, Border border) {
        return this.setHeadStyle(null, font, fill, border, 0, 6);
    }

    public Sheet setHeadStyle(Font font, Fill fill, Border border, int vertical, int horizontal) {
        return this.setHeadStyle(null, font, fill, border, vertical, horizontal);
    }

    public Sheet setHeadStyle(NumFmt numFmt, Font font, Fill fill, Border border, int vertical, int horizontal) {
        Styles styles = this.workbook.getStyles();
        this.headStyle = (numFmt != null ? styles.addNumFmt(numFmt) : 0) | (font != null ? styles.addFont(font) : 0) | (fill != null ? styles.addFill(fill) : 0) | (border != null ? styles.addBorder(border) : 0) | vertical | horizontal;
        this.headStyleIndex = styles.of(this.headStyle);
        return this;
    }

    public Sheet setHeadStyle(int style) {
        this.headStyle = style;
        this.headStyleIndex = this.workbook.getStyles().of(style);
        return this;
    }

    public Sheet setHeadStyleIndex(int styleIndex) {
        this.headStyleIndex = styleIndex;
        this.headStyle = this.workbook.getStyles().getStyleByIndex(styleIndex);
        return this;
    }

    public int getHeadStyle() {
        return this.headStyle;
    }

    public int getHeadStyleIndex() {
        return this.headStyleIndex;
    }

    public int buildHeadStyle(String fontColor, String fillBgColor) {
        Styles styles = this.workbook.getStyles();
        Font font = new Font(this.workbook.getI18N().getOrElse("local-font-family", "Arial"), 12, 2, Styles.toColor(fontColor));
        return styles.addFont(font) | styles.addFill(Fill.parse(fillBgColor)) | styles.addBorder(Border.parse("thin black")) | 0 | 6;
    }

    public int defaultHeadStyle() {
        return this.headStyle != 0 ? this.headStyle : (this.headStyle = this.buildHeadStyle("#ffffff", "#666699"));
    }

    public int defaultHeadStyleIndex() {
        if (this.headStyleIndex == -1) {
            this.setHeadStyle(this.buildHeadStyle("#ffffff", "#666699"));
        }
        return this.headStyleIndex;
    }

    protected static boolean nonOrIntDefault(int style) {
        return style == -1 || style == Styles.defaultIntBorderStyle() || style == Styles.defaultIntStyle();
    }

    public int size() {
        return -1;
    }

    public RowBlock nextBlock() {
        this.rowBlock.clear();
        this.resetBlockData();
        return this.rowBlock.flip();
    }

    public int getRowBlockSize() {
        return 32;
    }

    public void afterSheetAccess(Path workSheetPath) throws IOException {
        if (this.sheetWriter instanceof XMLWorksheetWriter) {
            this.relManager.write(workSheetPath, this.getFileName());
        }
    }

    protected String getCopySheetName() {
        int sub = this.copyCount;
        String _name = this.name;
        int i = this.name.lastIndexOf(40);
        if (i > 0) {
            int fs = Integer.parseInt(this.name.substring(i + 1, this.name.lastIndexOf(41)));
            _name = this.name.substring(0, this.name.charAt(i - 1) == ' ' ? i - 1 : i);
            if (++fs > sub) {
                sub = fs;
            }
        }
        return _name + " (" + sub + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sheet clone() {
        Sheet copy = null;
        try {
            copy = (Sheet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this);
                ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                copy = (Sheet)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e1) {
                try {
                    try {
                        copy = (Sheet)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(oos);
                    FileUtil.close(ois);
                    throw throwable;
                }
                FileUtil.close(oos);
                FileUtil.close(ois);
            }
            FileUtil.close(oos);
            FileUtil.close(ois);
        }
        if (copy != null) {
            copy.copyCount = ++this.copyCount;
            copy.name = this.getCopySheetName();
            copy.relManager = this.relManager.deepClone();
            copy.sheetWriter = this.sheetWriter.clone().setWorksheet(copy);
            copy.copySheet = true;
            copy.rows = 0;
        }
        return copy;
    }

    public void checkColumnLimit() {
        int b;
        int a = this.columns.length > 0 ? this.columns[this.columns.length - 1].colIndex : 0;
        if (a > (b = this.sheetWriter.getColumnLimit())) {
            throw new TooManyColumnsException(a, b);
        }
    }

    public boolean hasHeaderColumns() {
        return this.columns != null && this.columns.length > 0;
    }

    public static char[] int2Col(int n) {
        char[] c;
        char[][] cache_col = cache.get();
        int A = 65;
        if (n <= 26) {
            c = cache_col[0];
            c[0] = (char)(n - 1 + A);
        } else if (n <= 702) {
            int t = n / 26;
            int w = n % 26;
            if (w == 0) {
                --t;
                w = 26;
            }
            c = cache_col[1];
            c[0] = (char)(t - 1 + A);
            c[1] = (char)(w - 1 + A);
        } else {
            int tt = n / 26;
            int t = tt / 26;
            int w = n % 26;
            int m = tt % 26;
            if (w == 0) {
                --m;
                w = 26;
            }
            if (m <= 0) {
                --t;
                m += 26;
            }
            c = cache_col[2];
            c[0] = (char)(t - 1 + A);
            c[1] = (char)(m - 1 + A);
            c[2] = (char)(w - 1 + A);
        }
        return c;
    }

    public boolean hasNonHeader() {
        boolean noneHeader;
        this.columns = this.getHeaderColumns();
        boolean bl = noneHeader = this.columns == null || this.columns.length == 0;
        if (!noneHeader) {
            int n = 0;
            for (Column column : this.columns) {
                if (!StringUtil.isEmpty(column.name)) continue;
                ++n;
            }
            boolean bl2 = noneHeader = n == this.columns.length;
        }
        if (noneHeader) {
            --this.rows;
        }
        return noneHeader;
    }

    protected abstract void resetBlockData();

    public static class Column {
        public String key;
        public String name;
        public Class<?> clazz;
        public boolean share;
        @Deprecated
        public int type;
        public IntConversionProcessor processor;
        public StyleProcessor styleProcessor;
        public int cellStyle;
        public int headerStyle;
        private int cellStyleIndex = -1;
        private int headerStyleIndex = -1;
        public double width;
        public int o;
        public Styles styles;
        public Comment headerComment;
        public Comment cellComment;
        public NumFmt numFmt;
        public boolean ignoreValue;
        public int wrapText;
        public int colIndex = -1;

        public Column() {
        }

        public Column(String name, Class<?> clazz) {
            this(name, clazz, true);
        }

        public Column(String name, String key) {
            this(name, key, true);
        }

        public Column(String name, String key, Class<?> clazz) {
            this(name, key, true);
            this.clazz = clazz;
        }

        public Column(String name, Class<?> clazz, IntConversionProcessor processor) {
            this(name, clazz, processor, true);
        }

        public Column(String name, String key, IntConversionProcessor processor) {
            this(name, key, processor, true);
        }

        public Column(String name, Class<?> clazz, boolean share) {
            this.name = name;
            this.clazz = clazz;
            this.share = share;
        }

        public Column(String name, String key, boolean share) {
            this.name = name;
            this.key = key;
            this.share = share;
        }

        public Column(String name, Class<?> clazz, IntConversionProcessor processor, boolean share) {
            this(name, clazz, share);
            this.processor = processor;
        }

        public Column(String name, String key, Class<?> clazz, IntConversionProcessor processor) {
            this(name, key, clazz);
            this.processor = processor;
        }

        public Column(String name, String key, IntConversionProcessor processor, boolean share) {
            this(name, key, share);
            this.processor = processor;
        }

        public Column(String name, Class<?> clazz, int cellStyle) {
            this(name, clazz, cellStyle, true);
        }

        public Column(String name, String key, int cellStyle) {
            this(name, key, cellStyle, true);
        }

        public Column(String name, Class<?> clazz, int cellStyle, boolean share) {
            this(name, clazz, share);
            this.cellStyle = cellStyle;
        }

        public Column(String name, String key, int cellStyle, boolean share) {
            this(name, key, share);
            this.cellStyle = cellStyle;
        }

        public Column setWidth(double width) {
            if (width < 1.0E-8) {
                throw new ExcelWriteException("Width " + width + " less than 0.");
            }
            this.width = width;
            return this;
        }

        public boolean isShare() {
            return this.share;
        }

        @Deprecated
        public Column setType(int type) {
            this.type = type;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Column setName(String name) {
            this.name = name;
            return this;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Column setClazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public Column setProcessor(IntConversionProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Column setStyleProcessor(StyleProcessor styleProcessor) {
            this.styleProcessor = styleProcessor;
            return this;
        }

        public double getWidth() {
            return this.width;
        }

        public Column setCellStyle(int cellStyle) {
            this.cellStyle = cellStyle;
            this.cellStyleIndex = this.styles.of(cellStyle);
            return this;
        }

        public Column setHeaderStyle(int headerStyle) {
            this.headerStyle = headerStyle;
            this.headerStyleIndex = this.styles.of(headerStyle);
            return this;
        }

        public Column setColIndex(int colIndex) {
            this.colIndex = colIndex;
            return this;
        }

        public int getCellStyleIndex() {
            return this.cellStyleIndex;
        }

        public int getHeaderStyleIndex() {
            return this.headerStyleIndex;
        }

        int defaultHorizontal() {
            int horizontal = IWorksheetWriter.isDate(this.clazz) || IWorksheetWriter.isDateTime(this.clazz) || IWorksheetWriter.isLocalDate(this.clazz) || IWorksheetWriter.isLocalDateTime(this.clazz) || IWorksheetWriter.isTime(this.clazz) || IWorksheetWriter.isLocalTime(this.clazz) || IWorksheetWriter.isChar(this.clazz) || IWorksheetWriter.isBool(this.clazz) ? 6 : (IWorksheetWriter.isInt(this.clazz) || IWorksheetWriter.isLong(this.clazz) || IWorksheetWriter.isFloat(this.clazz) || IWorksheetWriter.isDouble(this.clazz) || IWorksheetWriter.isBigDecimal(this.clazz) ? 4 : 2);
            return horizontal;
        }

        public Column setCellStyle(Font font) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | 0 | this.defaultHorizontal());
            return this;
        }

        public Column setCellStyle(Font font, int horizontal) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | 0 | horizontal);
            return this;
        }

        public Column setCellStyle(Font font, Border border) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | this.defaultHorizontal());
            return this;
        }

        public Column setCellStyle(Font font, Border border, int horizontal) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | horizontal);
            return this;
        }

        public Column setCellStyle(Font font, Fill fill, Border border) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | this.defaultHorizontal());
            return this;
        }

        public Column setCellStyle(Font font, Fill fill, Border border, int horizontal) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | horizontal);
            return this;
        }

        public Column setCellStyle(Font font, Fill fill, Border border, int vertical, int horizontal) {
            this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | vertical | horizontal);
            return this;
        }

        public Column setCellStyle(NumFmt numFmt, Font font, Fill fill, Border border, int vertical, int horizontal) {
            this.cellStyle = this.styles.of((numFmt != null ? this.styles.addNumFmt(numFmt) : 0) | (font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | vertical | horizontal);
            return this;
        }

        public Column setShare(boolean share) {
            this.share = share;
            return this;
        }

        public Column setNumFmt(String code) {
            this.numFmt = new NumFmt(code);
            return this;
        }

        public NumFmt getNumFmt() {
            return this.numFmt != null ? this.numFmt : this.styles.getNumFmt(this.cellStyle);
        }

        public int getCellStyle(Class<?> clazz) {
            int style;
            if (IWorksheetWriter.isString(clazz)) {
                style = Styles.defaultStringBorderStyle() | this.wrapText;
            } else if (IWorksheetWriter.isDateTime(clazz) || IWorksheetWriter.isLocalDateTime(clazz)) {
                style = this.styles.addNumFmt(new NumFmt("yyyy\\-mm\\-dd\\ hh:mm:ss")) | 0x40 | 6;
            } else if (IWorksheetWriter.isDate(clazz) || IWorksheetWriter.isLocalDate(clazz)) {
                style = this.styles.addNumFmt(new NumFmt("yyyy\\-mm\\-dd")) | 0x40 | 6;
            } else if (IWorksheetWriter.isBool(clazz) || IWorksheetWriter.isChar(clazz)) {
                style = Styles.clearHorizontal(Styles.defaultStringBorderStyle()) | 6;
            } else if (IWorksheetWriter.isInt(clazz) || IWorksheetWriter.isLong(clazz)) {
                style = Styles.defaultIntBorderStyle();
                switch (this.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        style = Styles.clearNumFmt(style) | this.styles.addNumFmt(new NumFmt("0%_);[Red]-0% "));
                        break;
                    }
                    case 2: {
                        style = Styles.clearNumFmt(style) | this.styles.addNumFmt(new NumFmt("\u00a50_);[Red]-\u00a50 "));
                        break;
                    }
                }
            } else if (IWorksheetWriter.isFloat(clazz) || IWorksheetWriter.isDouble(clazz) || IWorksheetWriter.isBigDecimal(clazz)) {
                style = Styles.defaultDoubleBorderStyle();
                switch (this.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        style = Styles.clearNumFmt(style) | this.styles.addNumFmt(new NumFmt("0.00%_);[Red]-0.00% "));
                        break;
                    }
                    case 2: {
                        style = Styles.clearNumFmt(style) | this.styles.addNumFmt(new NumFmt("\u00a50.00_);[Red]-\u00a50.00 "));
                        break;
                    }
                }
            } else {
                style = IWorksheetWriter.isTime(clazz) || IWorksheetWriter.isLocalTime(clazz) ? this.styles.addNumFmt(new NumFmt("hh:mm:ss")) | 0x40 | 6 : 262208;
            }
            if (this.numFmt != null) {
                style = Styles.clearNumFmt(style) | this.styles.addNumFmt(this.numFmt);
            }
            return style;
        }

        public int getCellStyle() {
            if (this.cellStyleIndex != -1) {
                return this.cellStyle;
            }
            this.setCellStyle(this.getCellStyle(this.clazz));
            return this.cellStyle;
        }

        public boolean isIgnoreValue() {
            return this.ignoreValue;
        }

        Column ignoreValue() {
            this.ignoreValue = true;
            return this;
        }

        public Column setWrapText(boolean wrapText) {
            this.wrapText = wrapText ? 1 : 0;
            return this;
        }
    }
}

