/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;

public class XMLCellValueAndStyle
implements ICellValueAndStyle {
    private final int autoOdd;
    private final int oddFill;

    public XMLCellValueAndStyle(int autoOdd, int oddFill) {
        this.autoOdd = autoOdd;
        this.oddFill = oddFill;
    }

    @Override
    public void conversion(int row, Cell cell, int n, Sheet.Column hc) {
        Object e = hc.processor.conversion(n);
        if (e != null) {
            Class<?> clazz = e.getClass();
            if (IWorksheetWriter.isInt(clazz)) {
                if (IWorksheetWriter.isChar(clazz)) {
                    cell.setCv(((Character)e).charValue());
                } else if (IWorksheetWriter.isShort(clazz)) {
                    cell.setNv(((Short)e).shortValue());
                } else {
                    cell.setNv((Integer)e);
                }
                cell.xf = this.getStyleIndex(row, hc, e);
            } else {
                this.setCellValue(row, cell, e, hc, clazz);
                int style = hc.getCellStyle(clazz);
                cell.xf = this.getStyleIndex(row, hc, n, style);
            }
        } else {
            cell.blank();
            cell.xf = this.getStyleIndex(row, hc, null);
        }
    }

    @Override
    public void reset(int row, Cell cell, Object e, Sheet.Column hc) {
        this.setCellValue(row, cell, e, hc, hc.getClazz());
        if (hc.processor == null) {
            cell.xf = this.getStyleIndex(row, hc, e);
        }
    }

    private int getStyleIndex(int rows, Sheet.Column hc, Object o, int style) {
        if (this.autoOdd == 0 && this.isOdd(rows) && !Styles.hasFill(style)) {
            style |= this.oddFill;
        }
        int styleIndex = hc.styles.of(style);
        if (hc.styleProcessor != null) {
            style = hc.styleProcessor.build(o, style, hc.styles);
            styleIndex = hc.styles.of(style);
        }
        return styleIndex;
    }

    @Override
    public int getStyleIndex(int rows, Sheet.Column hc, Object o) {
        int style = hc.getCellStyle();
        return this.getStyleIndex(rows, hc, o, style);
    }

    private boolean isOdd(int rows) {
        return (rows & 1) == 1;
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }
}

