/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.util.StringUtil;

public interface Drawings {
    public List<Picture> listPictures();

    default public List<Picture> listPictures(Sheet sheet) {
        List<Picture> pictures = this.listPictures();
        return pictures == null ? null : pictures.stream().filter(p -> p.sheet.getId() == sheet.getId()).collect(Collectors.toList());
    }

    public static class Picture {
        Sheet sheet;
        Dimension dimension;
        Path localPath;
        String srcUrl;
        boolean background;

        public Sheet getSheet() {
            return this.sheet;
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        public Path getLocalPath() {
            return this.localPath;
        }

        public String getSrcUrl() {
            return this.srcUrl;
        }

        public boolean isBackground() {
            return this.background;
        }

        public String toString() {
            return this.background ? "Background picture [" + this.localPath + "] in worksheet " + this.sheet.getName() + (StringUtil.isNotEmpty(this.srcUrl) ? " from internet url " + this.srcUrl : "") : "Picture [" + this.localPath + "] in worksheet " + this.sheet.getName() + " at " + this.dimension + (StringUtil.isNotEmpty(this.srcUrl) ? " from internet url " + this.srcUrl : "");
        }
    }
}

