/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.common.math;

import java.math.RoundingMode;
import java.util.Iterator;
import org.ttzero.excel.common.math.DoubleUtils;

public final class DoubleMath {
    static double roundIntermediate(double x, RoundingMode mode) {
        if (!DoubleUtils.isFinite(x)) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        switch (mode) {
            case UNNECESSARY: {
                return x;
            }
            case FLOOR: {
                if (x >= 0.0 || DoubleMath.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x - 1L;
            }
            case CEILING: {
                if (x <= 0.0 || DoubleMath.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + 1L;
            }
            case DOWN: {
                return x;
            }
            case UP: {
                if (DoubleMath.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + (long)(x > 0.0 ? 1 : -1);
            }
            case HALF_EVEN: {
                return Math.rint(x);
            }
            case HALF_UP: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z;
            }
            case HALF_DOWN: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x;
                }
                return z;
            }
        }
        throw new AssertionError();
    }

    public static long roundToLong(double x, RoundingMode mode) {
        double z = DoubleMath.roundIntermediate(x, mode);
        return (long)z;
    }

    public static boolean isPowerOfTwo(double x) {
        if (x > 0.0 && DoubleUtils.isFinite(x)) {
            long significand = DoubleUtils.getSignificand(x);
            return (significand & significand - 1L) == 0L;
        }
        return false;
    }

    public static boolean isMathematicalInteger(double x) {
        return DoubleUtils.isFinite(x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(DoubleUtils.getSignificand(x)) <= Math.getExponent(x));
    }

    public static double mean(double ... values) {
        long count = 1L;
        double mean = DoubleMath.checkFinite(values[0]);
        for (int index = 1; index < values.length; ++index) {
            DoubleMath.checkFinite(values[index]);
            mean += (values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    @Deprecated
    public static double mean(int ... values) {
        long sum = 0L;
        for (int index = 0; index < values.length; ++index) {
            sum += (long)values[index];
        }
        return (double)sum / (double)values.length;
    }

    @Deprecated
    public static double mean(long ... values) {
        long count = 1L;
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            mean += ((double)values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    @Deprecated
    public static double mean(Iterable<? extends Number> values) {
        return DoubleMath.mean(values.iterator());
    }

    @Deprecated
    public static double mean(Iterator<? extends Number> values) {
        long count = 1L;
        double mean = DoubleMath.checkFinite(values.next().doubleValue());
        while (values.hasNext()) {
            double value = DoubleMath.checkFinite(values.next().doubleValue());
            mean += (value - mean) / (double)(++count);
        }
        return mean;
    }

    private static double checkFinite(double argument) {
        return argument;
    }

    public static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case UNNECESSARY: 
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_EVEN: 
            case HALF_UP: 
            case HALF_DOWN: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    private DoubleMath() {
    }
}

