/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.processor.ConversionProcessor;
import org.ttzero.excel.processor.StyleProcessor;

public class Column {
    public String key;
    public String name;
    public Class<?> clazz;
    public boolean share;
    public ConversionProcessor processor;
    public StyleProcessor styleProcessor;
    public Integer cellStyle;
    public Integer headerStyle;
    private int cellStyleIndex = -1;
    private int headerStyleIndex = -1;
    public double width;
    public int o;
    public Styles styles;
    public Comment headerComment;
    public Comment cellComment;
    public NumFmt numFmt;
    public boolean ignoreValue;
    public int wrapText;
    public int colIndex = -1;

    public Column() {
    }

    public Column(String name, Class<?> clazz) {
        this(name, clazz, true);
    }

    public Column(String name, String key) {
        this(name, key, true);
    }

    public Column(String name, String key, Class<?> clazz) {
        this(name, key, true);
        this.clazz = clazz;
    }

    public Column(String name, Class<?> clazz, ConversionProcessor processor) {
        this(name, clazz, processor, true);
    }

    public Column(String name, String key, ConversionProcessor processor) {
        this(name, key, processor, true);
    }

    public Column(String name, Class<?> clazz, boolean share) {
        this.name = name;
        this.clazz = clazz;
        this.share = share;
    }

    public Column(String name, String key, boolean share) {
        this.name = name;
        this.key = key;
        this.share = share;
    }

    public Column(String name, Class<?> clazz, ConversionProcessor processor, boolean share) {
        this(name, clazz, share);
        this.processor = processor;
    }

    public Column(String name, String key, Class<?> clazz, ConversionProcessor processor) {
        this(name, key, clazz);
        this.processor = processor;
    }

    public Column(String name, String key, ConversionProcessor processor, boolean share) {
        this(name, key, share);
        this.processor = processor;
    }

    public Column(String name, Class<?> clazz, int cellStyle) {
        this(name, clazz, cellStyle, true);
    }

    public Column(String name, String key, int cellStyle) {
        this(name, key, cellStyle, true);
    }

    public Column(String name, Class<?> clazz, int cellStyle, boolean share) {
        this(name, clazz, share);
        this.cellStyle = cellStyle;
    }

    public Column(String name, String key, int cellStyle, boolean share) {
        this(name, key, share);
        this.cellStyle = cellStyle;
    }

    public Column setWidth(double width) {
        if (width < 1.0E-8) {
            throw new ExcelWriteException("Width " + width + " less than 0.");
        }
        this.width = width;
        return this;
    }

    public boolean isShare() {
        return this.share;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Column setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public Column setProcessor(ConversionProcessor processor) {
        this.processor = processor;
        return this;
    }

    public Column setStyleProcessor(StyleProcessor styleProcessor) {
        this.styleProcessor = styleProcessor;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public Column setCellStyle(int cellStyle) {
        this.cellStyle = cellStyle;
        if (this.styles != null) {
            this.cellStyleIndex = this.styles.of(cellStyle);
        }
        return this;
    }

    public Column setHeaderStyle(int headerStyle) {
        this.headerStyle = headerStyle;
        if (this.styles != null) {
            this.headerStyleIndex = this.styles.of(headerStyle);
        }
        return this;
    }

    public Column setColIndex(int colIndex) {
        this.colIndex = colIndex;
        return this;
    }

    public int getCellStyleIndex() {
        return this.cellStyleIndex >= 0 ? this.cellStyleIndex : (this.cellStyleIndex = this.styles != null && this.cellStyle != null ? this.styles.of(this.cellStyle) : -1);
    }

    public int getHeaderStyleIndex() {
        return this.headerStyleIndex >= 0 ? this.headerStyleIndex : (this.headerStyleIndex = this.styles != null && this.headerStyle != null ? this.styles.of(this.headerStyle) : -1);
    }

    int defaultHorizontal() {
        int horizontal = IWorksheetWriter.isDate(this.clazz) || IWorksheetWriter.isDateTime(this.clazz) || IWorksheetWriter.isLocalDate(this.clazz) || IWorksheetWriter.isLocalDateTime(this.clazz) || IWorksheetWriter.isTime(this.clazz) || IWorksheetWriter.isLocalTime(this.clazz) || IWorksheetWriter.isChar(this.clazz) || IWorksheetWriter.isBool(this.clazz) ? 6 : (IWorksheetWriter.isInt(this.clazz) || IWorksheetWriter.isLong(this.clazz) || IWorksheetWriter.isFloat(this.clazz) || IWorksheetWriter.isDouble(this.clazz) || IWorksheetWriter.isBigDecimal(this.clazz) ? 4 : 2);
        return horizontal;
    }

    public Column setCellStyle(Font font) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | 0 | this.defaultHorizontal());
        return this;
    }

    public Column setCellStyle(Font font, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | 0 | horizontal);
        return this;
    }

    public Column setCellStyle(Font font, Border border) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | this.defaultHorizontal());
        return this;
    }

    public Column setCellStyle(Font font, Border border, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | horizontal);
        return this;
    }

    public Column setCellStyle(Font font, Fill fill, Border border) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | this.defaultHorizontal());
        return this;
    }

    public Column setCellStyle(Font font, Fill fill, Border border, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | horizontal);
        return this;
    }

    public Column setCellStyle(Font font, Fill fill, Border border, int vertical, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | vertical | horizontal);
        return this;
    }

    public Column setCellStyle(NumFmt numFmt, Font font, Fill fill, Border border, int vertical, int horizontal) {
        this.cellStyle = this.styles.of((numFmt != null ? this.styles.addNumFmt(numFmt) : 0) | (font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | vertical | horizontal);
        return this;
    }

    public Column setShare(boolean share) {
        this.share = share;
        return this;
    }

    public Column setNumFmt(String code) {
        this.numFmt = new NumFmt(code);
        return this;
    }

    public NumFmt getNumFmt() {
        return this.numFmt != null ? this.numFmt : this.styles.getNumFmt(this.cellStyle);
    }

    public int getCellStyle(Class<?> clazz) {
        int style = IWorksheetWriter.isString(clazz) ? Styles.defaultStringBorderStyle() | this.wrapText : (IWorksheetWriter.isDateTime(clazz) || IWorksheetWriter.isDate(clazz) || IWorksheetWriter.isLocalDateTime(clazz) ? this.styles.addNumFmt(NumFmt.DATETIME_FORMAT) | 0x40 | 6 : (IWorksheetWriter.isBool(clazz) || IWorksheetWriter.isChar(clazz) ? Styles.clearHorizontal(Styles.defaultStringBorderStyle()) | 6 : (IWorksheetWriter.isInt(clazz) || IWorksheetWriter.isLong(clazz) ? Styles.defaultIntBorderStyle() : (IWorksheetWriter.isFloat(clazz) || IWorksheetWriter.isDouble(clazz) || IWorksheetWriter.isBigDecimal(clazz) ? Styles.defaultDoubleBorderStyle() : (IWorksheetWriter.isLocalDate(clazz) ? this.styles.addNumFmt(NumFmt.DATE_FORMAT) | 0x40 | 6 : (IWorksheetWriter.isTime(clazz) || IWorksheetWriter.isLocalTime(clazz) ? this.styles.addNumFmt(NumFmt.TIME_FORMAT) | 0x40 | 6 : 262208))))));
        if (this.numFmt != null) {
            style = Styles.clearNumFmt(style) | this.styles.addNumFmt(this.numFmt);
        }
        return style;
    }

    public int getCellStyle() {
        if (this.cellStyle != null) {
            return this.cellStyle;
        }
        this.setCellStyle(this.getCellStyle(this.clazz));
        return this.cellStyle;
    }

    public boolean isIgnoreValue() {
        return this.ignoreValue;
    }

    public Column ignoreValue() {
        this.ignoreValue = true;
        return this;
    }

    public Column setWrapText(boolean wrapText) {
        this.wrapText = wrapText ? 1 : 0;
        return this;
    }

    public Column setHeaderComment(Comment headerComment) {
        this.headerComment = headerComment;
        return this;
    }
}

