/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager.docProps;

import java.util.ArrayList;
import java.util.List;
import org.ttzero.excel.annotation.Attr;
import org.ttzero.excel.annotation.NS;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.Tuple2;
import org.ttzero.excel.manager.docProps.XmlEntity;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"vt", ""}, uri={"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties"}, value="Properties")
public class App
extends XmlEntity {
    private String application;
    private int docSecurity;
    private boolean scaleCrop;
    private String company;
    private boolean linksUpToDate;
    private boolean sharedDoc;
    private boolean hyperlinksChanged;
    private String appVersion;
    private TitlesOfParts titlesOfParts;
    private HeadingPairs headingPairs;

    public void setTitlePards(List<String> list) {
        if (this.titlesOfParts == null) {
            this.titlesOfParts = new TitlesOfParts();
        }
        this.titlesOfParts.setVector(list);
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setDocSecurity(int docSecurity) {
        this.docSecurity = docSecurity;
    }

    public void setScaleCrop(boolean scaleCrop) {
        this.scaleCrop = scaleCrop;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setLinksUpToDate(boolean linksUpToDate) {
        this.linksUpToDate = linksUpToDate;
    }

    public void setSharedDoc(boolean sharedDoc) {
        this.sharedDoc = sharedDoc;
    }

    public void setHyperlinksChanged(boolean hyperlinksChanged) {
        this.hyperlinksChanged = hyperlinksChanged;
    }

    public void setAppVersion(String appVersion) {
        if (StringUtil.isEmpty(appVersion)) {
            this.appVersion = "1.0.0";
        } else {
            char[] chars = appVersion.toCharArray();
            int i = 0;
            int n = 0;
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] >= '0' && chars[j] <= '9') {
                    chars[i++] = chars[j];
                    continue;
                }
                if (chars[j] != '.' || i <= 0 || chars[i - 1] == '.' || n >= 2) break;
                chars[i++] = chars[j];
                ++n;
            }
            this.appVersion = i > 0 ? new String(chars, 0, chars[i - 1] != '.' ? i : i - 1) : "1.0.0";
        }
    }

    public String getApplication() {
        return this.application;
    }

    public String getCompany() {
        return this.company;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    private static class HeadingPairs {
        @NS(value="vt", contentUse=true)
        @Attr(name={"baseType", "size"}, value={"variant", "#size#"})
        List<Tuple2<String, String>> vector;

        private HeadingPairs() {
        }
    }

    public class TitlesOfParts {
        @NS(value="vt", contentUse=true)
        @Attr(name={"baseType", "size"}, value={"lpstr", "#size#"})
        List<String> vector;

        public void setVector(List<String> vector) {
            this.vector = vector;
            App.this.headingPairs = new HeadingPairs();
            ((App)App.this).headingPairs.vector = new ArrayList<Tuple2<String, String>>();
            ((App)App.this).headingPairs.vector.add(new Tuple2<String, String>("lpstr", "Workbook"));
            ((App)App.this).headingPairs.vector.add(new Tuple2<String, String>("i4", String.valueOf(vector.size())));
        }
    }
}

