/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager.docProps;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.ttzero.excel.annotation.Attr;
import org.ttzero.excel.annotation.NS;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.Tuple2;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

class XmlEntity
implements Storable {
    private String[] prefixs;
    private String[] uris;

    XmlEntity() {
    }

    @Override
    public void writeTo(Path path) throws IOException {
        int i;
        DocumentFactory factory = DocumentFactory.getInstance();
        Element rootElement = null;
        TopNS topNs = this.getClass().getAnnotation(TopNS.class);
        boolean hasTopNs = this.getClass().isAnnotationPresent(TopNS.class);
        if (hasTopNs) {
            this.prefixs = topNs.prefix();
            this.uris = topNs.uri();
            for (i = 0; i < this.prefixs.length; ++i) {
                if (this.prefixs[i].length() != 0) continue;
                rootElement = factory.createElement(topNs.value(), this.uris[i]);
                break;
            }
        }
        if (rootElement == null) {
            if (hasTopNs) {
                rootElement = factory.createElement(topNs.value());
            } else {
                return;
            }
        }
        if (hasTopNs) {
            for (i = 0; i < this.prefixs.length; ++i) {
                rootElement.add(Namespace.get((String)this.prefixs[i], (String)this.uris[i]));
            }
        }
        try {
            this.toXML(rootElement, this);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExcelWriteException("Create Node failed.", e);
        }
        Document doc = factory.createDocument(rootElement);
        FileUtil.writeToDiskNoFormat(doc, path);
    }

    public void toXML(Element doc, Object o) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Field[] fields;
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            int len;
            int i;
            Element element;
            field.setAccessible(true);
            Object oo = field.get(o);
            Class<?> clazz = field.getType();
            if (clazz == this.getClass()) continue;
            NS ns = field.getAnnotation(NS.class);
            if (ns == null && field.isAnnotationPresent(Attr.class)) {
                ns = field.getAnnotation(Attr.class).namespace();
            }
            if (ns != null) {
                Namespace namespace;
                if (ns.uri().length() == 0) {
                    int n = StringUtil.indexOf(this.prefixs, ns.value());
                    namespace = Namespace.get((String)ns.value(), (String)(n > -1 ? this.uris[n] : ""));
                } else {
                    namespace = Namespace.get((String)ns.value(), (String)ns.uri());
                    doc.add(namespace);
                }
                if (oo == null) {
                    element = doc.addElement(QName.get((String)field.getName(), (Namespace)namespace));
                    this.writeAttr(field, element);
                    continue;
                }
                if (clazz == java.util.Date.class || clazz == Date.class) {
                    element = doc.addElement(QName.get((String)field.getName(), (Namespace)namespace)).addText(DateUtil.toTString((java.util.Date)oo));
                } else {
                    if (clazz == List.class) {
                        element = doc.addElement(QName.get((String)field.getName(), (Namespace)namespace));
                        Collection collection = (Collection)oo;
                        if (field.isAnnotationPresent(Attr.class)) {
                            int n;
                            Attr attr = field.getAnnotation(Attr.class);
                            String[] names = attr.name();
                            String[] values = attr.value();
                            NS subNs = attr.namespace();
                            if (!this.noNamespace(subNs)) {
                                Namespace ans = Namespace.get((String)subNs.value(), (String)subNs.uri());
                                doc.add(ans);
                                for (int i2 = 0; i2 < names.length; ++i2) {
                                    int len2;
                                    if (values[i2].charAt(0) == '#' && values[i2].charAt(len2 = values[i2].length() - 1) == '#') {
                                        Method m = oo.getClass().getMethod(values[i2].substring(1, len2), new Class[0]);
                                        m.setAccessible(true);
                                        Object vo = m.invoke(oo, new Object[0]);
                                        element.addAttribute(QName.get((String)names[i2], (Namespace)ans), vo.toString());
                                        continue;
                                    }
                                    element.addAttribute(QName.get((String)names[i2], (Namespace)ans), values[i2]);
                                }
                            } else {
                                for (i = 0; i < names.length; ++i) {
                                    if (values[i].charAt(0) == '#' && values[i].charAt(len = values[i].length() - 1) == '#') {
                                        Method m = oo.getClass().getMethod(values[i].substring(1, len), new Class[0]);
                                        m.setAccessible(true);
                                        Object vo = m.invoke(oo, new Object[0]);
                                        element.addAttribute(names[i], vo.toString());
                                        continue;
                                    }
                                    element.addAttribute(names[i], values[i]);
                                }
                            }
                            if ((n = StringUtil.indexOf(names, "baseType")) == -1) {
                                this.writeArrayNoBaseType(element, collection);
                                continue;
                            }
                            this.writeArrayWithBaseType(element, collection, (Namespace)(ns.contentUse() ? namespace : null), values[n]);
                            continue;
                        }
                        this.writeArrayNoBaseType(element, collection);
                        continue;
                    }
                    element = doc.addElement(QName.get((String)field.getName(), (Namespace)namespace)).addText(oo.toString());
                }
            } else {
                if (oo == null) {
                    element = doc.addElement(StringUtil.uppFirstKey(field.getName()));
                    this.writeAttr(field, element);
                    continue;
                }
                if (clazz == java.util.Date.class || clazz == Date.class) {
                    element = doc.addElement(StringUtil.uppFirstKey(field.getName())).addText(DateUtil.toTString((java.util.Date)oo));
                } else {
                    if (clazz == List.class) {
                        element = doc.addElement(StringUtil.uppFirstKey(field.getName()));
                        Collection collection = (Collection)oo;
                        if (field.isAnnotationPresent(Attr.class)) {
                            int n;
                            Attr attr = field.getAnnotation(Attr.class);
                            String[] names = attr.name();
                            String[] values = attr.value();
                            NS subNs = attr.namespace();
                            if (!this.noNamespace(subNs)) {
                                Namespace ans = Namespace.get((String)subNs.value(), (String)subNs.uri());
                                doc.add(ans);
                                for (i = 0; i < names.length; ++i) {
                                    if (values[i].charAt(0) == '#' && values[i].charAt(len = values[i].length() - 1) == '#') {
                                        Object vo = oo.getClass().getMethod(values[i].substring(1, len), new Class[0]).invoke(oo, new Object[0]);
                                        element.addAttribute(QName.get((String)names[i], (Namespace)ans), vo.toString());
                                        continue;
                                    }
                                    element.addAttribute(QName.get((String)names[i], (Namespace)ans), values[i]);
                                }
                            } else {
                                for (int i3 = 0; i3 < names.length; ++i3) {
                                    element.addAttribute(names[i3], values[i3]);
                                }
                            }
                            if ((n = StringUtil.indexOf(names, "baseType")) == -1) {
                                this.writeArrayNoBaseType(element, collection);
                                continue;
                            }
                            this.writeArrayWithBaseType(element, collection, null, values[n]);
                            continue;
                        }
                        this.writeArrayNoBaseType(element, collection);
                        continue;
                    }
                    if (this.isDeclareClass(clazz)) {
                        element = doc.addElement(StringUtil.uppFirstKey(field.getName()));
                        this.toXML(element, oo);
                    } else {
                        element = doc.addElement(StringUtil.uppFirstKey(field.getName())).addText(oo.toString());
                    }
                }
            }
            this.writeAttr(field, element);
        }
    }

    protected void writeAttr(Field field, Element element) {
        block4: {
            if (!field.isAnnotationPresent(Attr.class)) break block4;
            Attr attr = field.getAnnotation(Attr.class);
            String[] names = attr.name();
            String[] values = attr.value();
            NS _ns = attr.namespace();
            if (!this.noNamespace(_ns)) {
                Namespace ans = Namespace.get((String)_ns.value(), (String)_ns.uri());
                for (int i = 0; i < names.length; ++i) {
                    element.addAttribute(QName.get((String)names[i], (Namespace)ans), values[i]);
                }
            } else {
                for (int i = 0; i < names.length; ++i) {
                    element.addAttribute(names[i], values[i]);
                }
            }
        }
    }

    protected boolean noNamespace(NS ns) {
        return ns.value().length() == 0 || "-".equals(ns.value());
    }

    private void writeArrayNoBaseType(Element element, Collection<?> collection) {
        StringBuilder buf = new StringBuilder();
        for (Object node : collection) {
            if (node instanceof Tuple2) {
                Tuple2 nv = (Tuple2)node;
                element.addElement(nv.stringV1()).setText(nv.stringV2());
                continue;
            }
            buf.append(node).append(',');
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
            element.setText(buf.toString());
        }
    }

    protected void writeArrayWithBaseType(Element element, Collection<?> collection, Namespace namespace, String baseType) {
        if (namespace != null) {
            for (Object node : collection) {
                if (node instanceof Tuple2) {
                    Tuple2 nv = (Tuple2)node;
                    element.addElement(QName.get((String)baseType, (Namespace)namespace)).addElement(QName.get((String)nv.stringV1(), (Namespace)namespace)).setText(nv.stringV2());
                    continue;
                }
                element.addElement(QName.get((String)baseType, (Namespace)namespace)).setText(node.toString());
            }
        } else {
            for (Object node : collection) {
                if (node instanceof Tuple2) {
                    Tuple2 nv = (Tuple2)node;
                    element.addElement(baseType).addElement(nv.stringV1()).setText(nv.stringV2());
                    continue;
                }
                element.addElement(baseType).setText(node.toString());
            }
        }
    }

    private boolean isDeclareClass(Class<?> clazz) {
        Class<?>[] declareClasses;
        for (Class<?> c : declareClasses = this.getClass().getDeclaredClasses()) {
            if (c != clazz) continue;
            return true;
        }
        return false;
    }
}

