/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.ttzero.excel.entity.Storageable;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.util.StringUtil;

public interface IWorkbookWriter
extends Storageable {
    public void setWorkbook(Workbook var1);

    public String getSuffix();

    public void writeTo(OutputStream var1) throws IOException;

    public void writeTo(File var1) throws IOException;

    public Path template() throws IOException;

    default public Path reMarkPath(Path src, Path rootPath, String fileName) throws IOException {
        String suffix = this.getSuffix();
        Path o = rootPath.resolve(fileName + suffix);
        if (Files.exists(o, new LinkOption[0])) {
            String fname = fileName;
            Path parent = o.getParent();
            if (parent != null && Files.exists(parent, new LinkOption[0])) {
                String new_name;
                String[] os = parent.toFile().list((dir, name) -> new File(dir, name).isFile() && name.startsWith(fname) && name.endsWith(suffix));
                if (os != null) {
                    int n;
                    int len = os.length;
                    while ((n = StringUtil.indexOf(os, new_name = fname + " (" + len++ + ")" + suffix)) > -1) {
                    }
                } else {
                    new_name = fname + suffix;
                }
                o = parent.resolve(new_name);
            } else {
                Files.move(src, o, StandardCopyOption.REPLACE_EXISTING);
                return o;
            }
        }
        Files.move(src, o, new CopyOption[0]);
        return o;
    }
}

