/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.ttzero.excel.util.FileUtil;

public class SharedStringTable
implements AutoCloseable,
Iterable<String> {
    private Path temp;
    private int count;
    private SeekableByteChannel channel;
    private ByteBuffer buffer;
    private long mark = -1L;
    protected boolean shouldDelete;

    protected SharedStringTable() throws IOException {
        this.temp = Files.createTempFile("+", ".sst", new FileAttribute[0]);
        this.shouldDelete = true;
        this.channel = Files.newByteChannel(this.temp, StandardOpenOption.WRITE, StandardOpenOption.READ);
        this.buffer = ByteBuffer.allocate(2048);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(0);
        this.flush();
    }

    protected SharedStringTable(Path path) throws IOException {
        if (!FileUtil.exists(path)) {
            throw new IOException("The index path [" + path + "] not exists.");
        }
        this.temp = path;
        this.channel = Files.newByteChannel(this.temp, StandardOpenOption.WRITE, StandardOpenOption.READ);
        this.buffer = ByteBuffer.allocate(2048);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.channel.read(this.buffer);
        this.buffer.flip();
        if (this.buffer.remaining() > 4) {
            this.count = this.buffer.getInt();
        }
        this.buffer.clear();
        this.channel.position(this.channel.size());
    }

    protected Path getTemp() {
        return this.temp;
    }

    public int push(char c) throws IOException {
        return this.pushChar(c);
    }

    public int push(String key) throws IOException {
        int len;
        if (key == null || (len = key.length()) == 0) {
            return this.pushChar('\uffff');
        }
        if (len == 1) {
            return this.pushChar(key.charAt(0));
        }
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        if (this.buffer.remaining() < bytes.length + 4) {
            this.flush();
        }
        this.buffer.putInt(bytes.length);
        this.buffer.put(bytes);
        return this.count++;
    }

    private int pushChar(char c) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        this.buffer.putInt(~c);
        return this.count++;
    }

    public int find(char c) throws IOException {
        return this.find(c, 0L);
    }

    public int find(char c, long pos) throws IOException {
        int dist;
        this.flush();
        int index = 0;
        this.mark().skip(pos);
        block0: while ((dist = this.channel.read(this.buffer)) > 0) {
            this.buffer.flip();
            while (SharedStringTable.hasFullValue(this.buffer)) {
                int a = this.buffer.getInt();
                if (a < 0) {
                    if (~a == c) {
                        break block0;
                    }
                } else {
                    this.buffer.position(this.buffer.position() + a);
                }
                ++index;
            }
            this.buffer.compact();
        }
        this.reset();
        this.buffer.rewind();
        return index < this.count ? index : -1;
    }

    public int find(String key) throws IOException {
        return this.find(key, 0L);
    }

    public int find(String key, long pos) throws IOException {
        this.flush();
        this.mark().skip(pos);
        int index = key != null && !key.isEmpty() ? this.findKey(key) : this.findNull();
        this.reset();
        this.buffer.rewind();
        return index < this.count ? index : -1;
    }

    private int findNull() throws IOException {
        int dist;
        int index = 0;
        int n = -65536;
        block0: while ((dist = this.channel.read(this.buffer)) > 0) {
            this.buffer.flip();
            while (SharedStringTable.hasFullValue(this.buffer)) {
                int a = this.buffer.getInt();
                if (a == n) break block0;
                if (a > 0) {
                    this.buffer.position(this.buffer.position() + a);
                }
                ++index;
            }
            this.buffer.compact();
        }
        return index;
    }

    private int findKey(String key) throws IOException {
        int dist;
        int index = 0;
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        block0: while ((dist = this.channel.read(this.buffer)) > 0) {
            this.buffer.flip();
            while (SharedStringTable.hasFullValue(this.buffer)) {
                int a = this.buffer.getInt();
                if (a < 0) {
                    ++index;
                    continue;
                }
                if (a == bytes.length) {
                    int b;
                    int i = 0;
                    int p = this.buffer.position();
                    for (b = a - 1; i <= b && bytes[b] == this.buffer.get(p + b) && this.buffer.get() == bytes[i]; --b, ++i) {
                    }
                    if (i >= b && (i != b || (a & 1) != 1)) break block0;
                    this.buffer.position(p + a);
                } else {
                    this.buffer.position(this.buffer.position() + a);
                }
                ++index;
            }
            this.buffer.compact();
        }
        return index;
    }

    public int size() {
        return this.count;
    }

    private void flush() throws IOException {
        this.buffer.flip();
        if (this.buffer.hasRemaining()) {
            this.channel.write(this.buffer);
        }
        this.buffer.clear();
    }

    protected static boolean hasFullValue(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int position = buffer.position();
        int n = buffer.get(position) & 0xFF;
        n |= (buffer.get(position + 1) & 0xFF) << 8;
        n |= (buffer.get(position + 2) & 0xFF) << 16;
        return (n |= (buffer.get(position + 3) & 0xFF) << 24) < 0 || n + 4 <= buffer.remaining();
    }

    protected void commit() throws IOException {
        this.flush();
        this.buffer.putInt(this.count);
        this.buffer.flip();
        this.channel.position(0L);
        this.channel.write(this.buffer);
    }

    @Override
    public void close() throws IOException {
        this.commit();
        this.buffer = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.shouldDelete) {
            FileUtil.rm(this.temp);
        }
    }

    protected long position() throws IOException {
        return this.channel.position() + (long)this.buffer.position();
    }

    protected int read(ByteBuffer buffer) throws IOException {
        return this.channel.read(buffer);
    }

    protected SharedStringTable mark() throws IOException {
        this.flush();
        this.mark = this.channel.position();
        return this;
    }

    protected SharedStringTable reset() throws IOException {
        if (this.mark == -1L) {
            throw new InvalidMarkException();
        }
        this.channel.position(this.mark);
        this.mark = -1L;
        this.buffer.clear();
        return this;
    }

    protected SharedStringTable skip(long position) throws IOException {
        this.channel.position(position + 4L);
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SSTIterator(this.temp);
    }

    private static class SSTIterator
    implements Iterator<String> {
        private SeekableByteChannel channel;
        private ByteBuffer buffer;
        private byte[] bytes;
        private int count;
        private char[] chars;

        private SSTIterator(Path temp) {
            try {
                this.channel = Files.newByteChannel(temp, StandardOpenOption.READ);
                this.buffer = ByteBuffer.allocate(2048);
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.channel.read(this.buffer);
                this.buffer.flip();
                if (this.buffer.remaining() > 4) {
                    this.count = this.buffer.getInt();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.bytes = new byte[128];
            this.chars = new char[1];
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.buffer.remaining() < 6 || !SharedStringTable.hasFullValue(this.buffer)) {
                    this.buffer.compact();
                    this.channel.read(this.buffer);
                    this.buffer.flip();
                }
                return this.buffer.hasRemaining();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public String next() {
            int a = this.buffer.getInt();
            if (a > this.bytes.length) {
                this.bytes = new byte[a];
            }
            if (a < 0) {
                char c = (char)(~a);
                if (c < '\uffff') {
                    this.chars[0] = c;
                    return new String(this.chars);
                }
                return "";
            }
            this.buffer.get(this.bytes, 0, a);
            return new String(this.bytes, 0, a, StandardCharsets.UTF_8);
        }
    }
}

