/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.XMLMergeRow;
import org.ttzero.excel.reader.XMLSheet;

class XMLMergeSheet
extends XMLSheet
implements MergeSheet {
    private Grid mergeCells;

    XMLMergeSheet() {
    }

    XMLMergeSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
    }

    @Override
    public XMLMergeSheet load() throws IOException {
        super.load();
        if (this.mergeCells == null && !this.eof) {
            this.parseDimension();
        }
        if (!this.eof && !(this.sRow instanceof XMLMergeRow) && this.mergeCells != null) {
            this.sRow = this.sRow.asMergeRow().setCopyValueFunc(this::mergeCell);
        }
        return this;
    }

    @Override
    void parseMerge(SeekableByteChannel channel, CharBuffer charBuffer, ByteBuffer buffer, int block) throws IOException {
        int limit = charBuffer.limit();
        ArrayList<Dimension> mergeCells = null;
        boolean eof = false;
        int i = charBuffer.position();
        while (true) {
            if (i < limit - 11 && (charBuffer.get(i) != '<' || charBuffer.get(i + 1) != 'm' || charBuffer.get(i + 2) != 'e' || charBuffer.get(i + 3) != 'r' || charBuffer.get(i + 4) != 'g' || charBuffer.get(i + 5) != 'e' || charBuffer.get(i + 6) != 'C' || charBuffer.get(i + 7) != 'e' || charBuffer.get(i + 8) != 'l' || charBuffer.get(i + 9) != 'l' || charBuffer.get(i + 10) > ' ')) {
                ++i;
                continue;
            }
            if (i >= limit - 11) {
                if (eof) break;
                while (i >= 0 && charBuffer.get(i) != '<') {
                    --i;
                }
                if (i > 0) {
                    channel.position(channel.position() + (long)i);
                }
                buffer.clear();
                channel.read(buffer);
                buffer.flip();
                if (buffer.limit() <= 0) break;
                charBuffer = StandardCharsets.UTF_8.decode(buffer);
                limit = charBuffer.limit();
                i = 0;
                eof = limit < block;
                continue;
            }
            i += 11;
            while (i < limit - 5 && (charBuffer.get(i) != 'r' || charBuffer.get(i + 1) != 'e' || charBuffer.get(i + 2) != 'f' || charBuffer.get(i + 3) != '=' || charBuffer.get(i + 4) != '\"')) {
                ++i;
            }
            if (i > limit - 5) continue;
            int f = i += 5;
            while (charBuffer.get(i) != '\"') {
                ++i;
            }
            if (i > limit) continue;
            char[] chars = new char[i - f];
            charBuffer.position(f);
            charBuffer.get(chars, 0, i - f);
            if (mergeCells == null) {
                mergeCells = new ArrayList<Dimension>();
            }
            mergeCells.add(Dimension.of(new String(chars)));
            charBuffer.position(++i);
        }
        if (mergeCells != null) {
            Dimension dim = (Dimension)mergeCells.get(0);
            int fr = dim.firstRow;
            int lr = dim.lastRow;
            short fc = dim.firstColumn;
            short lc = dim.lastColumn;
            int n = (lr - fr + 1) * (lc - fc + 1);
            int len = mergeCells.size();
            for (int j = 1; j < len; ++j) {
                dim = (Dimension)mergeCells.get(j);
                n += (dim.lastRow - dim.firstRow + 1) * (dim.lastColumn - dim.firstColumn + 1);
                if (fr > dim.firstRow) {
                    fr = dim.firstRow;
                }
                if (lr < dim.lastRow) {
                    lr = dim.lastRow;
                }
                if (fc > dim.firstColumn) {
                    fc = dim.firstColumn;
                }
                if (lc >= dim.lastColumn) continue;
                lc = dim.lastColumn;
            }
            Grid grid = GridFactory.create(new Dimension(fr, fc, lr, lc), n);
            for (Dimension d : mergeCells) {
                grid.mark(d);
                this.LOGGER.debug("merged cells range {}", (Object)d);
            }
            this.LOGGER.debug("Grid: {}", (Object)grid);
            this.mergeCells = grid;
        }
    }

    private void mergeCell(int row, Cell cell) {
        this.mergeCells.merge(row, cell);
    }
}

