/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ResultSetSheet
extends Sheet {
    protected ResultSet rs;

    public ResultSetSheet() {
    }

    public ResultSetSheet(String name) {
        super(name);
    }

    public ResultSetSheet(String name, Sheet.Column ... columns) {
        super(name, columns);
    }

    public ResultSetSheet(String name, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
    }

    public ResultSetSheet(ResultSet rs) {
        this(null, rs);
    }

    public ResultSetSheet(String name, ResultSet rs) {
        super(name);
        this.rs = rs;
    }

    public ResultSetSheet(ResultSet rs, Sheet.Column ... columns) {
        this((String)null, rs, (WaterMark)null, columns);
    }

    public ResultSetSheet(String name, ResultSet rs, Sheet.Column ... columns) {
        this(name, rs, (WaterMark)null, columns);
    }

    public ResultSetSheet(ResultSet rs, WaterMark waterMark, Sheet.Column ... columns) {
        this(null, rs, waterMark, columns);
    }

    public ResultSetSheet(String name, ResultSet rs, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
        this.rs = rs;
    }

    public ResultSetSheet setRs(ResultSet rs) {
        this.rs = rs;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.shouldClose && this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                this.workbook.what("9006", e.getMessage());
            }
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        int len = this.columns.length;
        int n = 0;
        int limit = this.sheetWriter.getRowLimit() - 1;
        try {
            int rbs = this.getRowBlockSize();
            while (n++ < rbs && this.rows < limit && this.rs.next()) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                Cell[] cells = row.realloc(len);
                for (int i = 1; i <= len; ++i) {
                    Sheet.Column hc = this.columns[i - 1];
                    Cell cell = cells[i - 1];
                    cell.clear();
                    Object e = this.rs.getObject(i);
                    this.cellValueAndStyle.reset(this.rows, cell, e, hc);
                }
                ++this.rows;
            }
        }
        catch (SQLException e) {
            throw new ExcelWriteException(e);
        }
        if (this.rows >= limit) {
            this.shouldClose = false;
            ResultSetSheet copy = (ResultSetSheet)this.getClass().cast(this.clone());
            this.workbook.insertSheet(this.id, copy);
        } else {
            this.shouldClose = true;
        }
    }

    @Override
    public Sheet.Column[] getHeaderColumns() {
        int i;
        if (this.headerReady) {
            return this.columns;
        }
        if (this.rs == null) {
            throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter ResultSet");
        }
        try {
            ResultSetMetaData metaData = this.rs.getMetaData();
            if (this.hasHeaderColumns()) {
                for (i = 0; i < this.columns.length; ++i) {
                    Class<?> metaClazz;
                    Sheet.Column column = this.columns[i];
                    if (StringUtil.isEmpty(column.getName())) {
                        column.setName(metaData.getColumnLabel(i + 1));
                    }
                    if (column.clazz == (metaClazz = this.columnTypeToClass(metaData.getColumnType(i + 1)))) continue;
                    this.what("The specified type " + column.clazz + " is different" + " from metadata column type " + metaClazz);
                    column.clazz = metaClazz;
                }
            } else {
                int count = metaData.getColumnCount();
                this.columns = new Sheet.Column[count];
                while (++i <= count) {
                    this.columns[i - 1] = new Sheet.Column(metaData.getColumnLabel(i), this.columnTypeToClass(metaData.getColumnType(i)));
                }
            }
        }
        catch (SQLException e) {
            this.what("un-support get result set meta data.");
        }
        if (this.hasHeaderColumns()) {
            this.checkColumnLimit();
            for (i = 0; i < this.columns.length; ++i) {
                if (StringUtil.isEmpty(this.columns[i].getName())) {
                    this.columns[i].setName(String.valueOf(i));
                }
                if (this.columns[i].styles != null) continue;
                this.columns[i].styles = this.workbook.getStyles();
            }
            this.headerReady = this.columns.length > 0;
        }
        return this.columns;
    }

    protected Class<?> columnTypeToClass(int type) {
        Class clazz;
        switch (type) {
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case 4: {
                clazz = Integer.TYPE;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -7: {
                clazz = Boolean.TYPE;
                break;
            }
            case -6: {
                clazz = Byte.TYPE;
                break;
            }
            case 5: {
                clazz = Short.TYPE;
                break;
            }
            case -5: {
                clazz = Long.TYPE;
                break;
            }
            case 7: {
                clazz = Float.TYPE;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.TYPE;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            default: {
                clazz = Object.class;
            }
        }
        return clazz;
    }
}

