/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.annotation.NS;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.ExcelType;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.docProps.App;
import org.ttzero.excel.manager.docProps.Core;
import org.ttzero.excel.reader.AppInfo;
import org.ttzero.excel.reader.CalcSheet;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLCalcSheet;
import org.ttzero.excel.reader.XMLMergeSheet;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.util.ZipUtil;

public class ExcelReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelReader.class);
    public static final int VALUE_ONLY = 0;
    public static final int VALUE_AND_CALC = 2;
    public static final int COPY_ON_MERGED = 4;
    protected Path self;
    protected Sheet[] sheets;
    private Path temp;
    private ExcelType type;
    private AppInfo appInfo;
    private SharedStrings sst;
    protected int option;
    protected boolean hasFormula;

    protected ExcelReader() {
    }

    public static ExcelReader read(Path path) throws IOException {
        return ExcelReader.read(path, 0, 0, 0);
    }

    public static ExcelReader read(InputStream stream) throws IOException {
        return ExcelReader.read(stream, 0, 0, 0);
    }

    public static ExcelReader read(Path path, int option) throws IOException {
        return ExcelReader.read(path, 0, 0, option);
    }

    public static ExcelReader read(InputStream stream, int option) throws IOException {
        return ExcelReader.read(stream, 0, 0, option);
    }

    public static ExcelReader read(Path path, int bufferSize, int option) throws IOException {
        return ExcelReader.read(path, bufferSize, 0, option);
    }

    public static ExcelReader read(InputStream stream, int bufferSize, int option) throws IOException {
        return ExcelReader.read(stream, bufferSize, 0, option);
    }

    public static ExcelReader read(Path path, int bufferSize, int cacheSize, int option) throws IOException {
        return ExcelReader.read(path, bufferSize, cacheSize, false, option);
    }

    public static ExcelReader read(InputStream stream, int bufferSize, int cacheSize, int option) throws IOException {
        Path temp = FileUtil.mktmp("eec+");
        if (temp == null) {
            throw new IOException("Create temp directory error. Please check your permission");
        }
        FileUtil.cp(stream, temp);
        return ExcelReader.read(temp, bufferSize, cacheSize, true, option);
    }

    public ExcelType getType() {
        return this.type;
    }

    public Stream<Sheet> sheets() {
        Iterator<Sheet> iter = new Iterator<Sheet>(){
            int n = 0;

            @Override
            public boolean hasNext() {
                return this.n < ExcelReader.this.sheets.length;
            }

            @Override
            public Sheet next() {
                try {
                    return ExcelReader.this.sheets[this.n++].load();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return StreamSupport.stream(Spliterators.spliterator(iter, (long)this.sheets.length, 272), false);
    }

    public Sheet sheet(int index) {
        try {
            return this.sheets[index].load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Sheet sheet(String sheetName) {
        try {
            for (Sheet t : this.sheets) {
                if (!sheetName.equals(t.getName())) continue;
                return t.load();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    public Sheet[] all() {
        return this.sheets;
    }

    public int getSize() {
        return this.sheets != null ? this.sheets.length : 0;
    }

    @Override
    public void close() throws IOException {
        for (Sheet st : this.sheets) {
            st.close();
        }
        if (this.sst != null) {
            this.sst.close();
        }
        if (this.self != null) {
            FileUtil.rm_rf(this.self.toFile(), true);
        }
        if (this.temp != null) {
            FileUtil.rm(this.temp);
        }
    }

    public AppInfo getAppInfo() {
        return this.appInfo != null ? this.appInfo : (this.appInfo = this.getGeneralInfo(this.self));
    }

    public boolean hasFormula() {
        return this.hasFormula;
    }

    public ExcelReader parseFormula() {
        if (!this.hasFormula()) {
            return this;
        }
        Path calcPath = this.self.resolve("xl/calcChain.xml");
        long[][] calcArray = this.parseCalcChain(calcPath, this.sheets[this.sheets.length - 1].getIndex());
        if (calcArray == null) {
            return this;
        }
        for (int i = 0; i < this.sheets.length; ++i) {
            int n = this.sheets[i].getIndex();
            if (calcArray[n - 1] == null) continue;
            if (!(this.sheets[i] instanceof CalcSheet)) {
                this.sheets[i] = this.sheets[i].asCalcSheet();
            }
            if (!(this.sheets[i] instanceof XMLCalcSheet)) continue;
            ((XMLCalcSheet)this.sheets[i]).setCalc(calcArray[n - 1]);
        }
        return this;
    }

    public ExcelReader copyOnMergeCells() {
        for (int i = 0; i < this.sheets.length; ++i) {
            if (this.sheets[i] instanceof MergeSheet) continue;
            this.sheets[i] = this.sheets[i].asMergeSheet();
        }
        return this;
    }

    private ExcelReader(Path path, int bufferSize, int cacheSize, int option) throws IOException {
        Path s;
        Document document;
        Path tmp = FileUtil.mktmp("eec+");
        LOGGER.debug("Unzip file to\uff1a{}", (Object)tmp);
        ZipUtil.unzip(Files.newInputStream(path, new OpenOption[0]), tmp);
        LOGGER.debug("Finished decompress. start to check the file integrity.");
        try {
            this.appInfo = this.getGeneralInfo(tmp);
        }
        catch (Exception e) {
            FileUtil.rm_rf(tmp.toFile(), true);
            throw e;
        }
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(Files.newInputStream(tmp.resolve("xl/_rels/workbook.xml.rels"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            FileUtil.rm_rf(tmp.toFile(), true);
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/_rels/workbook.xml.rels]");
        }
        List list = document.getRootElement().elements();
        Relationship[] rels = new Relationship[list.size()];
        int i = 0;
        for (Element e : list) {
            rels[i++] = new Relationship(e.attributeValue("Id"), e.attributeValue("Target"), e.attributeValue("Type"));
        }
        RelManager relManager = RelManager.of(rels);
        try {
            document = reader.read(Files.newInputStream(tmp.resolve("xl/workbook.xml"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            FileUtil.rm_rf(tmp.toFile(), true);
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/workbook.xml]");
        }
        Element root = document.getRootElement();
        Namespace ns = root.getNamespaceForPrefix("r");
        Path ss = tmp.resolve("xl/sharedStrings.xml");
        if (FileUtil.exists(ss)) {
            this.sst = new SharedStrings(ss, bufferSize, cacheSize).load();
        }
        if (!FileUtil.exists(s = tmp.resolve("xl/styles.xml"))) {
            FileUtil.rm_rf(tmp.toFile(), true);
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/styles.xml]");
        }
        Styles styles = Styles.load(s);
        this.option = option;
        this.hasFormula = FileUtil.exists(tmp.resolve("xl/calcChain.xml"));
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        Iterator sheetIter = root.element("sheets").elementIterator();
        while (sheetIter.hasNext()) {
            Element e = (Element)sheetIter.next();
            XMLSheet sheet = this.sheetFactory(option);
            sheet.setName(e.attributeValue("name"));
            sheet.setIndex(Integer.parseInt(e.attributeValue("sheetId")));
            String state = e.attributeValue("state");
            sheet.setHidden("hidden".equals(state));
            Relationship r = relManager.getById(e.attributeValue(QName.get((String)"id", (Namespace)ns)));
            if (r == null) {
                FileUtil.rm_rf(tmp.toFile(), true);
                sheet.close();
                throw new ExcelReadException("The file format is incorrect or corrupted.");
            }
            sheet.setPath(tmp.resolve("xl").resolve(r.getTarget()));
            sheet.setSst(this.sst);
            sheet.setStyles(styles);
            sheets.add(sheet);
        }
        if (sheets.isEmpty()) {
            FileUtil.rm_rf(tmp.toFile(), true);
            throw new ExcelReadException("The file format is incorrect or corrupted. [There has no worksheet]");
        }
        sheets.sort(Comparator.comparingInt(Sheet::getIndex));
        Sheet[] sheets1 = new Sheet[sheets.size()];
        sheets.toArray(sheets1);
        this.sheets = sheets1;
        this.self = tmp;
        if ((option >> 1 & 1) == 1) {
            this.parseFormula();
        }
    }

    private static ExcelReader read(Path path, int bufferSize, int cacheSize, boolean rmSource, int option) throws IOException {
        ExcelReader er;
        if (!FileUtil.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        ExcelType type = ExcelReader.getType(path);
        LOGGER.debug("File type: {}", (Object)type);
        switch (type) {
            case XLSX: {
                er = new ExcelReader(path, bufferSize, cacheSize, option);
                break;
            }
            case XLS: {
                try {
                    Class<?> clazz = Class.forName("org.ttzero.excel.reader.BIFF8Reader");
                    Constructor<?> constructor = clazz.getDeclaredConstructor(Path.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    er = (ExcelReader)constructor.newInstance(path, bufferSize, cacheSize, option);
                    break;
                }
                catch (ClassNotFoundException e) {
                    Properties pom = IWorkbookWriter.pom();
                    throw new ExcelReadException("Can not load 'org.ttzero.excel.reader.BIFF8Reader'. Please add dependency [" + pom.getProperty("groupId") + ":eec-e3-support" + ":" + pom.getProperty("version") + "] to parse excel 97~2003.", e);
                }
                catch (InstantiationException | NoSuchMethodException e) {
                    Properties pom = IWorkbookWriter.pom();
                    throw new ExcelReadException("It may be an exception caused by eec-e3-support version error. Please add dependency [" + pom.getProperty("groupId") + ":eec-e3-support" + ":" + pom.getProperty("version") + "]", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ExcelReadException("Read excel failed.", e);
                }
            }
            default: {
                throw new ExcelReadException("Unknown file type.");
            }
        }
        er.type = type;
        if (rmSource) {
            er.temp = path;
        }
        return er;
    }

    private XMLSheet sheetFactory(int option) {
        XMLSheet sheet;
        switch (option) {
            case 0: {
                sheet = new XMLSheet();
                break;
            }
            case 2: {
                sheet = this.hasFormula() ? new XMLCalcSheet() : new XMLSheet();
                break;
            }
            case 4: {
                sheet = new XMLMergeSheet();
                break;
            }
            default: {
                sheet = new XMLSheet();
            }
        }
        return sheet;
    }

    private static ExcelType getType(Path path) {
        ExcelType type;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            byte[] bytes = new byte[8];
            int len = is.read(bytes);
            type = ExcelReader.typeOfStream(bytes, len);
        }
        catch (IOException e) {
            type = ExcelType.UNKNOWN;
        }
        return type;
    }

    private static ExcelType typeOfStream(byte[] bytes, int size) {
        ExcelType excelType = ExcelType.UNKNOWN;
        int length = Math.min(bytes.length, size);
        if (length < 4) {
            return excelType;
        }
        int type = bytes[0] & 0xFF;
        type += (bytes[1] & 0xFF) << 8;
        type += (bytes[2] & 0xFF) << 16;
        int zip = 67324752;
        int b1 = -535703600;
        int b2 = -518344287;
        if ((type += (bytes[3] & 0xFF) << 24) == zip) {
            excelType = ExcelType.XLSX;
        } else if (type == b1 && length >= 8) {
            type = bytes[4] & 0xFF;
            type += (bytes[5] & 0xFF) << 8;
            type += (bytes[6] & 0xFF) << 16;
            if ((type += (bytes[7] & 0xFF) << 24) == b2) {
                excelType = ExcelType.XLS;
            }
        }
        return excelType;
    }

    protected AppInfo getGeneralInfo(Path tmp) {
        Document document;
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(Files.newInputStream(tmp.resolve("docProps/app.xml"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [docProps/app.xml]");
        }
        Element root = document.getRootElement();
        App app = new App();
        app.setCompany(root.elementText("Company"));
        app.setApplication(root.elementText("Application"));
        app.setAppVersion(root.elementText("AppVersion"));
        try {
            document = reader.read(Files.newInputStream(tmp.resolve("docProps/core.xml"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [docProps/core.xml]");
        }
        root = document.getRootElement();
        Core core = new Core();
        Class<Core> clazz = Core.class;
        TopNS topNS = clazz.getAnnotation(TopNS.class);
        String[] prefixs = topNS.prefix();
        String[] urls = topNS.uri();
        Field[] fields = clazz.getDeclaredFields();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        for (Field f : fields) {
            NS ns = f.getAnnotation(NS.class);
            if (ns == null) continue;
            f.setAccessible(true);
            int nsIndex = StringUtil.indexOf(prefixs, ns.value());
            if (nsIndex < 0) continue;
            Namespace namespace = new Namespace(ns.value(), urls[nsIndex]);
            Class<?> type = f.getType();
            String v = root.elementText(new QName(f.getName(), namespace));
            if (StringUtil.isEmpty(v)) continue;
            if (type == String.class) {
                try {
                    f.set(core, v);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("Set field ({}) error.", (Object)f);
                }
                continue;
            }
            if (type != Date.class) continue;
            try {
                f.set(core, format.parse(v));
            }
            catch (IllegalAccessException | ParseException e) {
                LOGGER.warn("Set field ({}) error.", (Object)f);
            }
        }
        return new AppInfo(app, core);
    }

    private long[][] parseCalcChain(Path path, int n) {
        Element calcChain;
        try {
            SAXReader reader = new SAXReader();
            calcChain = reader.read(Files.newInputStream(path, new OpenOption[0])).getRootElement();
        }
        catch (IOException | DocumentException e) {
            LOGGER.warn("Part of `calcChain` has be damaged, It will be ignore all formulas.");
            return null;
        }
        Iterator ite = calcChain.elementIterator();
        int i = 1;
        long[][] array = new long[n][];
        int[] indices = new int[n];
        while (ite.hasNext()) {
            Element e = (Element)ite.next();
            String si = e.attributeValue("i");
            String r = e.attributeValue("r");
            if (StringUtil.isNotEmpty(si)) {
                i = SharedStrings.toInt(si.toCharArray(), 0, si.length());
            }
            if (!StringUtil.isNotEmpty(r)) continue;
            long[] sub = array[i - 1];
            if (sub == null) {
                array[i - 1] = sub = new long[10];
            }
            int n2 = i - 1;
            indices[n2] = indices[n2] + 1;
            if (indices[n2] > sub.length) {
                long[] _sub = new long[sub.length << 1];
                System.arraycopy(sub, 0, _sub, 0, sub.length);
                sub = _sub;
                array[i - 1] = _sub;
            }
            sub[indices[i - 1] - 1] = ExcelReader.cellRangeToLong(r);
        }
        for (i = 0; i < n; ++i) {
            if (indices[i] > 0) {
                long[] a = Arrays.copyOf(array[i], indices[i]);
                Arrays.sort(a);
                array[i] = a;
                continue;
            }
            array[i] = null;
        }
        return array;
    }

    static long cellRangeToLong(String r) {
        char[] values = r.toCharArray();
        long v = 0L;
        int n = 0;
        for (char value : values) {
            if (value >= 'A' && value <= 'Z') {
                v = v * 26L + (long)value - 65L + 1L;
                continue;
            }
            if (value >= 'a' && value <= 'z') {
                v = v * 26L + (long)value - 97L + 1L;
                continue;
            }
            if (value >= '0' && value <= '9') {
                n = n * 10 + value - 48;
                continue;
            }
            throw new ExcelReadException("Column mark out of range: " + r);
        }
        return v & 0x7FFFL | (long)n << 16;
    }
}

