/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.IgnoreImport;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.manager.Const;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

class HeaderRow
extends Row {
    private String[] names;
    private Class<?> clazz;
    private Field[] fields;
    private Method[] methods;
    private int[] columns;
    private Class<?>[] fieldClazz;
    private Object t;
    private Map<String, Integer> mapping;

    private HeaderRow() {
    }

    static HeaderRow with(Row row) {
        int i;
        HeaderRow hr = new HeaderRow();
        hr.names = new String[row.lc];
        hr.mapping = new HashMap<String, Integer>();
        for (i = row.fc; i < row.lc; ++i) {
            hr.names[i] = row.getString(i);
            hr.mapping.put(hr.names[i], i);
        }
        hr.fc = row.fc;
        hr.lc = row.lc;
        hr.index = row.index;
        hr.cells = new Cell[hr.names.length];
        for (i = 0; i < row.fc; ++i) {
            hr.cells[i] = new Cell();
        }
        for (i = row.fc; i < row.lc; ++i) {
            Cell cell = new Cell();
            cell.setSv(hr.names[i]);
            hr.cells[i] = cell;
        }
        return hr;
    }

    final boolean is(Class<?> clazz) {
        return this.clazz != null && this.clazz == clazz;
    }

    final HeaderRow setClass(Class<?> clazz) {
        int i;
        this.clazz = clazz;
        Field[] declaredFields = ReflectUtil.listDeclaredFields(clazz);
        Method[] writeMethods = null;
        try {
            writeMethods = ReflectUtil.listWriteMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null);
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get [" + clazz + "] read declared failed.", (Throwable)e);
        }
        LinkedHashMap<String, Method> tmp = new LinkedHashMap<String, Method>();
        int writeLength = this.methodMapping(clazz, writeMethods, tmp);
        this.methods = new Method[declaredFields.length + writeLength];
        int[] index = new int[declaredFields.length];
        int count = 0;
        for (i = 0; i < declaredFields.length; ++i) {
            IgnoreImport nit;
            int n;
            Field f = declaredFields[i];
            f.setAccessible(true);
            String gs = f.getName();
            Method method2 = (Method)tmp.get(gs);
            if (method2 != null) {
                if (method2.getAnnotation(IgnoreImport.class) != null) {
                    declaredFields[i] = null;
                    continue;
                }
                method2.setAccessible(true);
                this.methods[i] = method2;
                ExcelColumn mec = method2.getAnnotation(ExcelColumn.class);
                if (mec != null && StringUtil.isNotEmpty(mec.value())) {
                    n = this.check(mec.value(), gs);
                    if (n == -1) {
                        declaredFields[i] = null;
                        continue;
                    }
                    index[i] = n;
                    ++count;
                    continue;
                }
            }
            if ((nit = f.getAnnotation(IgnoreImport.class)) != null) {
                declaredFields[i] = null;
                continue;
            }
            ExcelColumn ec = f.getAnnotation(ExcelColumn.class);
            if (ec != null && StringUtil.isNotEmpty(ec.value())) {
                n = this.check(ec.value(), gs);
                if (n == -1) {
                    declaredFields[i] = null;
                    continue;
                }
            } else if (ec != null || this.methods[i] != null) {
                String name = f.getName();
                n = this.getIndex(name);
                if (n == -1 && (n = this.getIndex(StringUtil.toPascalCase(name))) == -1) {
                    declaredFields[i] = null;
                    continue;
                }
            } else {
                declaredFields[i] = null;
                continue;
            }
            index[i] = n;
            ++count;
        }
        if (writeLength > 0) {
            System.arraycopy(writeMethods, 0, this.methods, declaredFields.length, writeLength);
            count += writeLength;
        }
        this.fields = new Field[count];
        this.columns = new int[count];
        this.fieldClazz = new Class[count];
        int j = 0;
        for (i = 0; i < declaredFields.length; ++i) {
            if (declaredFields[i] == null) continue;
            this.fields[j] = declaredFields[i];
            this.columns[j] = index[i];
            this.methods[j] = this.methods[i];
            this.fieldClazz[j] = this.methods[i] != null ? this.methods[i].getParameterTypes()[0] : declaredFields[i].getType();
            ++j;
        }
        return this;
    }

    private int methodMapping(Class<?> clazz, Method[] writeMethods, Map<String, Method> tmp) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            Method[] allMethods = clazz.getMethods();
            Method[] mergedMethods = new Method[propertyDescriptors.length];
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                Method method = propertyDescriptors[i].getWriteMethod();
                if (method == null) continue;
                int index = ReflectUtil.indexOf(allMethods, method);
                mergedMethods[i] = index >= 0 ? allMethods[index] : method;
            }
            return ReflectUtil.mapping(writeMethods, tmp, propertyDescriptors, mergedMethods);
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get " + clazz + " property descriptor failed.");
            return 0;
        }
    }

    private int check(String first, String second) {
        int n = this.getIndex(first);
        if (n == -1) {
            n = this.getIndex(second);
        }
        if (n == -1) {
            this.LOGGER.warn(this.clazz + " field [" + first + "] can't find in header" + Arrays.toString(this.names));
        }
        return n;
    }

    final HeaderRow setClassOnce(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        this.setClass(clazz);
        this.t = clazz.newInstance();
        return this;
    }

    final Field[] getFields() {
        return this.fields;
    }

    final int[] getColumns() {
        return this.columns;
    }

    final Class<?>[] getFieldClazz() {
        return this.fieldClazz;
    }

    final <T> T getT() {
        return (T)this.t;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public CellType getCellType(int columnIndex) {
        return CellType.STRING;
    }

    public String get(int columnIndex) {
        this.rangeCheck(columnIndex);
        return this.names[columnIndex];
    }

    public int getIndex(String columnName) {
        Integer index = this.mapping.get(columnName);
        return index != null ? index : -1;
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(" | ");
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (this.names[i] == null) {
            ++i;
        }
        char[] chars = new char[10];
        Arrays.fill(chars, 0, chars.length, '-');
        int j = i;
        while (i < this.names.length) {
            joiner.add(this.names[i]);
            int n = this.simpleTestLength(this.names[i]) + (j == i || i == this.names.length - 1 ? 1 : 2);
            if (n > chars.length) {
                chars = new char[n];
                Arrays.fill(chars, 0, n, '-');
            } else {
                Arrays.fill(chars, 0, n, '-');
            }
            if (this.fieldClazz != null) {
                Class<?> c = this.fieldClazz[i];
                if (IWorksheetWriter.isDate(c) || IWorksheetWriter.isLocalDate(c) || IWorksheetWriter.isLocalDateTime(c) || IWorksheetWriter.isLocalTime(c) || IWorksheetWriter.isChar(c) || IWorksheetWriter.isBool(c)) {
                    chars[n - 1] = 58;
                    chars[0] = 58;
                } else if (IWorksheetWriter.isInt(c)) {
                    chars[n - 1] = 58;
                }
            }
            buf.append(chars, 0, n).append('|');
            ++i;
        }
        buf.insert(0, joiner.toString() + Const.lineSeparator);
        return buf.toString();
    }

    int simpleTestLength(String name) {
        if (name == null) {
            return 4;
        }
        char[] chars = name.toCharArray();
        double d = 0.0;
        for (char c : chars) {
            if (c < '\u0080') {
                d += 1.0;
                continue;
            }
            d += 1.75;
        }
        return (int)d;
    }

    void put(Row row, Object t) throws IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.methods[i] != null) {
                this.methodPut(i, row, t);
                continue;
            }
            this.fieldPut(i, row, t);
        }
    }

    private void fieldPut(int i, Row row, Object t) throws IllegalAccessException {
        int c = this.columns[i];
        if (this.fieldClazz[i] == String.class) {
            this.fields[i].set(t, row.getString(c));
        } else if (this.fieldClazz[i] == Integer.class || this.fieldClazz[i] == Integer.TYPE) {
            this.fields[i].set(t, row.getInt(c));
        } else if (this.fieldClazz[i] == Long.class || this.fieldClazz[i] == Long.TYPE) {
            this.fields[i].set(t, row.getLong(c));
        } else if (this.fieldClazz[i] == java.util.Date.class || this.fieldClazz[i] == Date.class) {
            this.fields[i].set(t, row.getDate(c));
        } else if (this.fieldClazz[i] == Timestamp.class) {
            this.fields[i].set(t, row.getTimestamp(c));
        } else if (this.fieldClazz[i] == Double.class || this.fieldClazz[i] == Double.TYPE) {
            this.fields[i].set(t, row.getDouble(c));
        } else if (this.fieldClazz[i] == Float.class || this.fieldClazz[i] == Float.TYPE) {
            this.fields[i].set(t, Float.valueOf(row.getFloat(c)));
        } else if (this.fieldClazz[i] == Boolean.class || this.fieldClazz[i] == Boolean.TYPE) {
            this.fields[i].set(t, row.getBoolean(c));
        } else if (this.fieldClazz[i] == BigDecimal.class) {
            this.fields[i].set(t, row.getDecimal(c));
        } else if (this.fieldClazz[i] == Time.class) {
            this.fields[i].set(t, row.getTime(c));
        } else if (this.fieldClazz[i] == LocalDateTime.class) {
            this.fields[i].set(t, row.getLocalDateTime(c));
        } else if (this.fieldClazz[i] == LocalDate.class) {
            this.fields[i].set(t, row.getLocalDate(c));
        } else if (this.fieldClazz[i] == LocalTime.class) {
            this.fields[i].set(t, row.getLocalTime(c));
        } else if (this.fieldClazz[i] == Character.class || this.fieldClazz[i] == Character.TYPE) {
            this.fields[i].set(t, Character.valueOf(row.getChar(c)));
        } else if (this.fieldClazz[i] == Byte.class || this.fieldClazz[i] == Byte.TYPE) {
            this.fields[i].set(t, row.getByte(c));
        } else if (this.fieldClazz[i] == Short.class || this.fieldClazz[i] == Short.TYPE) {
            this.fields[i].set(t, row.getShort(c));
        }
    }

    private void methodPut(int i, Row row, Object t) throws IllegalAccessException, InvocationTargetException {
        int c = this.columns[i];
        if (this.fieldClazz[i] == String.class) {
            this.methods[i].invoke(t, row.getString(c));
        } else if (this.fieldClazz[i] == Integer.class || this.fieldClazz[i] == Integer.TYPE) {
            this.methods[i].invoke(t, row.getInt(c));
        } else if (this.fieldClazz[i] == Long.class || this.fieldClazz[i] == Long.TYPE) {
            this.methods[i].invoke(t, row.getLong(c));
        } else if (this.fieldClazz[i] == java.util.Date.class || this.fieldClazz[i] == Date.class) {
            this.methods[i].invoke(t, row.getDate(c));
        } else if (this.fieldClazz[i] == Timestamp.class) {
            this.methods[i].invoke(t, row.getTimestamp(c));
        } else if (this.fieldClazz[i] == Double.class || this.fieldClazz[i] == Double.TYPE) {
            this.methods[i].invoke(t, row.getDouble(c));
        } else if (this.fieldClazz[i] == Float.class || this.fieldClazz[i] == Float.TYPE) {
            this.methods[i].invoke(t, Float.valueOf(row.getFloat(c)));
        } else if (this.fieldClazz[i] == Boolean.class || this.fieldClazz[i] == Boolean.TYPE) {
            this.methods[i].invoke(t, row.getBoolean(c));
        } else if (this.fieldClazz[i] == BigDecimal.class) {
            this.methods[i].invoke(t, row.getDecimal(c));
        } else if (this.fieldClazz[i] == Time.class) {
            this.methods[i].invoke(t, row.getTime(c));
        } else if (this.fieldClazz[i] == LocalDateTime.class) {
            this.methods[i].invoke(t, row.getLocalDateTime(c));
        } else if (this.fieldClazz[i] == LocalDate.class) {
            this.methods[i].invoke(t, row.getLocalDate(c));
        } else if (this.fieldClazz[i] == LocalTime.class) {
            this.methods[i].invoke(t, row.getLocalTime(c));
        } else if (this.fieldClazz[i] == Character.class || this.fieldClazz[i] == Character.TYPE) {
            this.methods[i].invoke(t, Character.valueOf(row.getChar(c)));
        } else if (this.fieldClazz[i] == Byte.class || this.fieldClazz[i] == Byte.TYPE) {
            this.methods[i].invoke(t, row.getByte(c));
        } else if (this.fieldClazz[i] == Short.class || this.fieldClazz[i] == Short.TYPE) {
            this.methods[i].invoke(t, row.getShort(c));
        }
    }
}

