/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.manager.Const;

public class WaterMark {
    private Path imagePath;
    private boolean temp;

    public WaterMark(String word) {
        this.imagePath = this.createWaterMark(word);
    }

    public WaterMark(Path imagePath) {
        this.imagePath = imagePath;
    }

    public WaterMark(InputStream inputStream) throws IOException {
        this.imagePath = this.createTemp();
        Files.copy(inputStream, this.imagePath, StandardCopyOption.REPLACE_EXISTING);
    }

    public Path get() {
        return this.imagePath;
    }

    public static WaterMark of(String mark) {
        return new WaterMark(mark);
    }

    public static WaterMark of(Path path) {
        return new WaterMark(path);
    }

    public static WaterMark of(InputStream is) throws IOException {
        return new WaterMark(is);
    }

    private Path createWaterMark(String watermark) {
        try {
            Path temp = this.createTemp();
            int width = 510;
            int height = 300;
            BufferedImage bi = new BufferedImage(width, height, 1);
            int minx = bi.getMinX();
            int miny = bi.getMinY();
            for (int i = minx; i < width; ++i) {
                for (int j = miny; j < height; ++j) {
                    bi.setRGB(i, j, 0xFFFFFF);
                }
            }
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(new Color(200, 200, 200));
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setFont(new Font("\u534e\u6587\u7ec6\u9ed1", 2, 50));
            g2d.rotate(Math.toRadians(-10.0));
            for (int i = 1; i < 10; ++i) {
                g2d.drawString(watermark, 0, 60 * i);
            }
            g2d.setComposite(AlphaComposite.getInstance(3));
            g2d.dispose();
            ImageIO.write((RenderedImage)bi, "png", temp.toFile());
            return temp;
        }
        catch (IOException e) {
            throw new ExcelWriteException("Create Water Mark error.", e);
        }
    }

    private Path createTemp() throws IOException {
        this.temp = true;
        return Files.createTempFile("waterMark", "png", new FileAttribute[0]);
    }

    public boolean delete() {
        if (this.imagePath != null && this.temp) {
            try {
                Files.deleteIfExists(this.imagePath);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public String getSuffix() {
        String name;
        int n;
        String suffix = null;
        if (this.temp) {
            suffix = ".png";
        } else if (this.imagePath != null && (n = (name = this.imagePath.getFileName().toString()).lastIndexOf(46)) > 0) {
            suffix = name.substring(n);
        }
        return suffix != null ? suffix : ".png";
    }

    public String getContentType() {
        Field[] fields;
        String suffix = this.getSuffix().substring(1).toUpperCase();
        for (Field f : fields = Const.ContentType.class.getDeclaredFields()) {
            if (!f.getName().equals(suffix)) continue;
            try {
                return f.get(null).toString();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return "image/png";
    }
}

