/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.ttzero.excel.reader.Cache;

public class FixSizeLRUCache<K, V>
implements Cache<K, V> {
    private Node<E<K, V>> first;
    private Node<E<K, V>> last;
    private int limit;
    private int size;
    private Map<K, Node<E<K, V>>> table;

    public static <K, V> FixSizeLRUCache<K, V> create() {
        return new FixSizeLRUCache<K, V>();
    }

    public static <K, V> FixSizeLRUCache<K, V> create(int size) {
        return new FixSizeLRUCache<K, V>(size);
    }

    private FixSizeLRUCache() {
        this(512);
    }

    private FixSizeLRUCache(int limit) {
        this.limit = limit;
        this.table = new HashMap<K, Node<E<K, V>>>(Math.round((float)limit * 1.25f));
    }

    @Override
    public V get(K k) {
        Node<E<K, E<K, V>>> o;
        if (this.size == 0 || (o = this.table.get(k)) == null) {
            return null;
        }
        if (o != this.first) {
            if (((Node)o).next != null) {
                ((Node)o).prev.next = ((Node)o).next;
                ((Node)o).next.prev = ((Node)o).prev;
            } else {
                ((Node)o).prev.next = null;
            }
            ((Node)this.first).prev = (Node)o;
            ((Node)o).next = (Node)this.first;
            ((Node)o).prev = null;
            this.first = o;
        }
        return (V)((E)((Node)o).data).v;
    }

    @Override
    public void put(K k, V v) {
        Node<E<K, V>> o;
        if (this.size == 0 || (o = this.table.get(k)) == null) {
            Node<E<K, V>> f = this.first;
            Node newNode = new Node(new E(k, v), null, f);
            this.first = newNode;
            if (f == null) {
                this.last = newNode;
            } else {
                ((Node)f).prev = newNode;
            }
            this.table.put(k, newNode);
            if (this.size < this.limit) {
                ++this.size;
            } else {
                this.remove();
            }
        } else {
            ((E)((Node)o).data).v = v;
        }
    }

    @Override
    public V remove(K k) {
        Node<E<K, V>> o;
        if (this.size == 0 || (o = this.table.get(k)) == null) {
            return null;
        }
        this.table.remove(k);
        Node prev = ((Node)o).prev;
        Node next = ((Node)o).next;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            ((Node)o).prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            ((Node)o).next = null;
        }
        if (--this.size == 0) {
            this.first = null;
        }
        Object v = ((E)((Node)o).data).v;
        ((Node)o).data = null;
        return (V)v;
    }

    protected E<K, V> remove() {
        Node<E<K, V>> l = this.last;
        if (l == null) {
            return null;
        }
        E data = (E)((Node)l).data;
        this.last = ((Node)this.last).prev;
        if (this.last != null) {
            ((Node)this.last).next = null;
        }
        this.table.remove(data.k);
        if (--this.size == 0) {
            this.first = null;
        }
        return data;
    }

    @Override
    public void clear() {
        this.first = null;
        this.last = null;
        this.table.clear();
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        return new CacheIterator(this.first);
    }

    @Override
    public void forEach(Consumer<? super Cache.Entry<K, V>> action) {
        Node f = this.first;
        while (f != null) {
            action.accept((Cache.Entry<K, V>)f.data);
            f = f.next;
        }
    }

    private class CacheIterator
    implements Iterator<Cache.Entry<K, V>> {
        private Node<E<K, V>> first;

        private CacheIterator(Node<E<K, V>> first) {
            this.first = first;
        }

        @Override
        public boolean hasNext() {
            return this.first != null;
        }

        @Override
        public E<K, V> next() {
            E e = (E)this.first.data;
            this.first = this.first.next;
            return e;
        }
    }

    private static class Node<V> {
        private V data;
        private Node<V> prev;
        private Node<V> next;

        private Node(V data, Node<V> prev, Node<V> next) {
            this.data = data;
            this.prev = prev;
            this.next = next;
        }
    }

    private static class E<K, V>
    implements Cache.Entry<K, V> {
        private K k;
        private V v;

        private E(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }
    }
}

