/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.reader.Cache;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.FixSizeLRUCache;
import org.ttzero.excel.reader.IndexSharedStringTable;
import org.ttzero.excel.reader.Tester;
import org.ttzero.excel.util.FileUtil;

public class SharedStrings
implements Closeable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Path sstPath;
    static final int MAXIMUM_CAPACITY = 0x100000;
    private String[] forward;
    private String[] backward;
    private int page = 512;
    private int max = -1;
    private int vt = 0;
    private int offsetM = 0;
    private int offset_forward = -1;
    private int offset_backward = -1;
    private int limit_forward;
    private int limit_backward;
    private Tester tester = null;
    private Cache<Integer, String> hot;
    private int hotSize;
    private BufferedReader reader;
    private char[] cb;
    private int offset;
    private StringBuilder escapeBuf;
    private IndexSharedStringTable sst;
    private int status;
    private int total;
    private int total_forward;
    private int total_backward;
    private int total_hot;
    private int total_sst;

    SharedStrings(String[] data) {
        this.max = data.length;
        this.offset_forward = 0;
        this.status = 1;
        if (this.max <= this.page) {
            this.forward = new String[this.max];
            System.arraycopy(data, this.offset_forward, this.forward, 0, this.max);
            this.limit_forward = this.max;
        } else {
            if (this.max > this.page << 1) {
                this.page = this.max >> 1;
            }
            this.status <<= 1;
            this.forward = new String[this.page];
            this.limit_forward = this.page;
            System.arraycopy(data, this.offset_forward, this.forward, 0, this.limit_forward);
            this.offset_backward = this.page;
            this.limit_backward = this.max - this.page;
            this.backward = new String[this.limit_backward];
            System.arraycopy(data, this.offset_backward, this.backward, 0, this.limit_backward);
        }
    }

    SharedStrings(Path sstPath, int cacheSize, int hotSize) {
        this.sstPath = sstPath;
        if (cacheSize > 0) {
            this.page = SharedStrings.tableSizeFor(cacheSize);
        }
        this.hotSize = hotSize;
    }

    SharedStrings(IndexSharedStringTable sst, int cacheSize, int hotSize) throws IOException {
        this.sst = sst;
        this.max = sst.size();
        if (cacheSize > 0) {
            this.page = SharedStrings.tableSizeFor(cacheSize);
        }
        this.hotSize = hotSize;
        this.init();
        this.offset_forward = 0;
        this.limit_forward = sst.get(0, this.forward);
    }

    public int size() {
        return this.max;
    }

    static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 64 ? 64 : (n >= 0x100000 ? 0x100000 : n + 1);
    }

    SharedStrings load() throws IOException {
        if (!FileUtil.exists(this.sstPath)) {
            this.max = 0;
            return this;
        }
        this.max = this.uniqueCount();
        this.LOGGER.debug("Size of SharedString: {}", (Object)this.max);
        this.init();
        this.escapeBuf = new StringBuilder();
        return this;
    }

    private void init() throws IOException {
        this.status = 1;
        if (this.max < 0 || this.max > this.page << 1) {
            this.status <<= 2;
            this.forward = new String[this.page];
            this.backward = new String[this.page];
            this.tester = new Tester.FixBinaryTester(this.max > 65536 ? 65536 : this.max);
            this.hot = this.hotSize > 0 ? FixSizeLRUCache.create(this.hotSize) : FixSizeLRUCache.create();
            if (this.sst == null) {
                this.sst = new IndexSharedStringTable();
                this.sst.setShortSectorSize(Integer.numberOfTrailingZeros(this.page));
            }
        } else if (this.max > this.page) {
            this.status <<= 1;
            this.forward = new String[this.page];
            this.backward = new String[this.page];
        } else {
            this.forward = new String[this.max];
        }
    }

    private int uniqueCount() throws IOException {
        int end;
        int i;
        int off = -1;
        this.reader = Files.newBufferedReader(this.sstPath);
        this.cb = new char[4096];
        this.offset = 0;
        this.offset = this.reader.read(this.cb);
        int len = this.offset - 4;
        for (i = 0; i < len && (this.cb[i] != '<' || this.cb[i + 1] != 's' || this.cb[i + 2] != 'i' || this.cb[i + 3] != '>'); ++i) {
        }
        if (i == len) {
            return 0;
        }
        String line = new String(this.cb, 0, i);
        String uniqueCount = " uniqueCount=";
        int index = line.indexOf(uniqueCount);
        int n = end = index > 0 ? line.indexOf(34, index += uniqueCount.length() + 1) : -1;
        if (end > 0) {
            off = Integer.parseInt(line.substring(index, end));
        } else {
            String count = " count=";
            index = line.indexOf(count);
            int n2 = end = index > 0 ? line.indexOf(34, index += count.length() + 1) : -1;
            if (end > 0) {
                off = Integer.parseInt(line.substring(index, end));
            }
        }
        this.vt = i + 4;
        System.arraycopy(this.cb, this.vt, this.cb, 0, this.offset -= this.vt);
        return off;
    }

    public String get(int index) {
        this.checkBound(index);
        ++this.total;
        if (this.offset_forward == -1) {
            this.offset_forward = index / this.page * this.page;
            if (this.vt < 0) {
                this.vt = 0;
            }
            this.loadXml();
        }
        String value = null;
        if (this.forwardRange(index)) {
            value = this.forward[index - this.offset_forward];
            ++this.total_forward;
            if (this.test(index)) {
                this.hot.put(index, value);
            }
            return value;
        }
        if (this.status == 1) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
        }
        if (this.backwardRange(index)) {
            value = this.backward[index - this.offset_backward];
            ++this.total_backward;
            if (this.test(index)) {
                this.hot.put(index, value);
            }
            return value;
        }
        if (this.status == 4) {
            value = this.hot.get(index);
        }
        if (value == null) {
            if (this.status == 2 && this.offset_backward > -1) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
            }
            System.arraycopy(this.forward, 0, this.backward, 0, this.limit_forward);
            this.offset_backward = this.offset_forward;
            this.limit_backward = this.limit_forward;
            this.offset_forward = index / this.page * this.page;
            this.forward[0] = null;
            if (this.status == 4 && index < this.sst.size()) {
                try {
                    this.limit_forward = this.sst.get(this.offset_forward, this.forward);
                }
                catch (IOException e) {
                    throw new ExcelWriteException(e);
                }
                ++this.total_sst;
            } else {
                this.loadXml();
                ++this.total_forward;
            }
            if (this.forward[0] == null) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
            }
            value = this.forward[index - this.offset_forward];
            if (this.test(index)) {
                this.hot.put(index, value);
            }
        } else {
            ++this.total_hot;
        }
        return value;
    }

    private boolean forwardRange(int index) {
        return this.offset_forward >= 0 && this.offset_forward <= index && this.offset_forward + this.limit_forward > index;
    }

    private boolean backwardRange(int index) {
        return this.offset_backward >= 0 && this.offset_backward <= index && this.offset_backward + this.limit_backward > index;
    }

    private void checkBound(int index) {
        if (index < 0 || this.max > -1 && this.max <= index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
        }
    }

    private boolean test(int index) {
        return this.status == 4 && this.tester.test(index);
    }

    private void loadXml() {
        int index = this.offset_forward / this.page;
        try {
            int n = index - this.offsetM;
            while (n-- >= 0) {
                this.readData();
            }
        }
        catch (IOException e) {
            throw new ExcelReadException(e);
        }
    }

    private int readData() throws IOException {
        int length;
        int n = 0;
        while ((length = this.reader.read(this.cb, this.offset, this.cb.length - this.offset)) > 0 || this.offset > 0) {
            int nChar = this.offset &= 0;
            int len0 = (length += this.offset) - 3;
            int len1 = len0 - 1;
            int[] t = this.findT(this.cb, nChar, length, len0, len1, n);
            nChar = t[0];
            this.limit_forward = n = t[1];
            if (nChar < length) {
                this.offset = length - nChar;
                System.arraycopy(this.cb, nChar, this.cb, 0, this.offset);
            }
            if (n == this.page) {
                ++this.offsetM;
                break;
            }
            if (length >= this.cb.length || nChar != length - 6) continue;
            if (this.max == -1) {
                this.max = this.offsetM * this.page + n;
            }
            ++this.offsetM;
            break;
        }
        return n;
    }

    private int[] findT(char[] cb, int nChar, int length, int len0, int len1, int n) throws IOException {
        while (nChar < length && n < this.page) {
            int cursor = nChar;
            int[] subT = this.subT(cb, nChar, len0, len1);
            int a = subT[0];
            if (a == -1) break;
            nChar = subT[1];
            String tmp = SharedStrings.unescape(this.escapeBuf, cb, a, nChar);
            nChar += 4;
            while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/')) {
                ++nChar;
            }
            if (nChar < len1 && cb[nChar + 2] == 's' && cb[nChar + 3] == 'i' && cb[nChar + 4] == '>') {
                this.forward[n++] = tmp;
                if (this.status == 4) {
                    this.sst.push(this.forward[n - 1]);
                }
                nChar += 5;
            } else {
                StringBuilder buf = new StringBuilder(tmp);
                int t = nChar;
                while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/' || cb[nChar + 2] != 's' || cb[nChar + 3] != 'i' || cb[nChar + 4] != '>')) {
                    ++nChar;
                }
                if (nChar >= len1) {
                    nChar = cursor;
                    break;
                }
                int end = nChar;
                nChar = t;
                while ((a = (subT = this.subT(cb, nChar, end, end))[0]) != -1) {
                    nChar = subT[1];
                    buf.append(SharedStrings.unescape(this.escapeBuf, cb, a, nChar));
                    nChar += 4;
                }
                this.forward[n++] = buf.toString();
                if (this.status == 4) {
                    this.sst.push(this.forward[n - 1]);
                }
            }
            if (n != this.page) continue;
            break;
        }
        return new int[]{nChar, n};
    }

    private int[] subT(char[] cb, int nChar, int len0, int len1) {
        while (nChar < len0 && (cb[nChar] != '<' || cb[nChar + 1] != 't' || cb[nChar + 2] != '>' && cb[nChar + 2] != ' ')) {
            ++nChar;
        }
        if (nChar >= len0) {
            return new int[]{-1};
        }
        int a = nChar += 3;
        if (cb[nChar - 1] == ' ') {
            while (nChar < len0 && cb[nChar++] != '>') {
            }
            if (nChar >= len0) {
                return new int[]{-1};
            }
            a = nChar;
        }
        while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/' || cb[nChar + 2] != 't' || cb[nChar + 3] != '>')) {
            ++nChar;
        }
        if (nChar >= len1) {
            return new int[]{-1};
        }
        return new int[]{a, nChar};
    }

    static String unescape(StringBuilder escapeBuf, char[] cb, int from, int to) {
        int idx_59;
        if (from == to) {
            return "";
        }
        int idx_38 = SharedStrings.indexOf(cb, '&', from);
        int n = idx_59 = idx_38 > -1 && idx_38 < to ? SharedStrings.indexOf(cb, ';', idx_38 + 1) : -1;
        if (idx_38 <= 0 || idx_38 >= idx_59 || idx_59 > to) {
            return new String(cb, from, to - from);
        }
        escapeBuf.delete(0, escapeBuf.length());
        do {
            escapeBuf.append(cb, from, idx_38 - from);
            if (cb[idx_38 + 1] == '#') {
                int n2 = SharedStrings.toInt(cb, idx_38 + 2, idx_59);
                escapeBuf.append((char)n2);
            } else {
                String name;
                switch (name = new String(cb, idx_38 + 1, idx_59 - idx_38 - 1)) {
                    case "lt": {
                        escapeBuf.append('<');
                        break;
                    }
                    case "gt": {
                        escapeBuf.append('>');
                        break;
                    }
                    case "amp": {
                        escapeBuf.append('&');
                        break;
                    }
                    case "quot": {
                        escapeBuf.append('\"');
                        break;
                    }
                    case "nbsp": {
                        escapeBuf.append(' ');
                        break;
                    }
                    default: {
                        escapeBuf.append(cb, idx_38, idx_59 - idx_38 + 1);
                    }
                }
            }
            from = ++idx_59;
            idx_38 = SharedStrings.indexOf(cb, '&', idx_59);
            int n3 = idx_59 = idx_38 > -1 && idx_38 < to ? SharedStrings.indexOf(cb, ';', idx_38 + 1) : -1;
        } while (idx_38 > -1 && idx_59 > idx_38 && idx_59 <= to);
        if (from < to) {
            escapeBuf.append(cb, from, to - from);
        }
        return escapeBuf.toString();
    }

    private static int indexOf(char[] cb, char c, int from) {
        while (from < cb.length) {
            if (cb[from] == c) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    static int toInt(char[] cb, int a, int b) {
        boolean _n = cb[a] == '-';
        if (_n) {
            // empty if block
        }
        int n = ++a;
        ++a;
        int n2 = cb[n] - 48;
        while (b > a) {
            n2 = n2 * 10 + cb[a++] - 48;
        }
        return _n ? -n2 : n2;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.LOGGER.debug("Count: {}\uff0c uniqueCount: {}\uff0c Repetition rate: {}", new Object[]{this.total, this.max, (this.total > 0 ? (double)(this.total - this.max) * 100.0 / (double)this.total : 0.0) + "%"});
            this.LOGGER.debug("Forward: {}, Backward: {}, SST: {}, Hot: {}, Tester: {Resize: {}, Size: {}}", new Object[]{this.total_forward, this.total_backward, this.total_sst, this.total_hot, this.tester != null ? this.tester.analysis() : 0, this.tester != null ? this.tester.size() : 0});
            this.reader.close();
        }
        this.cb = null;
        this.forward = null;
        this.backward = null;
        if (this.tester != null) {
            this.tester = null;
        }
        this.escapeBuf = null;
        if (this.sst != null) {
            this.sst.close();
        }
    }

    public String toString() {
        return "Count: " + (this.total <= 0 ? this.max : this.total) + "\uff0cUniqueCount: " + this.max;
    }
}

