/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.SharedStringTable;
import org.ttzero.excel.util.FileUtil;

public class IndexSharedStringTable
extends SharedStringTable {
    private final Path temp;
    private final SeekableByteChannel channel;
    private ByteBuffer buffer;
    private ByteBuffer readBuffer;
    private int ssst = 6;
    private int kSplit = Integer.MAX_VALUE >> this.ssst << this.ssst;
    private byte[] bytes;
    private final char[] chars = new char[1];
    private int index = -1;
    private byte status;
    private static final byte READ = 1;
    private static final byte WRITE = 0;

    IndexSharedStringTable() throws IOException {
        Path superPath = this.getTemp();
        this.temp = Files.createFile(Paths.get(superPath.toString() + ".idx", new String[0]), new FileAttribute[0]);
        this.channel = Files.newByteChannel(this.temp, StandardOpenOption.WRITE, StandardOpenOption.READ);
        this.buffer = ByteBuffer.allocate(2048);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.readBuffer = ByteBuffer.allocate(1024);
        this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    IndexSharedStringTable(Path path) throws IOException {
        super(Paths.get(path.toString().substring(0, path.toString().length() - 4), new String[0]));
        if (!FileUtil.exists(path)) {
            throw new IOException("The index path [" + path + "] not exists.");
        }
        this.temp = path;
        this.channel = Files.newByteChannel(this.temp, StandardOpenOption.WRITE, StandardOpenOption.READ);
        this.channel.position(this.channel.size());
        this.buffer = ByteBuffer.allocate(2048);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.readBuffer = ByteBuffer.allocate(1024);
        this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setShortSectorSize(int sssz) {
        if (sssz < 1) {
            throw new IllegalArgumentException("The short sector size must large than 1.");
        }
        if (sssz > 20) {
            throw new IllegalArgumentException("The short sector size must less than 20.");
        }
        this.ssst = sssz;
        this.kSplit = Integer.MAX_VALUE >> sssz << sssz;
    }

    @Override
    public int push(char c) throws IOException {
        this.putsIndex();
        return super.push(c);
    }

    @Override
    public int push(String key) throws IOException {
        this.putsIndex();
        return super.push(key);
    }

    public String get(int index) throws IOException {
        this.checkBound(index);
        boolean write = this.status == 0;
        if (write || index != this.index) {
            if (write) {
                super.mark();
                this.status = 1;
            }
            long position = this.getIndexPosition(index);
            this.readBuffer.clear();
            super.skip(position);
            int dist = super.read(this.readBuffer);
            if (dist < 0) {
                return null;
            }
            this.readBuffer.flip();
            this.skipTo(index);
        } else if (!IndexSharedStringTable.hasFullValue(this.readBuffer)) {
            this.readBuffer.compact();
            int dist = super.read(this.readBuffer);
            if (dist < 0) {
                return null;
            }
            this.readBuffer.flip();
        }
        if (IndexSharedStringTable.hasFullValue(this.readBuffer)) {
            this.index = index + 1;
            return this.parse(this.readBuffer);
        }
        return null;
    }

    public int get(int fromIndex, String[] array) throws IOException {
        this.checkBound(fromIndex);
        boolean write = this.status == 0;
        if (write || fromIndex != this.index) {
            if (write) {
                super.mark();
                this.status = 1;
            }
            long position = this.getIndexPosition(fromIndex);
            this.readBuffer.clear();
            super.skip(position);
            int dist = super.read(this.readBuffer);
            if (dist < 0) {
                return 0;
            }
            this.readBuffer.flip();
        }
        int i = 0;
        block0: while (true) {
            if (i == 0 && fromIndex != this.index) {
                this.skipTo(fromIndex);
            }
            while (IndexSharedStringTable.hasFullValue(this.readBuffer)) {
                array[i++] = this.parse(this.readBuffer);
                if (i < array.length) continue;
                break block0;
            }
            this.readBuffer.compact();
            int dist = super.read(this.readBuffer);
            if (dist < 0) break;
            this.readBuffer.flip();
        }
        this.index = fromIndex + i;
        return i;
    }

    private void flush() throws IOException {
        this.buffer.flip();
        if (this.buffer.hasRemaining()) {
            this.channel.write(this.buffer);
        }
        this.buffer.clear();
    }

    private void putsIndex() throws IOException {
        int size;
        if (this.status == 1) {
            this.status = 0;
            super.reset();
        }
        if (((size = this.size()) & this.kSplit) == size) {
            if (this.buffer.remaining() < 8) {
                this.flush();
            }
            this.buffer.putLong(super.position() - 4L);
        }
    }

    private void checkBound(int index) {
        int size = this.size();
        if (size <= index) {
            throw new ExcelWriteException("index: " + index + ", size: " + size);
        }
    }

    private long getIndexPosition(int keyIndex) throws IOException {
        long position = 0L;
        if (keyIndex < 1 << this.ssst) {
            return position;
        }
        long index_size = this.channel.size();
        if (index_size >> 3 > (long)(keyIndex >> this.ssst)) {
            this.flush();
            long pos = this.channel.position();
            this.channel.position(keyIndex >> this.ssst << 3);
            this.channel.read(this.buffer);
            this.buffer.flip();
            position = this.buffer.getLong();
            this.channel.position(pos);
            this.buffer.clear();
        } else {
            int _pos = this.buffer.position();
            this.buffer.flip();
            if (this.buffer.hasRemaining()) {
                this.buffer.position((int)((long)(keyIndex >> this.ssst) - (index_size >> 3)) << 3);
                position = this.buffer.getLong();
            }
            this.buffer.position(_pos);
            this.buffer.limit(this.buffer.capacity());
        }
        return position;
    }

    private String parse(ByteBuffer readBuffer) {
        int n = readBuffer.getInt();
        if (this.bytes == null || this.bytes.length < n) {
            this.bytes = new byte[Math.max(n, 128)];
        }
        if (n < 0) {
            char c = (char)(~n);
            if (c < '\uffff') {
                this.chars[0] = c;
                return new String(this.chars);
            }
            return "";
        }
        readBuffer.get(this.bytes, 0, n);
        return new String(this.bytes, 0, n, StandardCharsets.UTF_8);
    }

    private void skipTo(int index) {
        for (int i = index >> this.ssst << this.ssst; i < index; ++i) {
            int n = this.readBuffer.getInt();
            this.readBuffer.position(this.readBuffer.position() + 2 + n);
        }
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        this.readBuffer = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.shouldDelete) {
            FileUtil.rm(this.temp);
        }
        super.close();
    }
}

