/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Objects;
import org.dom4j.Element;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.ColorParseException;
import org.ttzero.excel.entity.style.FontParseException;
import org.ttzero.excel.manager.Const;
import org.ttzero.excel.util.StringUtil;

public class Font
implements Cloneable {
    private int style;
    private int size;
    private String name;
    private Color color;
    private String scheme;
    private int charset;
    private int family;

    private Font() {
    }

    public Font(String name, int size) {
        this(name, size, 0, null);
    }

    public Font(String name, int size, Color color) {
        this(name, size, 0, color);
    }

    public Font(String name, int size, int style, Color color) {
        this.style = style;
        this.size = size;
        this.name = name;
        this.color = color;
    }

    public static Font parse(String fontString) throws FontParseException {
        if (fontString.isEmpty()) {
            throw new NullPointerException("Font string empty");
        }
        String s = fontString.trim();
        int i1 = s.indexOf(39);
        if (i1 >= 0) {
            String mark;
            int i2;
            String sub;
            do {
                if ((i2 = s.indexOf(39, i1 + 1)) != -1) continue;
                throw new FontParseException("Miss end char \"'\"");
            } while ((i1 = (s = s.replace(sub = s.substring(i1, i2 + 1), mark = sub.substring(1, sub.length() - 1).replace(' ', '+'))).indexOf(39, i2)) >= 0);
        }
        String[] values = s.indexOf(95) >= 0 ? s.split("_") : s.split(" ");
        Font font = new Font();
        boolean beforeSize = true;
        for (int i = 0; i < values.length; ++i) {
            String temp = values[i].trim();
            Integer size = null;
            if (beforeSize) {
                try {
                    size = Integer.valueOf(temp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (size == null) {
                    String v;
                    int n = temp.indexOf(43);
                    if (n > 0) {
                        char[] cs = new char[temp.length() - 1];
                        temp.getChars(0, n, cs, 0);
                        temp.getChars(n + 1, temp.length(), cs, n);
                        if (cs[n] >= 'a' && cs[n] <= 'z') {
                            int n2 = n;
                            cs[n2] = (char)(cs[n2] - 32);
                        }
                        v = new String(cs);
                    } else {
                        v = temp;
                    }
                    try {
                        font.style |= Style.valueOf(v);
                        continue;
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new FontParseException("Property " + v + " not support.");
                    }
                }
                if (size > 0) {
                    font.size = size;
                    if (i + 1 >= values.length) {
                        throw new FontParseException("Font family must after size.");
                    }
                    font.name = values[++i].trim().replace('+', ' ');
                    beforeSize = false;
                    continue;
                }
                throw new FontParseException("Font size must be greater than zero.");
            }
            if (temp.indexOf(35) == 0) {
                font.color = Color.decode(temp);
                continue;
            }
            try {
                Field field = Color.class.getDeclaredField(temp);
                font.color = (Color)field.get(null);
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ColorParseException("Color \"" + temp + "\" not support.");
            }
        }
        return font;
    }

    public int getSize() {
        return this.size;
    }

    public Font setSize(int size) {
        this.size = size;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Font setName(String name) {
        this.name = name;
        return this;
    }

    public int getFamily() {
        return this.family;
    }

    public Font setFamily(int family) {
        this.family = family;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public Font setColor(Color color) {
        this.color = color;
        return this;
    }

    public int getStyle() {
        return this.style;
    }

    public Font setStyle(int style) {
        this.style = style;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Font setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public int getCharset() {
        return this.charset;
    }

    public Font setCharset(int charset) {
        this.charset = charset;
        return this;
    }

    public Font italic() {
        this.style |= 4;
        return this;
    }

    public Font bold() {
        this.style |= 2;
        return this;
    }

    public Font underLine() {
        this.style |= 1;
        return this;
    }

    public boolean isItalic() {
        return (this.style & 4) == 4;
    }

    public boolean isBold() {
        return (this.style & 2) == 2;
    }

    public boolean isUnderLine() {
        return (this.style & 1) == 1;
    }

    public Font delItalic() {
        this.style &= 3;
        return this;
    }

    public Font delBold() {
        this.style &= 5;
        return this;
    }

    public Font delUnderLine() {
        this.style &= 6;
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<font>").append(Const.lineSeparator);
        buf.append("    <sz val=\"").append(this.size).append("\"/>").append(Const.lineSeparator);
        if (this.color != null) {
            int index = ColorIndex.indexOf(this.color.getRGB());
            if (index == -1) {
                buf.append("    <color rgb=\"").append(ColorIndex.toARGB(this.color.getRGB())).append("\"/>").append(Const.lineSeparator);
            } else {
                buf.append("    <color indexed=\"").append(index).append("\"/>").append(Const.lineSeparator);
            }
        }
        buf.append("    <name val=\"").append(this.name).append("\"/>").append(Const.lineSeparator);
        switch (this.style) {
            case 1: {
                buf.append("    <u/>").append(Const.lineSeparator);
                break;
            }
            case 2: {
                buf.append("    <b/>").append(Const.lineSeparator);
                break;
            }
            case 4: {
                buf.append("    <i/>").append(Const.lineSeparator);
                break;
            }
            case 3: {
                buf.append("    <u/>").append(Const.lineSeparator);
                buf.append("    <b/>").append(Const.lineSeparator);
                break;
            }
            case 5: {
                buf.append("    <i/>").append(Const.lineSeparator);
                buf.append("    <u/>").append(Const.lineSeparator);
                break;
            }
            case 6: {
                buf.append("    <b/>").append(Const.lineSeparator);
                buf.append("    <i/>").append(Const.lineSeparator);
                break;
            }
            case 7: {
                buf.append("    <i/>").append(Const.lineSeparator);
                buf.append("    <b/>").append(Const.lineSeparator);
                buf.append("    <u/>").append(Const.lineSeparator);
            }
        }
        if (this.charset > 0) {
            buf.append("    <charset val=\"").append(this.charset).append("\"/>").append(Const.lineSeparator);
        }
        if (StringUtil.isNotEmpty(this.scheme)) {
            buf.append("    <scheme val=\"").append(this.scheme).append("\"/>").append(Const.lineSeparator);
        }
        return buf.append("</font>").toString();
    }

    public int hashCode() {
        int hash = this.style << 24;
        hash += this.size << 16;
        hash += this.name.hashCode() << 8;
        return hash += this.color.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Font) {
            Font other = (Font)o;
            return other.family == this.family && other.style == this.style && other.size == this.size && Objects.equals(other.color, this.color) && Objects.equals(other.name, this.name);
        }
        return false;
    }

    public Element toDom4j(Element root) {
        Element element = root.addElement(StringUtil.lowFirstKey(this.getClass().getSimpleName()));
        element.addElement("sz").addAttribute("val", String.valueOf(this.size));
        element.addElement("name").addAttribute("val", this.name);
        if (this.color != null) {
            int index = ColorIndex.indexOf(this.color);
            if (index > -1) {
                element.addElement("color").addAttribute("indexed", String.valueOf(index));
            } else {
                element.addElement("color").addAttribute("rgb", ColorIndex.toARGB(this.color));
            }
        }
        if (this.isBold()) {
            element.addElement("b");
        }
        if (this.isItalic()) {
            element.addElement("i");
        }
        if (this.isUnderLine()) {
            element.addElement("u");
        }
        if (this.family > 0) {
            element.addElement("family").addAttribute("val", String.valueOf(this.family));
        }
        if (StringUtil.isNotEmpty(this.scheme)) {
            element.addElement("scheme").addAttribute("val", this.scheme);
        }
        if (this.charset > 0) {
            element.addElement("charset").addAttribute("val", String.valueOf(this.charset));
        }
        return element;
    }

    public Font clone() {
        Font other;
        try {
            other = (Font)super.clone();
        }
        catch (CloneNotSupportedException e) {
            other = new Font();
            other.family = this.family;
            other.charset = this.charset;
            other.name = this.name;
            other.scheme = this.scheme;
        }
        if (this.color != null) {
            other.color = new Color(this.color.getRGB());
        }
        return other;
    }

    public static class Style {
        public static final int NORMAL = 0;
        public static final int ITALIC = 4;
        public static final int BOLD = 2;
        public static final int UNDERLINE = 1;

        public static int valueOf(String name) throws NoSuchFieldException, IllegalAccessException {
            Field field = Style.class.getDeclaredField(name.toUpperCase());
            return field.getInt(null);
        }
    }
}

