/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.common.hash;

import org.ttzero.excel.common.hash.HashFunction;
import org.ttzero.excel.common.hash.MessageDigestHashFunction;
import org.ttzero.excel.common.hash.Murmur3_128HashFunction;
import org.ttzero.excel.common.hash.Murmur3_32HashFunction;

public final class Hashing {
    public static HashFunction murmur3_32() {
        return Murmur3_32HashFunction.MURMUR3_32;
    }

    public static HashFunction murmur3_128(int seed) {
        return new Murmur3_128HashFunction(seed);
    }

    public static HashFunction murmur3_128() {
        return Murmur3_128HashFunction.MURMUR3_128;
    }

    @Deprecated
    public static HashFunction md5() {
        return Md5Holder.MD5;
    }

    @Deprecated
    public static HashFunction sha1() {
        return Sha1Holder.SHA_1;
    }

    public static HashFunction sha512() {
        return Sha512Holder.SHA_512;
    }

    private Hashing() {
    }

    private static class Sha512Holder {
        static final HashFunction SHA_512 = new MessageDigestHashFunction("SHA-512", "Hashing.sha512()");

        private Sha512Holder() {
        }
    }

    private static class Sha1Holder {
        static final HashFunction SHA_1 = new MessageDigestHashFunction("SHA-1", "Hashing.sha1()");

        private Sha1Holder() {
        }
    }

    private static class Md5Holder {
        static final HashFunction MD5 = new MessageDigestHashFunction("MD5", "Hashing.md5()");

        private Md5Holder() {
        }
    }
}

