/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.common.hash;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.ttzero.excel.common.hash.LongAddable;
import org.ttzero.excel.common.hash.LongAdder;

final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    LongAddables() {
    }

    public static LongAddable create() {
        return SUPPLIER.get();
    }

    static {
        Supplier<LongAddable> supplier;
        try {
            new LongAdder();
            supplier = LongAdder::new;
        }
        catch (Throwable t) {
            supplier = () -> new PureJavaLongAddable();
        }
        SUPPLIER = supplier;
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x) {
            this.getAndAdd(x);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

