/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.csv;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;

public class CSVCellValueAndStyle
implements ICellValueAndStyle {
    @Override
    @Deprecated
    public void reset(int row, Cell cell, Object e, Column hc) {
        this.setCellValue(row, cell, e, hc, hc.getClazz(), hc.processor != null);
    }

    @Override
    public <T> void setStyleDesign(T o, Cell cell, Column hc, StyleProcessor<T> styleProcessor) {
    }

    @Override
    public String getFileSuffix() {
        return ".csv";
    }

    @Override
    public void setCellValue(int row, Cell cell, Object e, Column hc, Class<?> clazz, boolean hasProcessor) {
        if (hasProcessor) {
            this.conversion(row, cell, e, hc);
            return;
        }
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        if (IWorksheetWriter.isString(clazz)) {
            cell.setSv(e.toString());
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setSv(DateUtil.toDateString((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setSv(DateUtil.toString((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            cell.setCv(((Character)e).charValue());
        } else if (IWorksheetWriter.isShort(clazz)) {
            cell.setNv(((Short)e).shortValue());
        } else if (IWorksheetWriter.isInt(clazz)) {
            cell.setNv((Integer)e);
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLv((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDv(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDv((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBv((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setMv((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setSv(((LocalDate)e).toString());
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setSv(DateUtil.LOCAL_DATE_TIME.format((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setSv(DateTimeFormatter.ISO_TIME.format(((Time)e).toLocalTime()));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setSv(DateTimeFormatter.ISO_TIME.format((LocalTime)e));
        } else {
            cell.setSv(e.toString());
        }
    }

    @Override
    public int getStyleIndex(Row row, Column hc, Object o) {
        return 0;
    }

    @Override
    @Deprecated
    public int getStyleIndex(int rows, Column hc, Object o) {
        return 0;
    }
}

