/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public class Cell {
    public static final char SST = 's';
    public static final char BOOL = 'b';
    public static final char FUNCTION = 'f';
    public static final char INLINESTR = 'r';
    public static final char LONG = 'l';
    public static final char DOUBLE = 'd';
    public static final char NUMERIC = 'n';
    public static final char BLANK = 'k';
    public static final char CHARACTER = 'c';
    public static final char DECIMAL = 'm';
    public static final char DATETIME = 'i';
    public static final char DATE = 'a';
    public static final char TIME = 't';
    public static final char UNALLOCATED = '\u0000';
    public static final char EMPTY_TAG = 'e';
    public static final char BINARY = 'y';
    public static final char FILE = 'x';
    public static final char INPUT_STREAM = 'p';
    public static final char REMOTE_URL = 'u';
    public static final char BYTE_BUFFER = 'o';
    public static final Cell UNALLOCATED_CELL = new Cell();
    public char t;
    public String sv;
    public int nv;
    public long lv;
    public double dv;
    public boolean bv;
    public char cv;
    public BigDecimal mv;
    public int xf;
    public String fv;
    public int si;
    public boolean f;
    public byte[] binary;
    public ByteBuffer byteBuffer;
    public Path path;
    public InputStream isv;
    public transient short i;

    public Cell() {
    }

    public Cell(short i) {
        this.i = i;
    }

    public Cell(int i) {
        this.i = (short)(i & Short.MAX_VALUE);
    }

    public Cell setT(char t) {
        this.t = t;
        return this;
    }

    public Cell setSv(String sv) {
        this.t = (char)114;
        this.sv = sv;
        return this;
    }

    public Cell setNv(int nv) {
        this.t = (char)110;
        this.nv = nv;
        return this;
    }

    public Cell setDv(double dv) {
        this.t = (char)100;
        this.dv = dv;
        return this;
    }

    public Cell setBv(boolean bv) {
        this.t = (char)98;
        this.bv = bv;
        return this;
    }

    public Cell setCv(char c) {
        this.t = (char)99;
        this.cv = c;
        return this;
    }

    public Cell blank() {
        this.t = (char)107;
        return this;
    }

    public Cell emptyTag() {
        this.t = (char)101;
        return this;
    }

    public Cell setLv(long lv) {
        this.t = (char)108;
        this.lv = lv;
        return this;
    }

    public Cell setMv(BigDecimal mv) {
        this.t = (char)109;
        this.mv = mv;
        return this;
    }

    public Cell setIv(double i) {
        this.t = (char)105;
        this.dv = i;
        return this;
    }

    public Cell setAv(int a) {
        this.t = (char)97;
        this.nv = a;
        return this;
    }

    public Cell setTv(double t) {
        this.t = (char)116;
        this.dv = t;
        return this;
    }

    public Cell setBinary(byte[] bytes) {
        this.t = (char)121;
        this.binary = bytes;
        return this;
    }

    public Cell setPath(Path path) {
        this.t = (char)120;
        this.path = path;
        return this;
    }

    public Cell setInputStream(InputStream stream) {
        this.t = (char)112;
        this.isv = stream;
        return this;
    }

    public Cell setByteBuffer(ByteBuffer byteBuffer) {
        this.t = (char)111;
        this.byteBuffer = byteBuffer;
        return this;
    }

    public Cell clear() {
        this.t = '\u0000';
        this.sv = null;
        this.nv = 0;
        this.dv = 0.0;
        this.bv = false;
        this.lv = 0L;
        this.cv = '\u0000';
        this.mv = null;
        this.xf = 0;
        this.fv = null;
        this.f = false;
        this.si = -1;
        this.binary = null;
        this.path = null;
        this.isv = null;
        this.byteBuffer = null;
        return this;
    }

    public Cell from(Cell cell) {
        this.t = cell.t;
        this.sv = cell.sv;
        this.nv = cell.nv;
        this.dv = cell.dv;
        this.bv = cell.bv;
        this.lv = cell.lv;
        this.cv = cell.cv;
        this.mv = cell.mv;
        this.xf = cell.xf;
        this.fv = cell.fv;
        this.f = cell.f;
        this.si = cell.si;
        this.binary = cell.binary;
        this.path = cell.path;
        this.isv = cell.isv;
        this.byteBuffer = cell.byteBuffer;
        return this;
    }
}

